/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.core.container;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import net.lingala.zip4j.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import tech.powerjob.server.common.utils.OmsFileUtils;

public class ContainerTemplateGenerator {
    private static final String ORIGIN_FILE_NAME = "oms-template-origin";

    public static File generate(String group, String artifact, String name, String packageName, Integer javaVersion) throws IOException {
        String line;
        String workerDir = OmsFileUtils.genTemporaryWorkPath();
        File originJar = new File(workerDir + "tmp.jar");
        String tmpPath = workerDir + "/unzip/";
        try (InputStream is = ContainerTemplateGenerator.class.getClassLoader().getResourceAsStream("oms-template-origin.zip");){
            Objects.requireNonNull(is, "generate container template failed, can't find zip file in classpath.");
            FileUtils.copyInputStreamToFile((InputStream)is, (File)originJar);
        }
        ZipFile zipFile = new ZipFile(originJar);
        zipFile.extractAll(tmpPath);
        String rootPath = tmpPath + ORIGIN_FILE_NAME;
        String pomPath = rootPath + "/pom.xml";
        StringBuilder buffer = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new FileReader(pomPath));){
            while ((line = br.readLine()) != null) {
                if (line.contains("<groupId>groupId</groupId>")) {
                    buffer.append("    <groupId>").append(group).append("</groupId>");
                } else if (line.contains("<artifactId>artifactId</artifactId>")) {
                    buffer.append("    <artifactId>").append(artifact).append("</artifactId>");
                } else if (line.contains("<name>name</name>")) {
                    buffer.append("    <name>").append(name).append("</name>");
                } else if (line.contains("<maven.compiler.source>")) {
                    buffer.append("        <maven.compiler.source>").append(javaVersion).append("</maven.compiler.source>");
                } else if (line.contains("<maven.compiler.target>")) {
                    buffer.append("        <maven.compiler.target>").append(javaVersion).append("</maven.compiler.target>");
                } else {
                    buffer.append(line);
                }
                buffer.append(System.lineSeparator());
            }
        }
        OmsFileUtils.string2File((String)buffer.toString(), (File)new File(pomPath));
        String packagePath = StringUtils.replace((String)packageName, (String)".", (String)"/");
        String absPath = rootPath + "/src/main/java/" + packagePath;
        FileUtils.forceMkdir((File)new File(absPath));
        String resourcePath = rootPath + "/src/main/resources/";
        String springXMLPath = resourcePath + "oms-worker-container-spring-context.xml";
        buffer.setLength(0);
        try (BufferedReader br = new BufferedReader(new FileReader(springXMLPath));){
            while ((line = br.readLine()) != null) {
                if (line.contains("<context:component-scan base-package=\"")) {
                    buffer.append("    <context:component-scan base-package=\"").append(packageName).append("\"/>");
                } else {
                    buffer.append(line);
                }
                buffer.append(System.lineSeparator());
            }
        }
        OmsFileUtils.string2File((String)buffer.toString(), (File)new File(springXMLPath));
        String propertiesPath = resourcePath + "oms-worker-container.properties";
        String properties = "PACKAGE_NAME=" + packageName;
        OmsFileUtils.string2File((String)properties, (File)new File(propertiesPath));
        String finPath = tmpPath + "template.zip";
        ZipFile finZip = new ZipFile(finPath);
        finZip.addFolder(new File(rootPath));
        FileUtils.forceDelete((File)originJar);
        return finZip.getFile();
    }
}

