/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.core.container;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;
import tech.powerjob.common.PowerSerializable;
import tech.powerjob.common.model.DeployedContainerInfo;
import tech.powerjob.common.model.GitRepoInfo;
import tech.powerjob.common.request.ServerDeployContainerRequest;
import tech.powerjob.common.request.ServerDestroyContainerRequest;
import tech.powerjob.common.serialize.JsonUtils;
import tech.powerjob.common.utils.CommonUtils;
import tech.powerjob.common.utils.NetUtils;
import tech.powerjob.common.utils.SegmentLock;
import tech.powerjob.remote.framework.base.URL;
import tech.powerjob.server.common.constants.ContainerSourceType;
import tech.powerjob.server.common.constants.SwitchableStatus;
import tech.powerjob.server.common.module.WorkerInfo;
import tech.powerjob.server.common.utils.OmsFileUtils;
import tech.powerjob.server.extension.LockService;
import tech.powerjob.server.persistence.mongodb.GridFsManager;
import tech.powerjob.server.persistence.remote.model.ContainerInfoDO;
import tech.powerjob.server.persistence.remote.repository.ContainerInfoRepository;
import tech.powerjob.server.remote.server.redirector.DesignateServer;
import tech.powerjob.server.remote.transporter.TransportService;
import tech.powerjob.server.remote.transporter.impl.ServerURLFactory;
import tech.powerjob.server.remote.worker.WorkerClusterQueryService;

@Service
public class ContainerService {
    private static final Logger log = LoggerFactory.getLogger(ContainerService.class);
    @Resource
    private Environment environment;
    @Resource
    private LockService lockService;
    @Resource
    private ContainerInfoRepository containerInfoRepository;
    @Resource
    private GridFsManager gridFsManager;
    @Resource
    private TransportService transportService;
    @Resource
    private WorkerClusterQueryService workerClusterQueryService;
    private final SegmentLock segmentLock = new SegmentLock(4);
    private static final int DEPLOY_BATCH_NUM = 50;
    private static final long DEPLOY_MIN_INTERVAL = 600000L;
    private static final long DEPLOY_MAX_COST_TIME = 600000L;

    public void save(ContainerInfoDO container) {
        Long originId = container.getId();
        if (originId != null) {
            this.containerInfoRepository.findById((Object)originId).orElseThrow(() -> new IllegalArgumentException("can't find container by id: " + originId));
        } else {
            container.setGmtCreate(new Date());
        }
        container.setGmtModified(new Date());
        if (container.getSourceType().intValue() == ContainerSourceType.FatJar.getV()) {
            container.setVersion(container.getSourceInfo());
        } else {
            container.setVersion("init");
        }
        this.containerInfoRepository.saveAndFlush((Object)container);
    }

    public void delete(Long appId, Long containerId) {
        ContainerInfoDO container = (ContainerInfoDO)this.containerInfoRepository.findById((Object)containerId).orElseThrow(() -> new IllegalArgumentException("can't find container by id: " + containerId));
        if (!Objects.equals(appId, container.getAppId())) {
            throw new RuntimeException("Permission Denied!");
        }
        ServerDestroyContainerRequest destroyRequest = new ServerDestroyContainerRequest(container.getId());
        this.workerClusterQueryService.getAllAliveWorkers(container.getAppId()).forEach(workerInfo -> {
            URL url = ServerURLFactory.destroyContainer2Worker((String)workerInfo.getAddress());
            this.transportService.tell(workerInfo.getProtocol(), url, (PowerSerializable)destroyRequest);
        });
        log.info("[ContainerService] delete container: {}.", (Object)container);
        container.setStatus(Integer.valueOf(SwitchableStatus.DELETED.getV()));
        container.setGmtModified(new Date());
        this.containerInfoRepository.saveAndFlush((Object)container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadContainerJarFile(MultipartFile file) throws IOException {
        String workerDirStr = OmsFileUtils.genTemporaryWorkPath();
        String tmpFileStr = workerDirStr + "tmp.jar";
        File workerDir = new File(workerDirStr);
        File tmpFile = new File(tmpFileStr);
        try {
            FileUtils.forceMkdirParent((File)tmpFile);
            file.transferTo(tmpFile);
            String md5 = OmsFileUtils.md5((File)tmpFile);
            String fileName = ContainerService.genContainerJarName(md5);
            this.gridFsManager.store(tmpFile, "container", fileName);
            String finalFileStr = OmsFileUtils.genContainerJarPath() + fileName;
            File finalFile = new File(finalFileStr);
            if (finalFile.exists()) {
                FileUtils.forceDelete((File)finalFile);
            }
            FileUtils.moveFile((File)tmpFile, (File)finalFile);
            String string = md5;
            return string;
        }
        finally {
            CommonUtils.executeIgnoreException(() -> FileUtils.forceDelete((File)workerDir));
        }
    }

    public File fetchContainerJarFile(String version) {
        String fileName = ContainerService.genContainerJarName(version);
        String filePath = OmsFileUtils.genContainerJarPath() + fileName;
        File localFile = new File(filePath);
        if (localFile.exists()) {
            return localFile;
        }
        if (this.gridFsManager.available()) {
            this.downloadJarFromGridFS(fileName, localFile);
        }
        return localFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(Long containerId, Session session) throws Exception {
        String deployLock = "containerDeployLock-" + containerId;
        RemoteEndpoint.Async remote = session.getAsyncRemote();
        boolean lock = this.lockService.tryLock(deployLock, 600000L);
        if (!lock) {
            remote.sendText("SYSTEM: acquire deploy lock failed, maybe other user is deploying, please wait until the running deploy task finished.");
            return;
        }
        try {
            File jarFile;
            Optional containerInfoOpt = this.containerInfoRepository.findById((Object)containerId);
            if (!containerInfoOpt.isPresent()) {
                remote.sendText("SYSTEM: can't find container by id: " + containerId);
                return;
            }
            ContainerInfoDO container = (ContainerInfoDO)containerInfoOpt.get();
            Date lastDeployTime = container.getLastDeployTime();
            if (lastDeployTime != null && System.currentTimeMillis() - lastDeployTime.getTime() < 600000L) {
                remote.sendText("SYSTEM: [warn] deploy too frequent, last deploy time is: " + DateFormatUtils.format((Date)lastDeployTime, (String)"yyyy-MM-dd HH:mm:ss"));
            }
            if ((jarFile = this.prepareJarFile(container, session)) == null) {
                return;
            }
            double sizeMB = 1.0 * (double)jarFile.length() / 1048576.0;
            remote.sendText(String.format("SYSTEM: the jarFile(size=%fMB) is prepared and ready to be deployed to the worker.", sizeMB));
            Date now = new Date();
            container.setGmtModified(now);
            container.setLastDeployTime(now);
            this.containerInfoRepository.saveAndFlush((Object)container);
            remote.sendText(String.format("SYSTEM: update current container version=%s successfully!", container.getVersion()));
            List allAliveWorkers = this.workerClusterQueryService.getAllAliveWorkers(container.getAppId());
            if (allAliveWorkers.isEmpty()) {
                remote.sendText("SYSTEM: there is no worker available now, deploy failed!");
                return;
            }
            String port = this.environment.getProperty("local.server.port");
            String downloadURL = String.format("http://%s:%s/container/downloadJar?version=%s", NetUtils.getLocalHost(), port, container.getVersion());
            ServerDeployContainerRequest req = new ServerDeployContainerRequest(containerId, container.getContainerName(), container.getVersion(), downloadURL);
            long sleepTime = this.calculateSleepTime(jarFile.length());
            AtomicInteger count = new AtomicInteger();
            allAliveWorkers.forEach(workerInfo -> {
                URL url = ServerURLFactory.deployContainer2Worker((String)workerInfo.getAddress());
                this.transportService.tell(workerInfo.getProtocol(), url, (PowerSerializable)req);
                remote.sendText("SYSTEM: send deploy request to " + url.getAddress());
                if (count.incrementAndGet() % 50 == 0) {
                    CommonUtils.executeIgnoreException(() -> Thread.sleep(sleepTime));
                }
            });
            remote.sendText("SYSTEM: deploy finished, congratulations!");
        }
        finally {
            this.lockService.unlock(deployLock);
        }
    }

    @DesignateServer
    public String fetchDeployedInfo(Long appId, Long containerId) {
        List infoList = this.workerClusterQueryService.getDeployedContainerInfos(appId, containerId);
        Set aliveWorkers = this.workerClusterQueryService.getAllAliveWorkers(appId).stream().map(WorkerInfo::getAddress).collect(Collectors.toSet());
        LinkedHashSet deployedList = Sets.newLinkedHashSet();
        LinkedList unDeployedList = Lists.newLinkedList();
        ArrayListMultimap version2Address = ArrayListMultimap.create();
        infoList.forEach(arg_0 -> ContainerService.lambda$fetchDeployedInfo$6(aliveWorkers, deployedList, (Multimap)version2Address, unDeployedList, arg_0));
        StringBuilder sb = new StringBuilder("========== DeployedInfo ==========").append(System.lineSeparator());
        if (version2Address.keySet().size() > 1) {
            sb.append("WARN: there exists multi version container now, please redeploy to fix this problem").append(System.lineSeparator());
            sb.append("divisive version ==> ").append(System.lineSeparator());
            version2Address.forEach((v, addressList) -> {
                sb.append("version: ").append((String)v).append(System.lineSeparator());
                sb.append((String)addressList);
            });
            sb.append(System.lineSeparator());
        }
        if (!CollectionUtils.isEmpty((Collection)unDeployedList)) {
            sb.append("WARN: there exists unDeployed worker(OhMyScheduler will auto fix when some job need to process)").append(System.lineSeparator());
            sb.append("unDeployed worker list ==> ").append(System.lineSeparator());
        }
        sb.append("deployed worker list ==> ").append(System.lineSeparator());
        if (CollectionUtils.isEmpty((Collection)deployedList)) {
            sb.append("no worker deployed now~");
        } else {
            sb.append(deployedList);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File prepareJarFile(ContainerInfoDO container, Session session) throws Exception {
        RemoteEndpoint.Async remote = session.getAsyncRemote();
        ContainerSourceType sourceType = ContainerSourceType.of((int)container.getSourceType());
        if (sourceType == ContainerSourceType.Git) {
            String workerDirStr = OmsFileUtils.genTemporaryWorkPath();
            File workerDir = new File(workerDirStr);
            FileUtils.forceMkdir((File)workerDir);
            try {
                remote.sendText("SYSTEM: start to git clone the code repo, using config: " + container.getSourceInfo());
                GitRepoInfo gitRepoInfo = (GitRepoInfo)JsonUtils.parseObject((String)container.getSourceInfo(), GitRepoInfo.class);
                CloneCommand cloneCommand = Git.cloneRepository().setDirectory(workerDir).setURI(gitRepoInfo.getRepo()).setBranch(gitRepoInfo.getBranch());
                if (!StringUtils.isEmpty((CharSequence)gitRepoInfo.getUsername())) {
                    UsernamePasswordCredentialsProvider credentialsProvider = new UsernamePasswordCredentialsProvider(gitRepoInfo.getUsername(), gitRepoInfo.getPassword());
                    cloneCommand.setCredentialsProvider((CredentialsProvider)credentialsProvider);
                }
                cloneCommand.call();
                String oldVersion = container.getVersion();
                try (Repository repository = Git.open((File)workerDir).getRepository();){
                    Ref head = repository.getRefDatabase().findRef("HEAD");
                    container.setVersion(head.getObjectId().getName());
                }
                if (container.getVersion().equals(oldVersion)) {
                    remote.sendText(String.format("SYSTEM: this commitId(%s) is the same as the last.", oldVersion));
                } else {
                    remote.sendText(String.format("SYSTEM: new version detected, from %s to %s.", oldVersion, container.getVersion()));
                }
                remote.sendText("SYSTEM: git clone successfully, star to compile the project.");
                DefaultInvoker mvnInvoker = new DefaultInvoker();
                DefaultInvocationRequest ivkReq = new DefaultInvocationRequest();
                ivkReq.setGoals((List)Lists.newArrayList((Object[])new String[]{"clean", "package", "-DskipTests", "-U", "-e", "-B"}));
                ivkReq.setBaseDirectory(workerDir);
                ivkReq.setOutputHandler(arg_0 -> ((RemoteEndpoint.Async)remote).sendText(arg_0));
                ivkReq.setBatchMode(true);
                mvnInvoker.execute((InvocationRequest)ivkReq);
                String targetDirStr = workerDirStr + "/target";
                File targetDir = new File(targetDirStr);
                IOFileFilter fileFilter = FileFilterUtils.asFileFilter((dir, name) -> name.endsWith("jar-with-dependencies.jar"));
                Collection jarFile = FileUtils.listFiles((File)targetDir, (IOFileFilter)fileFilter, null);
                if (CollectionUtils.isEmpty((Collection)jarFile)) {
                    remote.sendText("SYSTEM: can't find packaged jar(maybe maven build failed), so deploy failed.");
                    File file = null;
                    return file;
                }
                File jarWithDependency = (File)jarFile.iterator().next();
                String jarFileName = ContainerService.genContainerJarName(container.getVersion());
                if (!this.gridFsManager.exists("container", jarFileName)) {
                    remote.sendText("SYSTEM: can't find the jar resource in remote, maybe this is a new version, start to upload new version.");
                    this.gridFsManager.store(jarWithDependency, "container", jarFileName);
                    remote.sendText("SYSTEM: upload to GridFS successfully~");
                } else {
                    remote.sendText("SYSTEM: find the jar resource in remote successfully, so it's no need to upload anymore.");
                }
                String localFileStr = OmsFileUtils.genContainerJarPath() + jarFileName;
                File localFile = new File(localFileStr);
                if (localFile.exists()) {
                    FileUtils.forceDelete((File)localFile);
                }
                FileUtils.copyFile((File)jarWithDependency, (File)localFile);
                File file = localFile;
                return file;
            }
            catch (Throwable t) {
                log.error("[ContainerService] prepareJarFile failed for container: {}", (Object)container, (Object)t);
                remote.sendText("SYSTEM: [ERROR] prepare jar file failed: " + ExceptionUtils.getStackTrace((Throwable)t));
            }
            finally {
                FileUtils.forceDelete((File)workerDir);
            }
        }
        String jarFileName = ContainerService.genContainerJarName(container.getVersion());
        String localFileStr = OmsFileUtils.genContainerJarPath() + jarFileName;
        File localFile = new File(localFileStr);
        if (localFile.exists()) {
            remote.sendText("SYSTEM: find the jar file in local disk.");
            return localFile;
        }
        remote.sendText(String.format("SYSTEM: try to find the jarFile(%s) in GridFS", jarFileName));
        this.downloadJarFromGridFS(jarFileName, localFile);
        remote.sendText("SYSTEM: download jar file from GridFS successfully~");
        return localFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadJarFromGridFS(String mongoFileName, File targetFile) {
        int lockId = mongoFileName.hashCode();
        try {
            this.segmentLock.lockInterruptibleSafe(lockId);
            if (targetFile.exists()) {
                return;
            }
            if (!this.gridFsManager.exists("container", mongoFileName)) {
                log.warn("[ContainerService] can't find container's jar file({}) in gridFS.", (Object)mongoFileName);
                return;
            }
            try {
                FileUtils.forceMkdirParent((File)targetFile);
                this.gridFsManager.download(targetFile, "container", mongoFileName);
            }
            catch (Exception e) {
                CommonUtils.executeIgnoreException(() -> FileUtils.forceDelete((File)targetFile));
                ExceptionUtils.rethrow((Throwable)e);
            }
        }
        finally {
            this.segmentLock.unlock(lockId);
        }
    }

    private static String genContainerJarName(String version) {
        return String.format("oms-container-%s.jar", version);
    }

    private long calculateSleepTime(long fileLength) {
        return (fileLength / 0x100000L / 10L + 1L) * 1000L;
    }

    private static /* synthetic */ void lambda$fetchDeployedInfo$6(Set aliveWorkers, Set deployedList, Multimap version2Address, List unDeployedList, DeployedContainerInfo info) {
        String targetWorkerAddress = info.getWorkerAddress();
        if (aliveWorkers.contains(targetWorkerAddress)) {
            deployedList.add(targetWorkerAddress);
            version2Address.put((Object)info.getVersion(), (Object)targetWorkerAddress);
        } else {
            unDeployedList.add(targetWorkerAddress);
        }
    }
}

