/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.remote.http;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpServer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.jackson.DatabindCodec;
import io.vertx.ext.web.RequestBody;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.enums.Protocol;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.remote.framework.actor.ActorInfo;
import tech.powerjob.remote.framework.actor.HandlerInfo;
import tech.powerjob.remote.framework.actor.ProcessType;
import tech.powerjob.remote.framework.cs.CSInitializer;
import tech.powerjob.remote.framework.cs.CSInitializerConfig;
import tech.powerjob.remote.framework.transporter.Transporter;
import tech.powerjob.remote.framework.utils.RemoteUtils;
import tech.powerjob.remote.http.vertx.VertxInitializer;
import tech.powerjob.remote.http.vertx.VertxTransporter;

public class HttpVertxCSInitializer
implements CSInitializer {
    private static final Logger log = LoggerFactory.getLogger(HttpVertxCSInitializer.class);
    private Vertx vertx;
    private HttpServer httpServer;
    private HttpClient httpClient;
    private CSInitializerConfig config;

    public String type() {
        return Protocol.HTTP.name();
    }

    public void init(CSInitializerConfig config) {
        this.config = config;
        try {
            DatabindCodec.mapper().configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true).configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true).configure(JsonParser.Feature.IGNORE_UNDEFINED, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
        catch (Throwable t) {
            log.warn("[HttpVertxCSInitializer] hack jackson failed!", t);
        }
        this.vertx = VertxInitializer.buildVertx();
        this.httpServer = VertxInitializer.buildHttpServer(this.vertx);
        this.httpClient = VertxInitializer.buildHttpClient(this.vertx);
    }

    public Transporter buildTransporter() {
        return new VertxTransporter(this.httpClient);
    }

    public void bindHandlers(List<ActorInfo> actorInfos) {
        Router router = Router.router((Vertx)this.vertx);
        router.route().handler((Handler)BodyHandler.create());
        actorInfos.forEach(actorInfo -> Optional.ofNullable(actorInfo.getHandlerInfos()).orElse(Collections.emptyList()).forEach(handlerInfo -> {
            String handlerHttpPath = handlerInfo.getLocation().toPath();
            ProcessType processType = handlerInfo.getAnno().processType();
            Handler<RoutingContext> routingContextHandler = this.buildRequestHandler((ActorInfo)actorInfo, (HandlerInfo)handlerInfo);
            Route route = router.post(handlerHttpPath);
            if (processType == ProcessType.BLOCKING) {
                route.blockingHandler(routingContextHandler, false);
            } else {
                route.handler(routingContextHandler);
            }
        }));
        int port = this.config.getBindAddress().getPort();
        String host = this.config.getBindAddress().getHost();
        this.httpServer.requestHandler((Handler)router).exceptionHandler(e -> log.error("[PowerJob] unknown exception in Actor communication!", e)).listen(port, host).toCompletionStage().toCompletableFuture().get(1L, TimeUnit.MINUTES);
        log.info("[PowerJobRemoteEngine] startup vertx HttpServer successfully!");
    }

    private Handler<RoutingContext> buildRequestHandler(ActorInfo actorInfo, HandlerInfo handlerInfo) {
        Method method = handlerInfo.getMethod();
        Optional powerSerializeClz = RemoteUtils.findPowerSerialize((Class[])method.getParameterTypes());
        if (!powerSerializeClz.isPresent()) {
            throw new PowerJobException("can't find any 'PowerSerialize' object in handler args: " + handlerInfo.getLocation());
        }
        return ctx -> {
            RequestBody body = ctx.body();
            Object convertResult = body.asPojo((Class)powerSerializeClz.get());
            try {
                Object response = method.invoke(actorInfo.getActor(), convertResult);
                if (response != null) {
                    if (response instanceof String) {
                        ctx.end((String)response);
                    } else {
                        ctx.json((Object)JsonObject.mapFrom((Object)response));
                    }
                    return;
                }
                ctx.end();
            }
            catch (Throwable t) {
                log.error("[PowerJob] invoke Handler[{}] failed!", (Object)handlerInfo.getLocation(), (Object)t);
                ctx.fail(HttpResponseStatus.INTERNAL_SERVER_ERROR.code(), t);
            }
        };
    }

    public void close() throws IOException {
        this.httpClient.close();
        this.httpServer.close();
        this.vertx.close();
    }
}

