/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.remote.http.vertx;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Future;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.json.JsonObject;
import java.util.concurrent.CompletionStage;
import tech.powerjob.common.PowerSerializable;
import tech.powerjob.remote.framework.base.RemotingException;
import tech.powerjob.remote.framework.base.URL;
import tech.powerjob.remote.framework.transporter.Protocol;
import tech.powerjob.remote.framework.transporter.Transporter;
import tech.powerjob.remote.http.HttpProtocol;

public class VertxTransporter
implements Transporter {
    private final HttpClient httpClient;
    private static final Protocol PROTOCOL = new HttpProtocol();

    public VertxTransporter(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public Protocol getProtocol() {
        return PROTOCOL;
    }

    public void tell(URL url, PowerSerializable request) {
        this.post(url, request, null);
    }

    public <T> CompletionStage<T> ask(URL url, PowerSerializable request, Class<T> clz) throws RemotingException {
        return this.post(url, request, clz);
    }

    private <T> CompletionStage<T> post(URL url, PowerSerializable request, Class<T> clz) {
        String host = url.getAddress().getHost();
        int port = url.getAddress().getPort();
        String path = url.getLocation().toPath();
        RequestOptions requestOptions = new RequestOptions().setMethod(HttpMethod.POST).setHost(host).setPort(Integer.valueOf(port)).setURI(path);
        Future httpClientRequestFuture = this.httpClient.request(requestOptions);
        Future responseFuture = httpClientRequestFuture.compose(httpClientRequest -> httpClientRequest.putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)HttpHeaderValues.APPLICATION_JSON).send(JsonObject.mapFrom((Object)request).toBuffer()));
        return responseFuture.compose(httpClientResponse -> {
            int statusCode = httpClientResponse.statusCode();
            if (statusCode != HttpResponseStatus.OK.code()) {
                throw new RemotingException(String.format("request [host:%s,port:%s,url:%s] failed, status: %d, msg: %s", host, port, path, statusCode, httpClientResponse.statusMessage()));
            }
            return httpClientResponse.body().compose(x -> {
                if (clz == null) {
                    return Future.succeededFuture(null);
                }
                if (clz.equals(String.class)) {
                    return Future.succeededFuture((Object)x.toString());
                }
                return Future.succeededFuture((Object)x.toJsonObject().mapTo(clz));
            });
        }).toCompletionStage();
    }
}

