/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.remote.framework.engine.impl;

import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.utils.SysUtils;
import tech.powerjob.remote.framework.actor.ActorInfo;
import tech.powerjob.remote.framework.actor.TestActor;
import tech.powerjob.remote.framework.cs.CSInitializer;
import tech.powerjob.remote.framework.cs.CSInitializerConfig;
import tech.powerjob.remote.framework.engine.EngineConfig;
import tech.powerjob.remote.framework.engine.EngineOutput;
import tech.powerjob.remote.framework.engine.RemoteEngine;
import tech.powerjob.remote.framework.engine.impl.ActorFactory;
import tech.powerjob.remote.framework.engine.impl.CSInitializerFactory;
import tech.powerjob.remote.framework.transporter.Transporter;

public class PowerJobRemoteEngine
implements RemoteEngine {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PowerJobRemoteEngine.class);
    private CSInitializer csInitializer;

    @Override
    public EngineOutput start(EngineConfig engineConfig) {
        PowerJobRemoteEngine.reConfig(engineConfig);
        String engineType = engineConfig.getType();
        EngineOutput engineOutput = new EngineOutput();
        log.info("[PowerJobRemoteEngine] [{}] start remote engine with config: {}", (Object)engineType, (Object)engineConfig);
        List<ActorInfo> actorInfos = ActorFactory.load(engineConfig.getActorList());
        this.csInitializer = CSInitializerFactory.build(engineType);
        String type = this.csInitializer.type();
        Stopwatch sw = Stopwatch.createStarted();
        log.info("[PowerJobRemoteEngine] [{}] try to startup CSInitializer[type={}]", (Object)engineType, (Object)type);
        this.csInitializer.init(new CSInitializerConfig().setBindAddress(engineConfig.getBindAddress()).setExternalAddress(engineConfig.getExternalAddress()).setServerType(engineConfig.getServerType()));
        Transporter transporter = this.csInitializer.buildTransporter();
        engineOutput.setTransporter(transporter);
        log.info("[PowerJobRemoteEngine] [{}] start to bind Handler", (Object)engineType);
        actorInfos.forEach(actor -> actor.getHandlerInfos().forEach(handlerInfo -> log.info("[PowerJobRemoteEngine] [{}] PATH={}, handler={}", new Object[]{engineType, handlerInfo.getLocation().toPath(), handlerInfo.getMethod()})));
        this.csInitializer.bindHandlers(actorInfos);
        log.info("[PowerJobRemoteEngine] [{}] startup successfully, cost: {}", (Object)engineType, (Object)sw);
        return engineOutput;
    }

    @Override
    public void close() throws IOException {
        this.csInitializer.close();
    }

    private static void reConfig(EngineConfig engineConfig) {
        boolean testEnv = SysUtils.isTestEnv();
        if (testEnv) {
            log.info("[PowerJobRemoteEngine] add 'TestActor' due to current is test env");
            engineConfig.getActorList().add(new TestActor());
        }
    }
}

