/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.client.service.impl;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Cache;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.client.ClientConfig;
import tech.powerjob.client.common.Protocol;
import tech.powerjob.client.service.HttpResponse;
import tech.powerjob.client.service.PowerRequestBody;
import tech.powerjob.client.service.impl.AppAuthClusterRequestService;
import tech.powerjob.client.service.impl.ClusterRequestService;
import tech.powerjob.common.serialize.JsonUtils;

public class ClusterRequestServiceOkHttp3Impl
extends AppAuthClusterRequestService {
    private static final Logger log = LoggerFactory.getLogger(ClusterRequestServiceOkHttp3Impl.class);
    private final OkHttpClient okHttpClient;

    public ClusterRequestServiceOkHttp3Impl(ClientConfig config) {
        super(config);
        this.okHttpClient = Protocol.HTTPS.equals((Object)config.getProtocol()) ? this.initHttpsNoVerifyClient() : this.initHttpClient();
    }

    @Override
    protected HttpResponse sendHttpRequest(String url, PowerRequestBody powerRequestBody) throws IOException {
        powerRequestBody.addHeaders(this.config.getDefaultHeaders());
        Object obj = powerRequestBody.getPayload();
        RequestBody requestBody = null;
        switch (powerRequestBody.getMime()) {
            case APPLICATION_JSON: {
                MediaType jsonType = MediaType.parse((String)"application/json; charset=utf-8");
                String body = obj instanceof String ? (String)obj : JsonUtils.toJSONStringUnsafe((Object)obj);
                requestBody = RequestBody.create((MediaType)jsonType, (String)body);
                break;
            }
            case APPLICATION_FORM: {
                FormBody.Builder formBuilder = new FormBody.Builder();
                Map formObj = (Map)obj;
                formObj.forEach((arg_0, arg_1) -> ((FormBody.Builder)formBuilder).add(arg_0, arg_1));
                requestBody = formBuilder.build();
            }
        }
        Request request = new Request.Builder().post(requestBody).headers(Headers.of(powerRequestBody.getHeaders())).url(url).build();
        try (Response response = this.okHttpClient.newCall(request).execute();){
            int code = response.code();
            HttpResponse httpResponse = new HttpResponse().setCode(code).setSuccess(code == 200);
            ResponseBody body = response.body();
            if (body != null) {
                httpResponse.setResponse(body.string());
            }
            Headers respHeaders = response.headers();
            Set headerNames = respHeaders.names();
            HashMap respHeaderMap = Maps.newHashMap();
            headerNames.forEach(hdKey -> respHeaderMap.put(hdKey, respHeaders.get(hdKey)));
            httpResponse.setHeaders(respHeaderMap);
            HttpResponse httpResponse2 = httpResponse;
            return httpResponse2;
        }
    }

    private OkHttpClient initHttpClient() {
        OkHttpClient.Builder okHttpBuilder = this.commonOkHttpBuilder();
        return okHttpBuilder.build();
    }

    private OkHttpClient initHttpsNoVerifyClient() {
        ClusterRequestService.NoVerifyX509TrustManager trustManager = new ClusterRequestService.NoVerifyX509TrustManager();
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, new TrustManager[]{trustManager}, new SecureRandom());
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
        OkHttpClient.Builder okHttpBuilder = this.commonOkHttpBuilder();
        okHttpBuilder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustManager);
        okHttpBuilder.hostnameVerifier((hostname, session) -> true);
        return okHttpBuilder.build();
    }

    private OkHttpClient.Builder commonOkHttpBuilder() {
        return new OkHttpClient.Builder().readTimeout((long)Optional.ofNullable(this.config.getReadTimeout()).orElse(DEFAULT_TIMEOUT_SECONDS).intValue(), TimeUnit.SECONDS).writeTimeout((long)Optional.ofNullable(this.config.getWriteTimeout()).orElse(DEFAULT_TIMEOUT_SECONDS).intValue(), TimeUnit.SECONDS).connectTimeout((long)Optional.ofNullable(this.config.getConnectionTimeout()).orElse(DEFAULT_TIMEOUT_SECONDS).intValue(), TimeUnit.SECONDS).callTimeout((long)Optional.ofNullable(this.config.getConnectionTimeout()).orElse(DEFAULT_TIMEOUT_SECONDS).intValue(), TimeUnit.SECONDS);
    }

    @Override
    public void close() throws IOException {
        this.okHttpClient.dispatcher().executorService().shutdown();
        this.okHttpClient.connectionPool().evictAll();
        Cache cache = this.okHttpClient.cache();
        if (cache != null) {
            cache.close();
        }
    }
}

