/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.client.service.impl;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.client.ClientConfig;
import tech.powerjob.client.extension.ClientExtension;
import tech.powerjob.client.extension.ExtensionContext;
import tech.powerjob.client.service.HttpResponse;
import tech.powerjob.client.service.PowerRequestBody;
import tech.powerjob.client.service.RequestService;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.common.utils.CollectionUtils;

abstract class ClusterRequestService
implements RequestService {
    private static final Logger log = LoggerFactory.getLogger(ClusterRequestService.class);
    protected final ClientConfig config;
    protected String currentAddress;
    protected static final String URL_PATTERN = "%s://%s%s%s";
    protected static final Integer DEFAULT_TIMEOUT_SECONDS = 2;
    protected static final int HTTP_SUCCESS_CODE = 200;

    public ClusterRequestService(ClientConfig config) {
        this.config = config;
        this.currentAddress = config.getAddressList().get(0);
    }

    protected abstract HttpResponse sendHttpRequest(String var1, PowerRequestBody var2) throws IOException;

    protected HttpResponse clusterHaRequest(String path, PowerRequestBody powerRequestBody) {
        String url = this.getUrl(path, this.currentAddress);
        try {
            return this.sendHttpRequest(url, powerRequestBody);
        }
        catch (IOException e) {
            log.warn("[ClusterRequestService] request url:{} failed, reason is {}.", (Object)url, (Object)e.toString());
            List<String> addressList = this.fetchAddressList();
            for (String addr : addressList) {
                if (Objects.equals(addr, this.currentAddress)) continue;
                url = this.getUrl(path, addr);
                try {
                    HttpResponse res = this.sendHttpRequest(url, powerRequestBody);
                    log.warn("[ClusterRequestService] server change: from({}) -> to({}).", (Object)this.currentAddress, (Object)addr);
                    this.currentAddress = addr;
                    return res;
                }
                catch (IOException e2) {
                    log.warn("[ClusterRequestService] request url:{} failed, reason is {}.", (Object)url, (Object)e2.toString());
                }
            }
            log.error("[ClusterRequestService] do post for path: {} failed because of no server available in {}.", (Object)path, addressList);
            throw new PowerJobException("no server available when send post request");
        }
    }

    private List<String> fetchAddressList() {
        List<String> addressList;
        ClientExtension clientExtension = this.config.getClientExtension();
        if (clientExtension != null && !CollectionUtils.isEmpty(addressList = clientExtension.addressProvider(new ExtensionContext()))) {
            return addressList;
        }
        return this.config.getAddressList();
    }

    private String getUrl(String path, String address) {
        String protocol = this.config.getProtocol().getProtocol();
        return String.format(URL_PATTERN, protocol, address, "/openApi", path);
    }

    protected static class NoVerifyX509TrustManager
    implements X509TrustManager {
        protected NoVerifyX509TrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

