/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refaster.util;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import java.util.Collection;

public final class ThrowsCheckedException
implements Matcher<ExpressionTree> {
    private static final long serialVersionUID = 1L;

    public boolean matches(ExpressionTree tree, VisitorState state) {
        return ThrowsCheckedException.containsCheckedException(ThrowsCheckedException.getThrownTypes(tree, state), state);
    }

    private static Collection<Type> getThrownTypes(ExpressionTree tree, VisitorState state) {
        if (tree instanceof LambdaExpressionTree) {
            return ASTHelpers.getThrownExceptions((Tree)((LambdaExpressionTree)tree).getBody(), (VisitorState)state);
        }
        if (tree instanceof MemberReferenceTree) {
            Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
            if (symbol == null) {
                return ImmutableSet.of();
            }
            return symbol.type.getThrownTypes();
        }
        Type type = ASTHelpers.getType((Tree)tree);
        if (type == null) {
            return ImmutableSet.of();
        }
        try {
            return state.getTypes().findDescriptorType(type).getThrownTypes();
        }
        catch (Types.FunctionDescriptorLookupError e) {
            return ImmutableSet.of();
        }
    }

    private static boolean containsCheckedException(Collection<Type> types, VisitorState state) {
        return !types.stream().allMatch(t -> ASTHelpers.isSubtype((Type)t, (Type)state.getSymtab().runtimeExceptionType, (VisitorState)state) || ASTHelpers.isSubtype((Type)t, (Type)state.getSymtab().errorType, (VisitorState)state));
    }
}

