/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refaster.matchers;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.FieldMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.tools.javac.code.Symbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.stream.BaseStream;

public final class IsEmpty
implements Matcher<ExpressionTree> {
    private static final long serialVersionUID = 1L;
    private static final Integer ZERO = 0;
    private static final Pattern EMPTY_INSTANCE_FACTORY_METHOD_PATTERN = Pattern.compile("empty.*");
    private static final Matcher<Tree> EMPTY_COLLECTION_CONSTRUCTOR_ARGUMENT = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isPrimitiveType(), Matchers.isSubtypeOf(Comparator.class)});
    private static final TypePredicate REGULAR_CONTAINER_TYPE = TypePredicates.anyOf((TypePredicate[])new TypePredicate[]{TypePredicates.isDescendantOfAny((Iterable)ImmutableList.of((Object)BaseStream.class.getCanonicalName(), (Object)Iterable.class.getCanonicalName(), (Object)Iterator.class.getCanonicalName(), (Object)Map.class.getCanonicalName(), (Object)Multimap.class.getCanonicalName(), (Object)Optional.class.getCanonicalName(), (Object)OptionalDouble.class.getCanonicalName(), (Object)OptionalInt.class.getCanonicalName(), (Object)OptionalLong.class.getCanonicalName(), (Object)Spliterator.class.getCanonicalName())), TypePredicates.isArray()});
    private static final TypePredicate REACTOR_CONTAINER_TYPE = TypePredicates.anyOf((TypePredicate[])new TypePredicate[]{TypePredicates.isDescendantOfAny((Iterable)ImmutableList.of((Object)"reactor.core.publisher.Flux", (Object)"reactor.core.publisher.Mono", (Object)"reactor.util.context.ContextView")), TypePredicates.isArray()});
    private static final TypePredicate CONTAINER_TYPE = TypePredicates.anyOf((TypePredicate[])new TypePredicate[]{REGULAR_CONTAINER_TYPE, REACTOR_CONTAINER_TYPE});
    private static final Matcher<ExpressionTree> MUTABLE_COLLECTION_TYPE = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isSameType(ArrayList.class), Matchers.isSameType(HashMap.class), Matchers.isSameType(HashSet.class), Matchers.isSameType(LinkedHashMap.class), Matchers.isSameType(LinkedHashSet.class), Matchers.isSameType(LinkedList.class), Matchers.isSameType(Stack.class), Matchers.isSameType(TreeMap.class), Matchers.isSameType(TreeSet.class), Matchers.isSameType(Vector.class)});
    private static final Matcher<ExpressionTree> EMPTY_INSTANCE_FACTORY = Matchers.anyOf((Matcher[])new Matcher[]{FieldMatchers.staticField((String)Collections.class.getCanonicalName(), (String)"EMPTY_LIST"), FieldMatchers.staticField((String)Collections.class.getCanonicalName(), (String)"EMPTY_MAP"), FieldMatchers.staticField((String)Collections.class.getCanonicalName(), (String)"EMPTY_SET"), Matchers.toType(MethodInvocationTree.class, (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.argumentCount((int)0), Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass(CONTAINER_TYPE).namedAnyOf(new String[]{"empty", "just", "of", "ofEntries"}), Matchers.staticMethod().onClassAny(new String[]{Collections.class.getCanonicalName(), Spliterators.class.getCanonicalName()}).withNameMatching(EMPTY_INSTANCE_FACTORY_METHOD_PATTERN)})}))});
    private static final Matcher<ExpressionTree> EMPTY_DERIVATIVE = Matchers.toType(MethodInvocationTree.class, (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.anyOf((Matcher[])new Matcher[]{IsEmpty.symbolReturns(REGULAR_CONTAINER_TYPE), Matchers.allOf((Matcher[])new Matcher[]{IsEmpty.symbolReturns(REACTOR_CONTAINER_TYPE), Matchers.instanceMethod().anyClass().namedAnyOf(new String[]{"readOnly", "delete"})})}), Matchers.receiverOfInvocation((Matcher)new IsEmpty())}));

    public boolean matches(ExpressionTree tree, VisitorState state) {
        ParenthesizedTree parenthesized;
        TypeCastTree typeCast;
        return IsEmpty.isEmptyArrayCreation(tree) || this.isEmptyCollectionConstructor(tree, state) || EMPTY_INSTANCE_FACTORY.matches((Tree)tree, state) || tree instanceof TypeCastTree && this.matches((typeCast = (TypeCastTree)tree).getExpression(), state) || tree instanceof ParenthesizedTree && this.matches((parenthesized = (ParenthesizedTree)tree).getExpression(), state) || EMPTY_DERIVATIVE.matches((Tree)tree, state);
    }

    private boolean isEmptyCollectionConstructor(ExpressionTree tree, VisitorState state) {
        NewClassTree newClassTree;
        block5: {
            block4: {
                if (!(tree instanceof NewClassTree)) break block4;
                newClassTree = (NewClassTree)tree;
                if (MUTABLE_COLLECTION_TYPE.matches((Tree)tree, state)) break block5;
            }
            return false;
        }
        List<? extends ExpressionTree> arguments = newClassTree.getArguments();
        if (arguments.stream().allMatch(a -> EMPTY_COLLECTION_CONSTRUCTOR_ARGUMENT.matches((Tree)a, state))) {
            return true;
        }
        Verify.verify((arguments.size() == 1 ? 1 : 0) != 0, (String)"Unexpected %s-ary constructor", (int)arguments.size());
        return this.matches(arguments.get(0), state);
    }

    private static boolean isEmptyArrayCreation(ExpressionTree tree) {
        if (!(tree instanceof NewArrayTree)) {
            return false;
        }
        NewArrayTree newArray = (NewArrayTree)tree;
        return !newArray.getDimensions().isEmpty() && ZERO.equals(ASTHelpers.constValue((Tree)newArray.getDimensions().get(0), Integer.class)) || newArray.getInitializers() != null && newArray.getInitializers().isEmpty();
    }

    private static Matcher<MethodInvocationTree> symbolReturns(TypePredicate predicate) {
        return Matchers.symbolMatcher((symbol, state) -> predicate.apply(((Symbol.MethodSymbol)symbol).getReturnType(), state));
    }
}

