/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refaster.matchers;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.FieldMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public final class IsEmpty
implements Matcher<ExpressionTree> {
    private static final long serialVersionUID = 1L;
    private static final Integer ZERO = 0;
    private static final Pattern EMPTY_INSTANCE_FACTORY_METHOD_PATTERN = Pattern.compile("empty.*");
    private static final Matcher<Tree> EMPTY_COLLECTION_CONSTRUCTOR_ARGUMENT = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isPrimitiveType(), Matchers.isSubtypeOf(Comparator.class)});
    private static final Matcher<ExpressionTree> MUTABLE_COLLECTION_TYPE = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isSameType(ArrayList.class), Matchers.isSameType(HashMap.class), Matchers.isSameType(HashSet.class), Matchers.isSameType(LinkedHashMap.class), Matchers.isSameType(LinkedHashSet.class), Matchers.isSameType(LinkedList.class), Matchers.isSameType(Stack.class), Matchers.isSameType(TreeMap.class), Matchers.isSameType(TreeSet.class), Matchers.isSameType(Vector.class)});
    private static final Matcher<ExpressionTree> EMPTY_INSTANCE_FACTORY = Matchers.anyOf((Matcher[])new Matcher[]{FieldMatchers.staticField((String)Collections.class.getCanonicalName(), (String)"EMPTY_LIST"), FieldMatchers.staticField((String)Collections.class.getCanonicalName(), (String)"EMPTY_MAP"), FieldMatchers.staticField((String)Collections.class.getCanonicalName(), (String)"EMPTY_SET"), Matchers.toType(MethodInvocationTree.class, (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.argumentCount((int)0), Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass(Collections.class.getCanonicalName()).withNameMatching(EMPTY_INSTANCE_FACTORY_METHOD_PATTERN), Matchers.staticMethod().onDescendantOfAny(new String[]{ImmutableCollection.class.getCanonicalName(), ImmutableMap.class.getCanonicalName(), ImmutableMultimap.class.getCanonicalName(), List.class.getCanonicalName(), Map.class.getCanonicalName(), Set.class.getCanonicalName(), Stream.class.getCanonicalName()}).named("of"), Matchers.staticMethod().onClassAny(new String[]{Stream.class.getCanonicalName(), "reactor.core.publisher.Flux", "reactor.core.publisher.Mono", "reactor.util.context.Context"}).named("empty"), Matchers.staticMethod().onDescendantOf("reactor.core.publisher.Flux").named("just")})}))});

    public boolean matches(ExpressionTree tree, VisitorState state) {
        return IsEmpty.isEmptyArrayCreation(tree) || EMPTY_INSTANCE_FACTORY.matches((Tree)tree, state) || this.isEmptyCollectionConstructor(tree, state);
    }

    private boolean isEmptyCollectionConstructor(ExpressionTree tree, VisitorState state) {
        NewClassTree newClassTree;
        block5: {
            block4: {
                if (!(tree instanceof NewClassTree)) break block4;
                newClassTree = (NewClassTree)tree;
                if (MUTABLE_COLLECTION_TYPE.matches((Tree)tree, state)) break block5;
            }
            return false;
        }
        List<? extends ExpressionTree> arguments = newClassTree.getArguments();
        if (arguments.stream().allMatch(a -> EMPTY_COLLECTION_CONSTRUCTOR_ARGUMENT.matches((Tree)a, state))) {
            return true;
        }
        Verify.verify((arguments.size() == 1 ? 1 : 0) != 0, (String)"Unexpected %s-ary constructor", (int)arguments.size());
        return this.matches(arguments.get(0), state);
    }

    private static boolean isEmptyArrayCreation(ExpressionTree tree) {
        if (!(tree instanceof NewArrayTree)) {
            return false;
        }
        NewArrayTree newArray = (NewArrayTree)tree;
        return !newArray.getDimensions().isEmpty() && ZERO.equals(ASTHelpers.constValue((Tree)newArray.getDimensions().get(0), Integer.class)) || newArray.getInitializers() != null && newArray.getInitializers().isEmpty();
    }
}

