/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.guidelines.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.util.Name;

@BugPattern(summary="Avoid direct invocation of `SuggestedFix#add{,Static}Import`", link="https://error-prone.picnic.tech/bugpatterns/UnqualifiedSuggestedFixImport", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
@AutoService(value={BugChecker.class})
public final class UnqualifiedSuggestedFixImport
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> FIX_BUILDER_METHOD = Matchers.instanceMethod().onDescendantOf(SuggestedFix.Builder.class.getCanonicalName());

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!FIX_BUILDER_METHOD.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return switch (((Name)ASTHelpers.getSymbol((MethodInvocationTree)tree).getSimpleName()).toString()) {
            case "addImport" -> this.createDescription(tree, "SuggestedFix.Builder#addImport", "SuggestedFixes#qualifyType");
            case "addStaticImport" -> this.createDescription(tree, "SuggestedFix.Builder#addStaticImport", "SuggestedFixes#qualifyStaticImport");
            default -> Description.NO_MATCH;
        };
    }

    private Description createDescription(MethodInvocationTree tree, String method, String alternative) {
        return this.buildDescription(tree).setMessage("Prefer `%s` over direct invocation of `%s`".formatted(alternative, method)).build();
    }
}

