/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.guidelines.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.refaster.annotation.AfterTemplate;
import com.google.errorprone.refaster.annotation.BeforeTemplate;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Name;
import org.jspecify.annotations.Nullable;
import tech.picnic.errorprone.utils.SourceCode;

@BugPattern(summary="Refaster template parameters should be listed in a canonical order", link="https://error-prone.picnic.tech/bugpatterns/RefasterMethodParameterOrder", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Style"})
@AutoService(value={BugChecker.class})
public final class RefasterMethodParameterOrder
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<Tree> BEFORE_TEMPLATE_METHOD = Matchers.hasAnnotation(BeforeTemplate.class);
    private static final Matcher<Tree> BEFORE_OR_AFTER_TEMPLATE_METHOD = Matchers.anyOf((Matcher[])new Matcher[]{BEFORE_TEMPLATE_METHOD, Matchers.hasAnnotation(AfterTemplate.class)});

    public Description matchClass(ClassTree tree, VisitorState state) {
        ImmutableList<MethodTree> methods = RefasterMethodParameterOrder.getMethodsByPriority(tree, state);
        if (methods.isEmpty()) {
            return Description.NO_MATCH;
        }
        Comparator<VariableTree> canonicalOrder = RefasterMethodParameterOrder.determineCanonicalParameterOrder(methods);
        return methods.stream().flatMap(m -> RefasterMethodParameterOrder.tryReorderParameters(m, canonicalOrder, state)).reduce(SuggestedFix.Builder::merge).map(SuggestedFix.Builder::build).map(fix -> this.describeMatch(tree, (Fix)fix)).orElse(Description.NO_MATCH);
    }

    private static ImmutableList<MethodTree> getMethodsByPriority(ClassTree tree, VisitorState state) {
        return (ImmutableList)tree.getMembers().stream().filter(m -> BEFORE_OR_AFTER_TEMPLATE_METHOD.matches(m, state)).map(MethodTree.class::cast).sorted(Comparator.comparing(m -> BEFORE_TEMPLATE_METHOD.matches((Tree)m, state)).thenComparingInt(m -> -m.getParameters().size())).collect(ImmutableList.toImmutableList());
    }

    private static Comparator<VariableTree> determineCanonicalParameterOrder(ImmutableList<MethodTree> methods) {
        LinkedHashSet canonicalOrder = new LinkedHashSet();
        methods.forEach(m -> RefasterMethodParameterOrder.processParameters(m, canonicalOrder));
        ImmutableList reversedCanonicalOrder = ImmutableList.copyOf(canonicalOrder).reverse();
        return Comparator.comparing(VariableTree::getName, Comparator.comparingInt(arg_0 -> ((ImmutableList)reversedCanonicalOrder).indexOf(arg_0)).reversed().thenComparing(CharSequence::toString));
    }

    private static void processParameters(MethodTree method, final Set<Name> orderedParams) {
        final Set toBeOrdered = method.getParameters().stream().map(ASTHelpers::getSymbol).collect(Collectors.toCollection(HashSet::new));
        new TreeScanner<Void, Void>(){

            @Override
            public @Nullable Void visitIdentifier(IdentifierTree node, @Nullable Void unused) {
                if (toBeOrdered.remove(ASTHelpers.getSymbol((Tree)node))) {
                    orderedParams.add(node.getName());
                }
                return (Void)super.visitIdentifier(node, null);
            }
        }.scan(method, null);
    }

    private static Stream<SuggestedFix.Builder> tryReorderParameters(MethodTree method, Comparator<VariableTree> canonicalOrder, VisitorState state) {
        ImmutableList orderedParams;
        List<? extends VariableTree> originalOrder = method.getParameters();
        return originalOrder.equals(orderedParams = ImmutableList.sortedCopyOf(canonicalOrder, originalOrder)) ? Stream.empty() : Streams.zip(originalOrder.stream(), orderedParams.stream().map(p -> SourceCode.treeToString((Tree)p, (VisitorState)state)), (arg_0, arg_1) -> ((SuggestedFix.Builder)SuggestedFix.builder()).replace(arg_0, arg_1));
    }
}

