/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.guidelines.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.util.regex.Pattern;
import tech.picnic.errorprone.utils.SourceCode;
import tech.picnic.errorprone.utils.ThirdPartyLibrary;

@BugPattern(summary="Prefer `Class#getCanonicalName()` over an equivalent string literal if and only if the type will be on the runtime classpath", link="https://error-prone.picnic.tech/bugpatterns/ErrorProneRuntimeClasspath", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"FragileCode"})
@AutoService(value={BugChecker.class})
public final class ErrorProneRuntimeClasspath
extends BugChecker
implements BugChecker.LiteralTreeMatcher,
BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> GET_CANONICAL_NAME_INVOCATION = Matchers.instanceMethod().onExactClass(Class.class.getCanonicalName()).named("getCanonicalName");
    private static final ImmutableSet<String> PRIMITIVE_TYPES = (ImmutableSet)Primitives.allPrimitiveTypes().stream().map(Class::getCanonicalName).collect(ImmutableSet.toImmutableSet());
    private static final Pattern CLASSPATH_TYPES = Pattern.compile("com\\.google\\.common\\..*|com\\.google\\.errorprone\\.([^.]+(?<!TestHelper)(\\..*)?)|java\\..*");

    public Description matchLiteral(LiteralTree tree, VisitorState state) {
        String value = (String)ASTHelpers.constValue((Tree)tree, String.class);
        if (value == null || !CLASSPATH_TYPES.matcher(value).matches() || state.findEnclosing(new Class[]{AnnotationTree.class}) != null) {
            return Description.NO_MATCH;
        }
        SuggestedFix fix = ErrorProneRuntimeClasspath.trySuggestClassReference(tree, value, state);
        if (fix.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("This type will be on the runtime classpath; use `Class#getCanonicalName()` instead").addFix((Fix)fix).build();
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!GET_CANONICAL_NAME_INVOCATION.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Symbol receiver = ASTHelpers.getSymbol((Tree)ASTHelpers.getReceiver((ExpressionTree)tree));
        if (receiver == null || !(receiver.owner instanceof Symbol.ClassSymbol) || PRIMITIVE_TYPES.contains((Object)receiver.owner.getQualifiedName().toString()) || CLASSPATH_TYPES.matcher(receiver.owner.getQualifiedName()).matches()) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("This type may not be on the runtime classpath; use a string literal instead").addFix((Fix)SuggestedFix.replace((Tree)tree, (String)SourceCode.toStringConstantExpression((Object)receiver.owner.getQualifiedName(), (VisitorState)state))).build();
    }

    private static SuggestedFix trySuggestClassReference(LiteralTree tree, String value, VisitorState state) {
        if (ErrorProneRuntimeClasspath.isTypeOnClasspath(value, state)) {
            return ErrorProneRuntimeClasspath.suggestClassReference(tree, value, "", state);
        }
        int lastDot = value.lastIndexOf(46);
        String type = value.substring(0, lastDot);
        if (ErrorProneRuntimeClasspath.isTypeOnClasspath(type, state)) {
            return ErrorProneRuntimeClasspath.suggestClassReference(tree, type, value.substring(lastDot), state);
        }
        return SuggestedFix.emptyFix();
    }

    private static SuggestedFix suggestClassReference(LiteralTree original, String type, String suffix, VisitorState state) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        String identifier = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)type);
        return fix.replace((Tree)original, identifier + ".class.getCanonicalName()" + (String)(suffix.isEmpty() ? "" : " + " + SourceCode.toStringConstantExpression((Object)suffix, (VisitorState)state))).build();
    }

    private static boolean isTypeOnClasspath(String type, VisitorState state) {
        try {
            return ThirdPartyLibrary.canIntroduceUsage((String)type, (VisitorState)state);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

