/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.guidelines.bugpatterns;

import com.google.auto.common.AnnotationMirrors;
import com.google.auto.service.AutoService;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.refaster.annotation.BeforeTemplate;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Signatures;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Modifier;
import org.jspecify.annotations.Nullable;
import tech.picnic.errorprone.utils.SourceCode;

@BugPattern(summary="The set of unmigrated methods listed by the `@TypeMigration` annotation must be minimal yet exhaustive", link="https://error-prone.picnic.tech/bugpatterns/ExhaustiveRefasterTypeMigration", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, tags={"LikelyError"})
@AutoService(value={BugChecker.class})
public final class ExhaustiveRefasterTypeMigration
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final MultiMatcher<Tree, AnnotationTree> IS_TYPE_MIGRATION = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.isType((String)"tech.picnic.errorprone.refaster.annotation.TypeMigration"));
    private static final MultiMatcher<Tree, AnnotationTree> HAS_BEFORE_TEMPLATE = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.isType((String)BeforeTemplate.class.getCanonicalName()));
    private static final String TYPE_MIGRATION_TYPE_ELEMENT = "of";
    private static final String TYPE_MIGRATION_UNMIGRATED_METHODS_ELEMENT = "unmigratedMethods";

    public Description matchClass(ClassTree tree, VisitorState state) {
        MultiMatcher.MultiMatchResult migrationAnnotations = IS_TYPE_MIGRATION.multiMatchResult((Tree)tree, state);
        if (!migrationAnnotations.matches()) {
            return Description.NO_MATCH;
        }
        AnnotationTree migrationAnnotation = (AnnotationTree)migrationAnnotations.onlyMatchingNode();
        AnnotationMirror annotationMirror = ASTHelpers.getAnnotationMirror((AnnotationTree)migrationAnnotation);
        Symbol.TypeSymbol migratedType = ExhaustiveRefasterTypeMigration.getMigratedType(annotationMirror);
        if (((Type)migratedType.asType()).isPrimitive() || !(migratedType instanceof Symbol.ClassSymbol)) {
            return this.buildDescription(migrationAnnotation).setMessage(String.format("Migration of type '%s' is unsupported", migratedType)).build();
        }
        ImmutableList<String> methodsClaimedUnmigrated = ExhaustiveRefasterTypeMigration.getMethodsClaimedUnmigrated(annotationMirror);
        ImmutableList<String> unmigratedMethods = ExhaustiveRefasterTypeMigration.getMethodsDefinitelyUnmigrated(tree, (Symbol.ClassSymbol)migratedType, ExhaustiveRefasterTypeMigration.signatureOrder(methodsClaimedUnmigrated), state);
        if (unmigratedMethods.equals(methodsClaimedUnmigrated)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(migrationAnnotation, (Fix)SuggestedFixes.updateAnnotationArgumentValues((AnnotationTree)migrationAnnotation, (VisitorState)state, (String)TYPE_MIGRATION_UNMIGRATED_METHODS_ELEMENT, (Collection)((Collection)unmigratedMethods.stream().map(m -> SourceCode.toStringConstantExpression((Object)m, (VisitorState)state)).collect(ImmutableList.toImmutableList()))).build());
    }

    private static Symbol.TypeSymbol getMigratedType(AnnotationMirror migrationAnnotation) {
        AnnotationValue value = AnnotationMirrors.getAnnotationValue((AnnotationMirror)migrationAnnotation, (String)TYPE_MIGRATION_TYPE_ELEMENT);
        Verify.verify((boolean)(value instanceof Attribute.Class), (String)"Value of annotation element `%s` is '%s' rather than a class", (Object)TYPE_MIGRATION_TYPE_ELEMENT, (Object)value);
        return ((Attribute.Class)value).classType.tsym;
    }

    private static ImmutableList<String> getMethodsClaimedUnmigrated(AnnotationMirror migrationAnnotation) {
        AnnotationValue value = AnnotationMirrors.getAnnotationValue((AnnotationMirror)migrationAnnotation, (String)TYPE_MIGRATION_UNMIGRATED_METHODS_ELEMENT);
        Verify.verify((boolean)(value instanceof Attribute.Array), (String)"Value of annotation element `%s` is '%s' rather than an array", (Object)TYPE_MIGRATION_UNMIGRATED_METHODS_ELEMENT, (Object)value);
        return (ImmutableList)((Attribute.Array)value).getValue().stream().map(a -> a.getValue().toString()).collect(ImmutableList.toImmutableList());
    }

    private static ImmutableList<String> getMethodsDefinitelyUnmigrated(ClassTree tree, Symbol.ClassSymbol migratedType, Comparator<String> comparator, VisitorState state) {
        Set publicMethods = Streams.stream((Iterable)ASTHelpers.scope((Scope)migratedType.members()).getSymbols(m -> m.getModifiers().contains((Object)Modifier.PUBLIC) && m instanceof Symbol.MethodSymbol)).map(Symbol.MethodSymbol.class::cast).collect(Collectors.toCollection(HashSet::new));
        ExhaustiveRefasterTypeMigration.removeMethodsInvokedInBeforeTemplateMethods(tree, publicMethods, state);
        return (ImmutableList)publicMethods.stream().map(m -> Signatures.prettyMethodSignature((Symbol.ClassSymbol)migratedType, (Symbol.MethodSymbol)m)).sorted(comparator).collect(ImmutableList.toImmutableList());
    }

    private static Comparator<String> signatureOrder(ImmutableList<String> existingOrder) {
        HashMap<String, Integer> knownEntries = new HashMap<String, Integer>();
        for (int i = 0; i < existingOrder.size(); ++i) {
            knownEntries.putIfAbsent((String)existingOrder.get(i), i);
        }
        return Comparator.comparing(v -> knownEntries.getOrDefault(v, -1)).thenComparing(String.CASE_INSENSITIVE_ORDER);
    }

    private static void removeMethodsInvokedInBeforeTemplateMethods(ClassTree tree, final Set<Symbol.MethodSymbol> candidates, final VisitorState state) {
        new TreeScanner<Void, Consumer<Symbol.MethodSymbol>>(){

            @Override
            public @Nullable Void visitMethod(MethodTree tree, Consumer<Symbol.MethodSymbol> sink) {
                return HAS_BEFORE_TEMPLATE.matches((Tree)tree, state) ? (Void)super.visitMethod(tree, candidates::remove) : null;
            }

            @Override
            public @Nullable Void visitNewClass(NewClassTree tree, Consumer<Symbol.MethodSymbol> sink) {
                sink.accept(ASTHelpers.getSymbol((NewClassTree)tree));
                return (Void)super.visitNewClass(tree, sink);
            }

            @Override
            public @Nullable Void visitMethodInvocation(MethodInvocationTree tree, Consumer<Symbol.MethodSymbol> sink) {
                sink.accept(ASTHelpers.getSymbol((MethodInvocationTree)tree));
                return (Void)super.visitMethodInvocation(tree, sink);
            }
        }.scan(tree, s -> {});
    }
}

