/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.experimental.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@BugPattern(summary="Prefer method references over lambda expressions", link="https://error-prone.picnic.tech/bugpatterns/MethodReferenceUsage", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Style"})
@AutoService(value={BugChecker.class})
public final class MethodReferenceUsage
extends BugChecker
implements BugChecker.LambdaExpressionTreeMatcher {
    private static final long serialVersionUID = 1L;

    public Description matchLambdaExpression(LambdaExpressionTree tree, VisitorState state) {
        return MethodReferenceUsage.constructMethodRef(tree, tree.getBody()).map(SuggestedFix.Builder::build).filter(fix -> SuggestedFixes.compilesWithFix((Fix)fix, (VisitorState)state, (ImmutableList)ImmutableList.of(), (boolean)true)).map(fix -> this.describeMatch(tree, (Fix)fix)).orElse(Description.NO_MATCH);
    }

    private static Optional<SuggestedFix.Builder> constructMethodRef(LambdaExpressionTree lambdaExpr, Tree subTree) {
        Tree tree = subTree;
        Objects.requireNonNull(tree);
        Tree tree2 = tree;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockTree.class, ExpressionStatementTree.class, MethodInvocationTree.class, ParenthesizedTree.class, ReturnTree.class}, (Object)tree2, n)) {
            case 0 -> {
                BlockTree block = (BlockTree)tree2;
                yield MethodReferenceUsage.constructMethodRef(lambdaExpr, block);
            }
            case 1 -> {
                ExpressionStatementTree expressionStatement = (ExpressionStatementTree)tree2;
                yield MethodReferenceUsage.constructMethodRef(lambdaExpr, expressionStatement.getExpression());
            }
            case 2 -> {
                MethodInvocationTree methodInvocation = (MethodInvocationTree)tree2;
                yield MethodReferenceUsage.constructMethodRef(lambdaExpr, methodInvocation);
            }
            case 3 -> {
                ParenthesizedTree parenthesized = (ParenthesizedTree)tree2;
                yield MethodReferenceUsage.constructMethodRef(lambdaExpr, parenthesized.getExpression());
            }
            case 4 -> {
                ReturnTree returnTree = (ReturnTree)tree2;
                yield MethodReferenceUsage.constructMethodRef(lambdaExpr, returnTree.getExpression());
            }
            default -> Optional.empty();
        };
    }

    private static Optional<SuggestedFix.Builder> constructMethodRef(LambdaExpressionTree lambdaExpr, BlockTree subTree) {
        return Optional.of(subTree.getStatements()).filter(statements -> statements.size() == 1).flatMap(statements -> MethodReferenceUsage.constructMethodRef(lambdaExpr, (Tree)statements.getFirst()));
    }

    private static Optional<SuggestedFix.Builder> constructMethodRef(LambdaExpressionTree lambdaExpr, MethodInvocationTree subTree) {
        return MethodReferenceUsage.matchArguments(lambdaExpr, subTree).flatMap(expectedInstance -> MethodReferenceUsage.constructMethodRef(lambdaExpr, subTree, (Optional<javax.lang.model.element.Name>)expectedInstance));
    }

    private static Optional<SuggestedFix.Builder> constructMethodRef(LambdaExpressionTree lambdaExpr, MethodInvocationTree subTree, Optional<javax.lang.model.element.Name> expectedInstance) {
        ExpressionTree methodSelect;
        ExpressionTree expressionTree = methodSelect = subTree.getMethodSelect();
        Objects.requireNonNull(expressionTree);
        ExpressionTree expressionTree2 = expressionTree;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IdentifierTree.class, MemberSelectTree.class}, (Object)expressionTree2, n)) {
            case 0 -> {
                IdentifierTree identifier = (IdentifierTree)expressionTree2;
                if (expectedInstance.isPresent()) {
                    yield Optional.empty();
                }
                Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodInvocationTree)subTree);
                if (ASTHelpers.isStatic((Symbol)sym)) {
                    yield MethodReferenceUsage.constructFix(lambdaExpr, sym.owner, (Object)methodSelect);
                }
                yield MethodReferenceUsage.constructFix(lambdaExpr, "this", (Object)methodSelect);
            }
            case 1 -> {
                MemberSelectTree memberSelect = (MemberSelectTree)expressionTree2;
                yield MethodReferenceUsage.constructMethodRef(lambdaExpr, memberSelect, expectedInstance);
            }
            default -> throw new VerifyException("Unexpected type of expression: " + String.valueOf((Object)methodSelect.getKind()));
        };
    }

    private static Optional<SuggestedFix.Builder> constructMethodRef(LambdaExpressionTree lambdaExpr, MemberSelectTree subTree, Optional<javax.lang.model.element.Name> expectedInstance) {
        ExpressionTree expressionTree = subTree.getExpression();
        if (!(expressionTree instanceof IdentifierTree)) {
            return Optional.empty();
        }
        IdentifierTree identifier = (IdentifierTree)expressionTree;
        javax.lang.model.element.Name lhs = identifier.getName();
        if (expectedInstance.isEmpty()) {
            return MethodReferenceUsage.constructFix(lambdaExpr, lhs, (Object)subTree.getIdentifier());
        }
        Type lhsType = ASTHelpers.getType((Tree)identifier);
        if (lhsType == null || !expectedInstance.orElseThrow().equals(lhs)) {
            return Optional.empty();
        }
        return MethodReferenceUsage.constructFix(lambdaExpr, lhsType.tsym, (Object)subTree.getIdentifier());
    }

    private static Optional<Optional<javax.lang.model.element.Name>> matchArguments(LambdaExpressionTree lambdaExpr, MethodInvocationTree subTree) {
        ImmutableList<javax.lang.model.element.Name> expectedArguments = MethodReferenceUsage.getVariables(lambdaExpr);
        List<? extends ExpressionTree> args = subTree.getArguments();
        int diff = expectedArguments.size() - args.size();
        if (diff < 0 || diff > 1) {
            return Optional.empty();
        }
        for (int i = 0; i < args.size(); ++i) {
            IdentifierTree identifier;
            ExpressionTree arg = args.get(i);
            if (arg instanceof IdentifierTree && (identifier = (IdentifierTree)arg).getName().equals(expectedArguments.get(i + diff))) continue;
            return Optional.empty();
        }
        return Optional.of(diff == 0 ? Optional.empty() : Optional.of((javax.lang.model.element.Name)expectedArguments.getFirst()));
    }

    private static ImmutableList<javax.lang.model.element.Name> getVariables(LambdaExpressionTree tree) {
        return (ImmutableList)tree.getParameters().stream().map(VariableTree::getName).collect(ImmutableList.toImmutableList());
    }

    private static Optional<SuggestedFix.Builder> constructFix(LambdaExpressionTree lambdaExpr, Symbol target, Object methodName) {
        Name fqName;
        Name sName = target.getSimpleName();
        Optional<SuggestedFix.Builder> fix = MethodReferenceUsage.constructFix(lambdaExpr, sName, methodName);
        Symbol.PackageSymbol pkg = ASTHelpers.enclosingPackage((Symbol)target);
        if (pkg != null && !"java.lang".equals(pkg.toString()) && !sName.equals(fqName = target.getQualifiedName())) {
            return fix.map(b -> b.addImport(fqName.toString()));
        }
        return fix;
    }

    private static Optional<SuggestedFix.Builder> constructFix(LambdaExpressionTree lambdaExpr, Object target, Object methodName) {
        return Optional.of(SuggestedFix.builder().replace((Tree)lambdaExpr, String.valueOf(target) + "::" + String.valueOf(methodName)));
    }
}

