/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.collect.Streams;
import com.google.errorprone.refaster.Refaster;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;

final class OptionalRules {
    private OptionalRules() {
    }

    static final class OptionalMap<S, T> {
        OptionalMap() {
        }

        Optional<? extends T> before(Optional<S> optional, Function<? super S, ? extends T> function) {
            return optional.stream().map(function).findAny();
        }

        Optional<? extends T> after(Optional<S> optional, Function<? super S, ? extends T> function) {
            return optional.map(function);
        }
    }

    static final class OptionalFilter<T> {
        OptionalFilter() {
        }

        Optional<T> before(Optional<T> optional, Predicate<? super T> predicate) {
            return (Optional)Refaster.anyOf((Object[])new Optional[]{optional.stream().filter(predicate).findFirst(), optional.stream().filter(predicate).findAny()});
        }

        Optional<T> after(Optional<T> optional, Predicate<? super T> predicate) {
            return optional.filter(predicate);
        }
    }

    static final class OptionalIdentity<T> {
        OptionalIdentity() {
        }

        Optional<T> before(Optional<T> optional, Comparator<? super T> comparator) {
            return (Optional)Refaster.anyOf((Object[])new Optional[]{optional.stream().findFirst(), optional.stream().findAny(), optional.stream().min(comparator), optional.stream().max(comparator)});
        }

        Optional<T> after(Optional<T> optional) {
            return optional;
        }
    }

    static final class OptionalOrOtherOptional<T> {
        OptionalOrOtherOptional() {
        }

        Optional<T> before(Optional<T> optional1, Optional<T> optional2) {
            return (Optional)Refaster.anyOf((Object[])new Optional[]{optional1.map(Optional::of).orElse(optional2), optional1.map(Optional::of).orElseGet(() -> optional2), Stream.of(optional1, optional2).flatMap(Optional::stream).findFirst()});
        }

        Optional<T> after(Optional<T> optional1, Optional<T> optional2) {
            return optional1.or(() -> optional2);
        }
    }

    static abstract class FlatMapOuterOptionalAfterFlatMap<T, S, R> {
        FlatMapOuterOptionalAfterFlatMap() {
        }

        abstract Optional<S> toOptionalFunction(T var1);

        Optional<R> before(Optional<T> optional, Function<? super S, ? extends Optional<? extends R>> function) {
            return optional.flatMap(v -> this.toOptionalFunction(v).flatMap(function));
        }

        Optional<R> after(Optional<T> optional, Function<? super S, ? extends Optional<? extends R>> function) {
            return optional.flatMap(v -> this.toOptionalFunction(v)).flatMap(function);
        }
    }

    static abstract class MapOuterOptionalAfterFlatMap<T, S, R> {
        MapOuterOptionalAfterFlatMap() {
        }

        abstract Optional<S> toOptionalFunction(T var1);

        Optional<R> before(Optional<T> optional, Function<? super S, ? extends R> function) {
            return optional.flatMap(v -> this.toOptionalFunction(v).map(function));
        }

        Optional<R> after(Optional<T> optional, Function<? super S, ? extends R> function) {
            return optional.flatMap(v -> this.toOptionalFunction(v)).map(function);
        }
    }

    static abstract class FilterOuterOptionalAfterFlatMap<T, S> {
        FilterOuterOptionalAfterFlatMap() {
        }

        abstract Optional<S> toOptionalFunction(T var1);

        Optional<S> before(Optional<T> optional, Predicate<? super S> predicate) {
            return optional.flatMap(v -> this.toOptionalFunction(v).filter(predicate));
        }

        Optional<S> after(Optional<T> optional, Predicate<? super S> predicate) {
            return optional.flatMap(v -> this.toOptionalFunction(v)).filter(predicate);
        }
    }

    static abstract class StreamMapToOptionalGet<T, S> {
        StreamMapToOptionalGet() {
        }

        abstract Optional<S> toOptionalFunction(T var1);

        Stream<S> before(Stream<T> stream) {
            return stream.map(e -> this.toOptionalFunction(e).orElseThrow());
        }

        Stream<S> after(Stream<T> stream) {
            return stream.flatMap(e -> this.toOptionalFunction(e).stream());
        }
    }

    static final class StreamFlatMapOptional<T> {
        StreamFlatMapOptional() {
        }

        Stream<T> before(Stream<Optional<T>> stream) {
            return (Stream)Refaster.anyOf((Object[])new Stream[]{stream.filter(Optional::isPresent).map(Optional::orElseThrow), stream.flatMap(Streams::stream)});
        }

        Stream<T> after(Stream<Optional<T>> stream) {
            return stream.flatMap(Optional::stream);
        }
    }

    static final class OrOrElseThrow<T> {
        OrOrElseThrow() {
        }

        T before(Optional<T> o1, Optional<T> o2) {
            return (T)o1.orElseGet(() -> o2.orElseThrow());
        }

        T after(Optional<T> o1, Optional<T> o2) {
            return o1.or(() -> o2).orElseThrow();
        }
    }

    static abstract class FlatMapToOptional<T, S> {
        FlatMapToOptional() {
        }

        abstract Optional<S> toOptionalFunction(T var1);

        Optional<S> before(Optional<T> optional) {
            return optional.map(v -> this.toOptionalFunction(v).orElseThrow());
        }

        Optional<S> after(Optional<T> optional) {
            return optional.flatMap(v -> this.toOptionalFunction(v));
        }
    }

    static abstract class MapToNullable<T, S> {
        MapToNullable() {
        }

        abstract S toNullableFunction(T var1);

        Optional<S> before(Optional<T> optional) {
            return optional.flatMap(v -> (Optional)Refaster.anyOf((Object[])new Optional[]{Optional.of(this.toNullableFunction(v)), Optional.ofNullable(this.toNullableFunction(v))}));
        }

        Optional<S> after(Optional<T> optional) {
            return optional.map(v -> this.toNullableFunction(v));
        }
    }

    static final class MapOptionalToBoolean<T> {
        MapOptionalToBoolean() {
        }

        boolean before(Optional<T> optional, Function<? super T, Boolean> predicate) {
            return optional.map(predicate).orElse((Boolean)Refaster.anyOf((Object[])new Boolean[]{false, Boolean.FALSE}));
        }

        boolean after(Optional<T> optional, Predicate<? super T> predicate) {
            return optional.filter(predicate).isPresent();
        }
    }

    static abstract class TernaryOperatorOptionalNegativeFiltering<T> {
        TernaryOperatorOptionalNegativeFiltering() {
        }

        abstract boolean test(T var1);

        Optional<T> before(T input) {
            return this.test(input) ? Optional.empty() : Optional.of(input);
        }

        Optional<T> after(T input) {
            return (Optional)Refaster.emitCommentBefore((String)"Or Optional.ofNullable (can't auto-infer).", Optional.of(input).filter(v -> !this.test(v)));
        }
    }

    static abstract class TernaryOperatorOptionalPositiveFiltering<T> {
        TernaryOperatorOptionalPositiveFiltering() {
        }

        abstract boolean test(T var1);

        Optional<T> before(T input) {
            return this.test(input) ? Optional.of(input) : Optional.empty();
        }

        Optional<T> after(T input) {
            return (Optional)Refaster.emitCommentBefore((String)"Or Optional.ofNullable (can't auto-infer).", Optional.of(input).filter(v -> this.test(v)));
        }
    }

    static final class OptionalFirstIteratorElement<T> {
        OptionalFirstIteratorElement() {
        }

        Optional<T> before(Iterator<T> it) {
            return it.hasNext() ? Optional.of(it.next()) : Optional.empty();
        }

        Optional<T> after(Iterator<T> it) {
            return Streams.stream(it).findFirst();
        }
    }

    static final class OptionalOrElseThrowMethodReference<T> {
        OptionalOrElseThrowMethodReference() {
        }

        Function<Optional<T>, T> before() {
            return Optional::get;
        }

        Function<Optional<T>, T> after() {
            return Optional::orElseThrow;
        }
    }

    static final class OptionalOrElseThrow<T> {
        OptionalOrElseThrow() {
        }

        T before(Optional<T> optional) {
            return optional.get();
        }

        T after(Optional<T> optional) {
            return optional.orElseThrow();
        }
    }

    static final class OptionalIsPresent<T> {
        OptionalIsPresent() {
        }

        boolean before(Optional<T> optional) {
            return !optional.isEmpty();
        }

        boolean after(Optional<T> optional) {
            return optional.isPresent();
        }
    }

    static final class OptionalIsEmpty<T> {
        OptionalIsEmpty() {
        }

        boolean before(Optional<T> optional) {
            return !optional.isPresent();
        }

        boolean after(Optional<T> optional) {
            return optional.isEmpty();
        }
    }

    static final class OptionalOfNullable<T> {
        OptionalOfNullable() {
        }

        Optional<T> before(@Nullable T object) {
            return object == null ? Optional.empty() : Optional.of(object);
        }

        Optional<T> after(T object) {
            return Optional.ofNullable(object);
        }
    }
}

