/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.io.IOException;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;

final class AssertJThrowingCallableRules {
    private AssertJThrowingCallableRules() {
    }

    static final class AbstractThrowableAssertWithFailMessage {
        AbstractThrowableAssertWithFailMessage() {
        }

        AbstractThrowableAssert<?, ? extends Throwable> before(AbstractThrowableAssert<?, ? extends Throwable> abstractThrowableAssert, String message, Object args) {
            return (AbstractThrowableAssert)abstractThrowableAssert.withFailMessage(String.format(message, args), new Object[0]);
        }

        AbstractThrowableAssert<?, ? extends Throwable> after(AbstractThrowableAssert<?, ? extends Throwable> abstractThrowableAssert, String message, Object args) {
            return (AbstractThrowableAssert)abstractThrowableAssert.withFailMessage(message, new Object[]{args});
        }
    }

    static final class AbstractThrowableAssertHasMessage {
        AbstractThrowableAssertHasMessage() {
        }

        AbstractThrowableAssert<?, ? extends Throwable> before(AbstractThrowableAssert<?, ? extends Throwable> abstractThrowableAssert, String message, Object parameters) {
            return abstractThrowableAssert.hasMessage(String.format(message, parameters));
        }

        AbstractThrowableAssert<?, ? extends Throwable> after(AbstractThrowableAssert<?, ? extends Throwable> abstractThrowableAssert, String message, Object parameters) {
            return abstractThrowableAssert.hasMessage(message, new Object[]{parameters});
        }
    }

    static final class AssertThatThrownByHasMessageParameters {
        AssertThatThrownByHasMessageParameters() {
        }

        AbstractObjectAssert<?, ?> before(Class<? extends Throwable> exceptionType, ThrowableAssert.ThrowingCallable throwingCallable, String message, Object parameters) {
            return Assertions.assertThatExceptionOfType(exceptionType).isThrownBy(throwingCallable).withMessage(message, new Object[]{parameters});
        }

        AbstractObjectAssert<?, ?> after(Class<? extends Throwable> exceptionType, ThrowableAssert.ThrowingCallable throwingCallable, String message, Object parameters) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(exceptionType)).hasMessage(message, new Object[]{parameters});
        }
    }

    static final class AssertThatThrownByHasMessage {
        AssertThatThrownByHasMessage() {
        }

        AbstractObjectAssert<?, ?> before(Class<? extends Throwable> exceptionType, ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return Assertions.assertThatExceptionOfType(exceptionType).isThrownBy(throwingCallable).withMessage(message);
        }

        AbstractObjectAssert<?, ?> after(Class<? extends Throwable> exceptionType, ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(exceptionType)).hasMessage(message);
        }
    }

    static final class AssertThatThrownBy {
        AssertThatThrownBy() {
        }

        AbstractObjectAssert<?, ?> before(Class<? extends Throwable> exceptionType, ThrowableAssert.ThrowingCallable throwingCallable) {
            return Assertions.assertThatExceptionOfType(exceptionType).isThrownBy(throwingCallable);
        }

        AbstractObjectAssert<?, ?> after(Class<? extends Throwable> exceptionType, ThrowableAssert.ThrowingCallable throwingCallable) {
            return (AbstractObjectAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(exceptionType);
        }
    }

    static final class AssertThatThrownByIOExceptionHasMessageParameters {
        AssertThatThrownByIOExceptionHasMessageParameters() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message, Object parameters) {
            return Assertions.assertThatIOException().isThrownBy(throwingCallable).withMessage(message, new Object[]{parameters});
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message, Object parameters) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IOException.class)).hasMessage(message, new Object[]{parameters});
        }
    }

    static final class AssertThatThrownByIOExceptionHasMessage {
        AssertThatThrownByIOExceptionHasMessage() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return Assertions.assertThatIOException().isThrownBy(throwingCallable).withMessage(message);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IOException.class)).hasMessage(message);
        }
    }

    static final class AssertThatThrownByIOException {
        AssertThatThrownByIOException() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable) {
            return Assertions.assertThatIOException().isThrownBy(throwingCallable);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable) {
            return (AbstractObjectAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IOException.class);
        }
    }

    static final class AssertThatThrownByNullPointerExceptionHasMessageStartingWith {
        AssertThatThrownByNullPointerExceptionHasMessageStartingWith() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return Assertions.assertThatNullPointerException().isThrownBy(throwingCallable).withMessageStartingWith(message);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(NullPointerException.class)).hasMessageStartingWith(message);
        }
    }

    static final class AssertThatThrownByNullPointerExceptionHasMessageParameters {
        AssertThatThrownByNullPointerExceptionHasMessageParameters() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message, Object parameters) {
            return Assertions.assertThatNullPointerException().isThrownBy(throwingCallable).withMessage(message, new Object[]{parameters});
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message, Object parameters) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(NullPointerException.class)).hasMessage(message, new Object[]{parameters});
        }
    }

    static final class AssertThatThrownByNullPointerExceptionHasMessage {
        AssertThatThrownByNullPointerExceptionHasMessage() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return Assertions.assertThatNullPointerException().isThrownBy(throwingCallable).withMessage(message);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(NullPointerException.class)).hasMessage(message);
        }
    }

    static final class AssertThatThrownByNullPointerException {
        AssertThatThrownByNullPointerException() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable) {
            return Assertions.assertThatNullPointerException().isThrownBy(throwingCallable);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable) {
            return (AbstractObjectAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(NullPointerException.class);
        }
    }

    static final class AssertThatThrownByIllegalStateExceptionHasMessageNotContaining {
        AssertThatThrownByIllegalStateExceptionHasMessageNotContaining() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return Assertions.assertThatIllegalStateException().isThrownBy(throwingCallable).withMessageNotContaining(message);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalStateException.class)).hasMessageNotContaining(message);
        }
    }

    static final class AssertThatThrownByIllegalStateExceptionHasMessageContaining {
        AssertThatThrownByIllegalStateExceptionHasMessageContaining() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return Assertions.assertThatIllegalStateException().isThrownBy(throwingCallable).withMessageContaining(message);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalStateException.class)).hasMessageContaining(message);
        }
    }

    static final class AssertThatThrownByIllegalStateExceptionHasMessageStartingWith {
        AssertThatThrownByIllegalStateExceptionHasMessageStartingWith() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return Assertions.assertThatIllegalStateException().isThrownBy(throwingCallable).withMessageStartingWith(message);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalStateException.class)).hasMessageStartingWith(message);
        }
    }

    static final class AssertThatThrownByIllegalStateExceptionHasMessageParameters {
        AssertThatThrownByIllegalStateExceptionHasMessageParameters() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message, Object parameters) {
            return Assertions.assertThatIllegalStateException().isThrownBy(throwingCallable).withMessage(message, new Object[]{parameters});
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message, Object parameters) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalStateException.class)).hasMessage(message, new Object[]{parameters});
        }
    }

    static final class AssertThatThrownByIllegalStateExceptionHasMessage {
        AssertThatThrownByIllegalStateExceptionHasMessage() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return Assertions.assertThatIllegalStateException().isThrownBy(throwingCallable).withMessage(message);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalStateException.class)).hasMessage(message);
        }
    }

    static final class AssertThatThrownByIllegalStateException {
        AssertThatThrownByIllegalStateException() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable) {
            return Assertions.assertThatIllegalStateException().isThrownBy(throwingCallable);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable) {
            return (AbstractObjectAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalStateException.class);
        }
    }

    static final class AssertThatThrownByIllegalArgumentExceptionHasMessageNotContainingAny {
        AssertThatThrownByIllegalArgumentExceptionHasMessageNotContainingAny() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, CharSequence values) {
            return Assertions.assertThatIllegalArgumentException().isThrownBy(throwingCallable).withMessageNotContainingAny(new CharSequence[]{values});
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, CharSequence values) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalArgumentException.class)).hasMessageNotContainingAny(new CharSequence[]{values});
        }
    }

    static final class AssertThatThrownByIllegalArgumentExceptionHasMessageContaining {
        AssertThatThrownByIllegalArgumentExceptionHasMessageContaining() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return Assertions.assertThatIllegalArgumentException().isThrownBy(throwingCallable).withMessageContaining(message);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(message);
        }
    }

    static final class AssertThatThrownByIllegalArgumentExceptionHasMessageStartingWith {
        AssertThatThrownByIllegalArgumentExceptionHasMessageStartingWith() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return Assertions.assertThatIllegalArgumentException().isThrownBy(throwingCallable).withMessageStartingWith(message);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith(message);
        }
    }

    static final class AssertThatThrownByIllegalArgumentExceptionHasMessageParameters {
        AssertThatThrownByIllegalArgumentExceptionHasMessageParameters() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message, Object parameters) {
            return Assertions.assertThatIllegalArgumentException().isThrownBy(throwingCallable).withMessage(message, new Object[]{parameters});
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message, Object parameters) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalArgumentException.class)).hasMessage(message, new Object[]{parameters});
        }
    }

    static final class AssertThatThrownByIllegalArgumentExceptionHasMessage {
        AssertThatThrownByIllegalArgumentExceptionHasMessage() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return Assertions.assertThatIllegalArgumentException().isThrownBy(throwingCallable).withMessage(message);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalArgumentException.class)).hasMessage(message);
        }
    }

    static final class AssertThatThrownByIllegalArgumentException {
        AssertThatThrownByIllegalArgumentException() {
        }

        AbstractObjectAssert<?, ?> before(ThrowableAssert.ThrowingCallable throwingCallable) {
            return Assertions.assertThatIllegalArgumentException().isThrownBy(throwingCallable);
        }

        AbstractObjectAssert<?, ?> after(ThrowableAssert.ThrowingCallable throwingCallable) {
            return (AbstractObjectAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(IllegalArgumentException.class);
        }
    }
}

