/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Name;
import java.util.Optional;
import java.util.function.Predicate;
import javax.lang.model.element.Modifier;
import tech.picnic.errorprone.bugpatterns.util.JavaKeywords;
import tech.picnic.errorprone.bugpatterns.util.MoreJUnitMatchers;
import tech.picnic.errorprone.bugpatterns.util.SourceCode;

@BugPattern(summary="JUnit method declaration can likely be improved", link="https://error-prone.picnic.tech/bugpatterns/JUnitMethodDeclaration", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Simplification"})
@AutoService(value={BugChecker.class})
public final class JUnitMethodDeclaration
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final String TEST_PREFIX = "test";
    private static final ImmutableSet<Modifier> ILLEGAL_MODIFIERS = Sets.immutableEnumSet((Enum)Modifier.PRIVATE, (Enum[])new Modifier[]{Modifier.PROTECTED, Modifier.PUBLIC});
    private static final Matcher<MethodTree> IS_LIKELY_OVERRIDDEN = Matchers.allOf((Matcher[])new Matcher[]{Matchers.not((Matcher)Matchers.hasModifier((Modifier)Modifier.FINAL)), Matchers.not((Matcher)Matchers.hasModifier((Modifier)Modifier.PRIVATE)), Matchers.enclosingClass((Matcher)Matchers.hasModifier((Modifier)Modifier.ABSTRACT))});

    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (IS_LIKELY_OVERRIDDEN.matches((Tree)tree, state) || JUnitMethodDeclaration.isOverride(tree, state)) {
            return Description.NO_MATCH;
        }
        boolean isTestMethod = MoreJUnitMatchers.TEST_METHOD.matches((Tree)tree, state);
        if (!isTestMethod && !MoreJUnitMatchers.SETUP_OR_TEARDOWN_METHOD.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        SuggestedFixes.removeModifiers((ModifiersTree)tree.getModifiers(), (VisitorState)state, ILLEGAL_MODIFIERS).ifPresent(arg_0 -> ((SuggestedFix.Builder)fixBuilder).merge(arg_0));
        if (isTestMethod) {
            this.suggestTestMethodRenameIfApplicable(tree, fixBuilder, state);
        }
        return fixBuilder.isEmpty() ? Description.NO_MATCH : this.describeMatch(tree, (Fix)fixBuilder.build());
    }

    private void suggestTestMethodRenameIfApplicable(MethodTree tree, SuggestedFix.Builder fixBuilder, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodTree)tree);
        JUnitMethodDeclaration.tryCanonicalizeMethodName(symbol).ifPresent(newName -> JUnitMethodDeclaration.findMethodRenameBlocker(symbol, newName, state).ifPresentOrElse(blocker -> this.reportMethodRenameBlocker(tree, (String)blocker, state), () -> fixBuilder.merge(SuggestedFixes.renameMethod((MethodTree)tree, (String)newName, (VisitorState)state))));
    }

    private void reportMethodRenameBlocker(MethodTree tree, String reason, VisitorState state) {
        state.reportMatch(this.buildDescription(tree).setMessage(String.format("This method's name should not redundantly start with `%s` (but note that %s)", TEST_PREFIX, reason)).build());
    }

    private static Optional<String> findMethodRenameBlocker(Symbol.MethodSymbol method, String newName, VisitorState state) {
        if (JUnitMethodDeclaration.isExistingMethodName(method.owner.type, newName, state)) {
            return Optional.of(String.format("a method named `%s` is already defined in this class or a supertype", newName));
        }
        if (JUnitMethodDeclaration.isSimpleNameStaticallyImported(newName, state)) {
            return Optional.of(String.format("`%s` is already statically imported", newName));
        }
        if (!JavaKeywords.isValidIdentifier(newName)) {
            return Optional.of(String.format("`%s` is not a valid identifier", newName));
        }
        return Optional.empty();
    }

    private static boolean isExistingMethodName(Type clazz, String name, VisitorState state) {
        return ASTHelpers.matchingMethods((Name)state.getName(name), method -> true, (Type)clazz, (Types)state.getTypes()).findAny().isPresent();
    }

    private static boolean isSimpleNameStaticallyImported(String simpleName, VisitorState state) {
        return state.getPath().getCompilationUnit().getImports().stream().filter(ImportTree::isStatic).map(ImportTree::getQualifiedIdentifier).map(tree -> JUnitMethodDeclaration.getStaticImportSimpleName(tree, state)).anyMatch(simpleName::contentEquals);
    }

    private static CharSequence getStaticImportSimpleName(Tree tree, VisitorState state) {
        String source = SourceCode.treeToString(tree, state);
        return source.subSequence(source.lastIndexOf(46) + 1, source.length());
    }

    private static Optional<String> tryCanonicalizeMethodName(Symbol symbol) {
        return Optional.of(symbol.getQualifiedName().toString()).filter(name -> name.startsWith(TEST_PREFIX)).map(name -> name.substring(TEST_PREFIX.length())).filter(Predicate.not(String::isEmpty)).map(name -> Character.toLowerCase(name.charAt(0)) + name.substring(1)).filter(name -> !Character.isDigit(name.charAt(0)));
    }

    private static boolean isOverride(MethodTree tree, VisitorState state) {
        return ASTHelpers.streamSuperMethods((Symbol.MethodSymbol)ASTHelpers.getSymbol((MethodTree)tree), (Types)state.getTypes()).findAny().isPresent();
    }
}

