/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.base.Preconditions;

final class PreconditionsRules {
    private PreconditionsRules() {
    }

    static final class CheckStateWithMessage {
        CheckStateWithMessage() {
        }

        void before(boolean condition, String message) {
            if (condition) {
                throw new IllegalStateException(message);
            }
        }

        void after(boolean condition, String message) {
            Preconditions.checkState((!condition ? 1 : 0) != 0, (Object)message);
        }
    }

    static final class CheckState {
        CheckState() {
        }

        void before(boolean condition) {
            if (condition) {
                throw new IllegalStateException();
            }
        }

        void after(boolean condition) {
            Preconditions.checkState((!condition ? 1 : 0) != 0);
        }
    }

    static final class CheckPositionIndexWithMessage {
        CheckPositionIndexWithMessage() {
        }

        void before(int index, int size, String message) {
            if (index < 0 || index > size) {
                throw new IndexOutOfBoundsException(message);
            }
        }

        void after(int index, int size, String message) {
            Preconditions.checkPositionIndex((int)index, (int)size, (String)message);
        }
    }

    static final class CheckPositionIndex {
        CheckPositionIndex() {
        }

        void before(int index, int size) {
            if (index < 0 || index > size) {
                throw new IndexOutOfBoundsException();
            }
        }

        void after(int index, int size) {
            Preconditions.checkPositionIndex((int)index, (int)size);
        }
    }

    static final class CheckNotNullWithMessage<T> {
        CheckNotNullWithMessage() {
        }

        void before(T object, String message) {
            if (object == null) {
                throw new NullPointerException(message);
            }
        }

        void after(T object, String message) {
            Preconditions.checkNotNull(object, (Object)message);
        }
    }

    static final class CheckNotNull<T> {
        CheckNotNull() {
        }

        void before(T object) {
            if (object == null) {
                throw new NullPointerException();
            }
        }

        void after(T object) {
            Preconditions.checkNotNull(object);
        }
    }

    static final class CheckElementIndexWithMessage {
        CheckElementIndexWithMessage() {
        }

        void before(int index, int size, String message) {
            if (index < 0 || index >= size) {
                throw new IndexOutOfBoundsException(message);
            }
        }

        void after(int index, int size, String message) {
            Preconditions.checkElementIndex((int)index, (int)size, (String)message);
        }
    }

    static final class CheckArgumentWithMessage {
        CheckArgumentWithMessage() {
        }

        void before(boolean condition, String message) {
            if (condition) {
                throw new IllegalArgumentException(message);
            }
        }

        void after(boolean condition, String message) {
            Preconditions.checkArgument((!condition ? 1 : 0) != 0, (Object)message);
        }
    }

    static final class CheckArgument {
        CheckArgument() {
        }

        void before(boolean condition) {
            if (condition) {
                throw new IllegalArgumentException();
            }
        }

        void after(boolean condition) {
            Preconditions.checkArgument((!condition ? 1 : 0) != 0);
        }
    }
}

