/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.DoNotCall;
import java.util.function.Supplier;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowableAssert;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.api.function.ThrowingSupplier;

final class JUnitToAssertJRules {
    private JUnitToAssertJRules() {
    }

    public ImmutableSet<?> elidedTypesAndStaticImports() {
        return ImmutableSet.of(org.junit.jupiter.api.Assertions.class, (Object)org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> null), (Object)org.junit.jupiter.api.Assertions.assertInstanceOf(null, null), (Object)org.junit.jupiter.api.Assertions.assertThrows(null, null), (Object)org.junit.jupiter.api.Assertions.assertThrowsExactly(null, null), () -> org.junit.jupiter.api.Assertions.assertFalse((boolean)true), (Object[])new Object[]{() -> org.junit.jupiter.api.Assertions.assertNotNull(null), () -> org.junit.jupiter.api.Assertions.assertNotSame(null, null), () -> org.junit.jupiter.api.Assertions.assertNull(null), () -> org.junit.jupiter.api.Assertions.assertSame(null, null), () -> org.junit.jupiter.api.Assertions.assertTrue((boolean)true)});
    }

    static final class AssertThatWithFailMessageSupplierIsInstanceOf<T> {
        AssertThatWithFailMessageSupplierIsInstanceOf() {
        }

        void before(Object actual, Class<T> clazz, Supplier<String> supplier) {
            org.junit.jupiter.api.Assertions.assertInstanceOf(clazz, (Object)actual, supplier);
        }

        void after(Object actual, Class<T> clazz, Supplier<String> supplier) {
            ((ObjectAssert)Assertions.assertThat((Object)actual).withFailMessage(supplier)).isInstanceOf(clazz);
        }
    }

    static final class AssertThatWithFailMessageStringIsInstanceOf<T> {
        AssertThatWithFailMessageStringIsInstanceOf() {
        }

        void before(Object actual, Class<T> clazz, String message) {
            org.junit.jupiter.api.Assertions.assertInstanceOf(clazz, (Object)actual, (String)message);
        }

        void after(Object actual, Class<T> clazz, String message) {
            ((ObjectAssert)Assertions.assertThat((Object)actual).withFailMessage(message, new Object[0])).isInstanceOf(clazz);
        }
    }

    static final class AssertThatIsInstanceOf<T> {
        AssertThatIsInstanceOf() {
        }

        void before(Object actual, Class<T> clazz) {
            org.junit.jupiter.api.Assertions.assertInstanceOf(clazz, (Object)actual);
        }

        void after(Object actual, Class<T> clazz) {
            Assertions.assertThat((Object)actual).isInstanceOf(clazz);
        }
    }

    static final class AssertThatCodeWithFailMessageSupplierDoesNotThrowAnyException {
        AssertThatCodeWithFailMessageSupplierDoesNotThrowAnyException() {
        }

        void before(Executable throwingCallable, Supplier<String> supplier) {
            org.junit.jupiter.api.Assertions.assertDoesNotThrow((Executable)throwingCallable, supplier);
        }

        void before(ThrowingSupplier<?> throwingCallable, Supplier<String> supplier) {
            org.junit.jupiter.api.Assertions.assertDoesNotThrow(throwingCallable, supplier);
        }

        void after(ThrowableAssert.ThrowingCallable throwingCallable, Supplier<String> supplier) {
            ((AbstractThrowableAssert)Assertions.assertThatCode((ThrowableAssert.ThrowingCallable)throwingCallable).withFailMessage(supplier)).doesNotThrowAnyException();
        }
    }

    static final class AssertThatCodeWithFailMessageStringDoesNotThrowAnyException {
        AssertThatCodeWithFailMessageStringDoesNotThrowAnyException() {
        }

        void before(Executable throwingCallable, String message) {
            org.junit.jupiter.api.Assertions.assertDoesNotThrow((Executable)throwingCallable, (String)message);
        }

        void before(ThrowingSupplier<?> throwingCallable, String message) {
            org.junit.jupiter.api.Assertions.assertDoesNotThrow(throwingCallable, (String)message);
        }

        void after(ThrowableAssert.ThrowingCallable throwingCallable, String message) {
            ((AbstractThrowableAssert)Assertions.assertThatCode((ThrowableAssert.ThrowingCallable)throwingCallable).withFailMessage(message, new Object[0])).doesNotThrowAnyException();
        }
    }

    static final class AssertThatCodeDoesNotThrowAnyException {
        AssertThatCodeDoesNotThrowAnyException() {
        }

        void before(Executable throwingCallable) {
            org.junit.jupiter.api.Assertions.assertDoesNotThrow((Executable)throwingCallable);
        }

        void before(ThrowingSupplier<?> throwingCallable) {
            org.junit.jupiter.api.Assertions.assertDoesNotThrow(throwingCallable);
        }

        void after(ThrowableAssert.ThrowingCallable throwingCallable) {
            Assertions.assertThatCode((ThrowableAssert.ThrowingCallable)throwingCallable).doesNotThrowAnyException();
        }
    }

    static final class AssertThatThrownByWithFailMessageSupplierIsInstanceOf<T extends Throwable> {
        AssertThatThrownByWithFailMessageSupplierIsInstanceOf() {
        }

        void before(Executable throwingCallable, Class<T> clazz, Supplier<String> supplier) {
            org.junit.jupiter.api.Assertions.assertThrows(clazz, (Executable)throwingCallable, supplier);
        }

        void after(ThrowableAssert.ThrowingCallable throwingCallable, Class<T> clazz, Supplier<String> supplier) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).withFailMessage(supplier)).isInstanceOf(clazz);
        }
    }

    static final class AssertThatThrownByWithFailMessageStringIsInstanceOf<T extends Throwable> {
        AssertThatThrownByWithFailMessageStringIsInstanceOf() {
        }

        void before(Executable throwingCallable, Class<T> clazz, String message) {
            org.junit.jupiter.api.Assertions.assertThrows(clazz, (Executable)throwingCallable, (String)message);
        }

        void after(ThrowableAssert.ThrowingCallable throwingCallable, Class<T> clazz, String message) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).withFailMessage(message, new Object[0])).isInstanceOf(clazz);
        }
    }

    static final class AssertThatThrownByIsInstanceOf<T extends Throwable> {
        AssertThatThrownByIsInstanceOf() {
        }

        void before(Executable throwingCallable, Class<T> clazz) {
            org.junit.jupiter.api.Assertions.assertThrows(clazz, (Executable)throwingCallable);
        }

        void after(ThrowableAssert.ThrowingCallable throwingCallable, Class<T> clazz) {
            Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isInstanceOf(clazz);
        }
    }

    static final class AssertThatThrownByWithFailMessageSupplierIsExactlyInstanceOf<T extends Throwable> {
        AssertThatThrownByWithFailMessageSupplierIsExactlyInstanceOf() {
        }

        void before(Executable throwingCallable, Class<T> clazz, Supplier<String> supplier) {
            org.junit.jupiter.api.Assertions.assertThrowsExactly(clazz, (Executable)throwingCallable, supplier);
        }

        void after(ThrowableAssert.ThrowingCallable throwingCallable, Class<T> clazz, Supplier<String> supplier) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).withFailMessage(supplier)).isExactlyInstanceOf(clazz);
        }
    }

    static final class AssertThatThrownByWithFailMessageStringIsExactlyInstanceOf<T extends Throwable> {
        AssertThatThrownByWithFailMessageStringIsExactlyInstanceOf() {
        }

        void before(Executable throwingCallable, Class<T> clazz, String message) {
            org.junit.jupiter.api.Assertions.assertThrowsExactly(clazz, (Executable)throwingCallable, (String)message);
        }

        void after(ThrowableAssert.ThrowingCallable throwingCallable, Class<T> clazz, String message) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).withFailMessage(message, new Object[0])).isExactlyInstanceOf(clazz);
        }
    }

    static final class AssertThatThrownByIsExactlyInstanceOf<T extends Throwable> {
        AssertThatThrownByIsExactlyInstanceOf() {
        }

        void before(Executable throwingCallable, Class<T> clazz) {
            org.junit.jupiter.api.Assertions.assertThrowsExactly(clazz, (Executable)throwingCallable);
        }

        void after(ThrowableAssert.ThrowingCallable throwingCallable, Class<T> clazz) {
            Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isExactlyInstanceOf(clazz);
        }
    }

    static final class AssertThatWithFailMessageSupplierIsNotSameAs {
        AssertThatWithFailMessageSupplierIsNotSameAs() {
        }

        void before(Object actual, Object expected, Supplier<String> supplier) {
            org.junit.jupiter.api.Assertions.assertNotSame((Object)expected, (Object)actual, supplier);
        }

        void after(Object actual, Object expected, Supplier<String> supplier) {
            ((ObjectAssert)Assertions.assertThat((Object)actual).withFailMessage(supplier)).isNotSameAs(expected);
        }
    }

    static final class AssertThatWithFailMessageStringIsNotSameAs {
        AssertThatWithFailMessageStringIsNotSameAs() {
        }

        void before(Object actual, Object expected, String message) {
            org.junit.jupiter.api.Assertions.assertNotSame((Object)expected, (Object)actual, (String)message);
        }

        void after(Object actual, Object expected, String message) {
            ((ObjectAssert)Assertions.assertThat((Object)actual).withFailMessage(message, new Object[0])).isNotSameAs(expected);
        }
    }

    static final class AssertThatIsNotSameAs {
        AssertThatIsNotSameAs() {
        }

        void before(Object actual, Object expected) {
            org.junit.jupiter.api.Assertions.assertNotSame((Object)expected, (Object)actual);
        }

        void after(Object actual, Object expected) {
            Assertions.assertThat((Object)actual).isNotSameAs(expected);
        }
    }

    static final class AssertThatWithFailMessageSupplierIsSameAs {
        AssertThatWithFailMessageSupplierIsSameAs() {
        }

        void before(Object actual, Object expected, Supplier<String> supplier) {
            org.junit.jupiter.api.Assertions.assertSame((Object)expected, (Object)actual, supplier);
        }

        void after(Object actual, Object expected, Supplier<String> supplier) {
            ((ObjectAssert)Assertions.assertThat((Object)actual).withFailMessage(supplier)).isSameAs(expected);
        }
    }

    static final class AssertThatWithFailMessageStringIsSameAs {
        AssertThatWithFailMessageStringIsSameAs() {
        }

        void before(Object actual, Object expected, String message) {
            org.junit.jupiter.api.Assertions.assertSame((Object)expected, (Object)actual, (String)message);
        }

        void after(Object actual, Object expected, String message) {
            ((ObjectAssert)Assertions.assertThat((Object)actual).withFailMessage(message, new Object[0])).isSameAs(expected);
        }
    }

    static final class AssertThatIsSameAs {
        AssertThatIsSameAs() {
        }

        void before(Object actual, Object expected) {
            org.junit.jupiter.api.Assertions.assertSame((Object)expected, (Object)actual);
        }

        void after(Object actual, Object expected) {
            Assertions.assertThat((Object)actual).isSameAs(expected);
        }
    }

    static final class AssertThatWithFailMessageSupplierIsNotNull {
        AssertThatWithFailMessageSupplierIsNotNull() {
        }

        void before(Object actual, Supplier<String> supplier) {
            org.junit.jupiter.api.Assertions.assertNotNull((Object)actual, supplier);
        }

        void after(Object actual, Supplier<String> supplier) {
            ((ObjectAssert)Assertions.assertThat((Object)actual).withFailMessage(supplier)).isNotNull();
        }
    }

    static final class AssertThatWithFailMessageStringIsNotNull {
        AssertThatWithFailMessageStringIsNotNull() {
        }

        void before(Object actual, String message) {
            org.junit.jupiter.api.Assertions.assertNotNull((Object)actual, (String)message);
        }

        void after(Object actual, String message) {
            ((ObjectAssert)Assertions.assertThat((Object)actual).withFailMessage(message, new Object[0])).isNotNull();
        }
    }

    static final class AssertThatIsNotNull {
        AssertThatIsNotNull() {
        }

        void before(Object actual) {
            org.junit.jupiter.api.Assertions.assertNotNull((Object)actual);
        }

        void after(Object actual) {
            Assertions.assertThat((Object)actual).isNotNull();
        }
    }

    static final class AssertThatWithFailMessageSupplierIsNull {
        AssertThatWithFailMessageSupplierIsNull() {
        }

        void before(Object actual, Supplier<String> supplier) {
            org.junit.jupiter.api.Assertions.assertNull((Object)actual, supplier);
        }

        void after(Object actual, Supplier<String> supplier) {
            ((ObjectAssert)Assertions.assertThat((Object)actual).withFailMessage(supplier)).isNull();
        }
    }

    static final class AssertThatWithFailMessageStringIsNull {
        AssertThatWithFailMessageStringIsNull() {
        }

        void before(Object actual, String message) {
            org.junit.jupiter.api.Assertions.assertNull((Object)actual, (String)message);
        }

        void after(Object actual, String message) {
            ((ObjectAssert)Assertions.assertThat((Object)actual).withFailMessage(message, new Object[0])).isNull();
        }
    }

    static final class AssertThatIsNull {
        AssertThatIsNull() {
        }

        void before(Object actual) {
            org.junit.jupiter.api.Assertions.assertNull((Object)actual);
        }

        void after(Object actual) {
            Assertions.assertThat((Object)actual).isNull();
        }
    }

    static final class AssertThatWithFailMessageSupplierIsFalse {
        AssertThatWithFailMessageSupplierIsFalse() {
        }

        void before(boolean actual, Supplier<String> supplier) {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)actual, supplier);
        }

        void after(boolean actual, Supplier<String> supplier) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)actual).withFailMessage(supplier)).isFalse();
        }
    }

    static final class AssertThatWithFailMessageStringIsFalse {
        AssertThatWithFailMessageStringIsFalse() {
        }

        void before(boolean actual, String message) {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)actual, (String)message);
        }

        void after(boolean actual, String message) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)actual).withFailMessage(message, new Object[0])).isFalse();
        }
    }

    static final class AssertThatIsFalse {
        AssertThatIsFalse() {
        }

        void before(boolean actual) {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)actual);
        }

        void after(boolean actual) {
            Assertions.assertThat((boolean)actual).isFalse();
        }
    }

    static final class AssertThatWithFailMessageSupplierIsTrue {
        AssertThatWithFailMessageSupplierIsTrue() {
        }

        void before(boolean actual, Supplier<String> supplier) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)actual, supplier);
        }

        void after(boolean actual, Supplier<String> supplier) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)actual).withFailMessage(supplier)).isTrue();
        }
    }

    static final class AssertThatWithFailMessageStringIsTrue {
        AssertThatWithFailMessageStringIsTrue() {
        }

        void before(boolean actual, String message) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)actual, (String)message);
        }

        void after(boolean actual, String message) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)actual).withFailMessage(message, new Object[0])).isTrue();
        }
    }

    static final class AssertThatIsTrue {
        AssertThatIsTrue() {
        }

        void before(boolean actual) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)actual);
        }

        void after(boolean actual) {
            Assertions.assertThat((boolean)actual).isTrue();
        }
    }

    static final class FailWithThrowable {
        FailWithThrowable() {
        }

        void before(Throwable throwable) {
            org.junit.jupiter.api.Assertions.fail((Throwable)throwable);
        }

        @DoNotCall
        void after(Throwable throwable) {
            throw new AssertionError((Object)throwable);
        }
    }

    static final class FailWithMessageAndThrowable<T> {
        FailWithMessageAndThrowable() {
        }

        T before(String message, Throwable throwable) {
            return (T)org.junit.jupiter.api.Assertions.fail((String)message, (Throwable)throwable);
        }

        T after(String message, Throwable throwable) {
            return (T)Assertions.fail((String)message, (Throwable)throwable);
        }
    }

    static final class FailWithMessage<T> {
        FailWithMessage() {
        }

        T before(String message) {
            return (T)org.junit.jupiter.api.Assertions.fail((String)message);
        }

        T after(String message) {
            return (T)Assertions.fail((String)message);
        }
    }

    static final class ThrowNewAssertionError {
        ThrowNewAssertionError() {
        }

        void before() {
            org.junit.jupiter.api.Assertions.fail();
        }

        @DoNotCall
        void after() {
            throw new AssertionError();
        }
    }
}

