/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.errorprone.refaster.Refaster;
import java.util.Objects;
import java.util.function.Predicate;

final class EqualityRules {
    private EqualityRules() {
    }

    static final class IndirectDoubleNegation {
        IndirectDoubleNegation() {
        }

        boolean before(boolean a, boolean b) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{a == b, a ? b : !b});
        }

        boolean before(double a, double b) {
            return a == b;
        }

        boolean before(Object a, Object b) {
            return a == b;
        }

        boolean after(boolean a, boolean b) {
            return a == b;
        }
    }

    static final class Negation {
        Negation() {
        }

        boolean before(boolean a, boolean b) {
            Object[] objectArray = new Boolean[2];
            objectArray[0] = a != b;
            objectArray[1] = a ? !b : b;
            return (Boolean)Refaster.anyOf((Object[])objectArray);
        }

        boolean before(double a, double b) {
            return a != b;
        }

        boolean before(Object a, Object b) {
            return a != b;
        }

        boolean after(boolean a, boolean b) {
            return a != b;
        }
    }

    static final class DoubleNegation {
        DoubleNegation() {
        }

        boolean before(boolean b) {
            return b;
        }

        boolean after(boolean b) {
            return b;
        }
    }

    static final class EqualsPredicate<T> {
        EqualsPredicate() {
        }

        Predicate<T> before(T v) {
            return e -> v.equals(e);
        }

        Predicate<T> after(T v) {
            return v::equals;
        }
    }

    static final class PrimitiveOrReferenceEquality<T extends Enum<T>> {
        PrimitiveOrReferenceEquality() {
        }

        boolean before(T a, T b) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{((Enum)a).equals(b), Objects.equals(a, b)});
        }

        boolean after(T a, T b) {
            return a == b;
        }
    }
}

