/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns.util;

import com.google.errorprone.VisitorState;
import com.google.errorprone.suppliers.Supplier;
import com.sun.tools.javac.code.ClassFinder;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;

public enum ThirdPartyLibrary {
    ASSERTJ("org.assertj.core.api.Assertions"),
    GUAVA("com.google.common.collect.ImmutableList"),
    NEW_RELIC_AGENT_API("com.newrelic.api.agent.Agent"),
    REACTOR("reactor.core.publisher.Flux");

    private static final String IGNORE_CLASSPATH_COMPAT_FLAG = "ErrorProneSupport:IgnoreClasspathCompat";
    private final Supplier<Boolean> canUse = VisitorState.memoize((Supplier & Serializable)state -> ThirdPartyLibrary.canIntroduceUsage(witnessFqcn, state));

    private ThirdPartyLibrary(String witnessFqcn) {
    }

    public boolean isIntroductionAllowed(VisitorState state) {
        return (Boolean)this.canUse.get(state);
    }

    private static boolean canIntroduceUsage(String className, VisitorState state) {
        return ThirdPartyLibrary.shouldIgnoreClasspath(state) || ThirdPartyLibrary.isKnownClass(className, state);
    }

    private static boolean isKnownClass(String className, VisitorState state) {
        return state.getTypeFromString(className) != null || ThirdPartyLibrary.canLoadClass(className, state);
    }

    private static boolean canLoadClass(String className, VisitorState state) {
        ClassFinder classFinder = ClassFinder.instance(state.context);
        Name binaryName = state.binaryNameFromClassname(className);
        try {
            classFinder.loadClass(state.getSymtab().unnamedModule, binaryName);
            return true;
        }
        catch (Symbol.CompletionFailure e) {
            return false;
        }
    }

    private static boolean shouldIgnoreClasspath(VisitorState state) {
        return state.errorProneOptions().getFlags().getBoolean(IGNORE_CLASSPATH_COMPAT_FLAG).orElse(Boolean.FALSE);
    }
}

