/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns.util;

import com.google.common.base.CharMatcher;
import com.google.errorprone.VisitorState;
import com.google.errorprone.fixes.SuggestedFix;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.util.JCDiagnostic;

public final class SourceCode {
    private static final CharMatcher NON_WHITESPACE_MATCHER = CharMatcher.whitespace().negate();

    private SourceCode() {
    }

    public static String treeToString(Tree tree, VisitorState state) {
        String src = state.getSourceForNode(tree);
        return src != null ? src : tree.toString();
    }

    public static SuggestedFix deleteWithTrailingWhitespace(Tree tree, VisitorState state) {
        CharSequence sourceCode = state.getSourceCode();
        int endPos = state.getEndPosition(tree);
        if (sourceCode == null || endPos == -1) {
            return SuggestedFix.delete((Tree)tree);
        }
        int whitespaceEndPos = NON_WHITESPACE_MATCHER.indexIn(sourceCode, endPos);
        return SuggestedFix.replace((int)((JCDiagnostic.DiagnosticPosition)((Object)tree)).getStartPosition(), (int)(whitespaceEndPos == -1 ? sourceCode.length() : whitespaceEndPos), (String)"");
    }
}

