/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;

public final class MoreASTHelpers {
    private MoreASTHelpers() {
    }

    public static ImmutableList<MethodTree> findMethods(CharSequence methodName, VisitorState state) {
        ClassTree clazz = (ClassTree)state.findEnclosing(new Class[]{ClassTree.class});
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"Visited node is not enclosed by a class");
        return (ImmutableList)clazz.getMembers().stream().filter(MethodTree.class::isInstance).map(MethodTree.class::cast).filter(method -> method.getName().contentEquals(methodName)).collect(ImmutableList.toImmutableList());
    }

    public static boolean methodExistsInEnclosingClass(CharSequence methodName, VisitorState state) {
        return !MoreASTHelpers.findMethods(methodName, state).isEmpty();
    }
}

