/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;

@BugPattern(summary="Derive the current time from an existing `Clock` Spring bean, and don't rely on a `Clock`'s time zone", link="https://error-prone.picnic.tech/bugpatterns/TimeZoneUsage", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
@AutoService(value={BugChecker.class})
public final class TimeZoneUsage
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> BANNED_TIME_METHOD = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.allOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onDescendantOf(Clock.class.getName()).namedAnyOf(new String[]{"getZone", "withZone"}), Matchers.not((Matcher)Matchers.enclosingClass((Matcher)Matchers.isSubtypeOf(Clock.class)))}), Matchers.staticMethod().onClass(Clock.class.getName()).namedAnyOf(new String[]{"system", "systemDefaultZone", "systemUTC", "tickMillis", "tickMinutes", "tickSeconds"}), Matchers.staticMethod().onClassAny(new String[]{LocalDate.class.getName(), LocalDateTime.class.getName(), LocalTime.class.getName(), OffsetDateTime.class.getName(), OffsetTime.class.getName(), ZonedDateTime.class.getName()}).named("now"), Matchers.staticMethod().onClassAny(new String[]{Instant.class.getName()}).named("now").withNoParameters()});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return BANNED_TIME_METHOD.matches((Tree)tree, state) ? this.buildDescription(tree).build() : Description.NO_MATCH;
    }
}

