/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="The Refaster rule contains a method without any Refaster annotations", link="https://error-prone.picnic.tech/bugpatterns/MissingRefasterAnnotation", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, tags={"LikelyError"})
@AutoService(value={BugChecker.class})
public final class MissingRefasterAnnotation
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final MultiMatcher<Tree, AnnotationTree> REFASTER_ANNOTATION = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isType((String)"com.google.errorprone.refaster.annotation.Placeholder"), Matchers.isType((String)"com.google.errorprone.refaster.annotation.BeforeTemplate"), Matchers.isType((String)"com.google.errorprone.refaster.annotation.AfterTemplate")}));

    public Description matchClass(ClassTree tree, VisitorState state) {
        long methodTypes = tree.getMembers().stream().filter(member -> member.getKind() == Tree.Kind.METHOD).map(MethodTree.class::cast).filter(method -> !ASTHelpers.isGeneratedConstructor((MethodTree)method)).map(method -> REFASTER_ANNOTATION.matches((Tree)method, state)).distinct().count();
        return methodTypes < 2L ? Description.NO_MATCH : this.buildDescription(tree).build();
    }
}

