/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.primitives.Ints;

final class PrimitiveRules {
    private PrimitiveRules() {
    }

    static final class LongToIntExact {
        LongToIntExact() {
        }

        int before(long a) {
            return Ints.checkedCast((long)a);
        }

        int after(long a) {
            return Math.toIntExact(a);
        }
    }

    static final class GreaterThanOrEqualTo {
        GreaterThanOrEqualTo() {
        }

        boolean before(double a, double b) {
            return !(a < b);
        }

        boolean after(long a, long b) {
            return a >= b;
        }
    }

    static final class GreaterThan {
        GreaterThan() {
        }

        boolean before(double a, double b) {
            return !(a <= b);
        }

        boolean after(long a, long b) {
            return a > b;
        }
    }

    static final class LessThanOrEqualTo {
        LessThanOrEqualTo() {
        }

        boolean before(double a, double b) {
            return !(a > b);
        }

        boolean after(long a, long b) {
            return a <= b;
        }
    }

    static final class LessThan {
        LessThan() {
        }

        boolean before(double a, double b) {
            return !(a >= b);
        }

        boolean after(long a, long b) {
            return a < b;
        }
    }
}

