/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.errorprone.refaster.Refaster;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Stream;

final class ImmutableSetRules {
    private ImmutableSetRules() {
    }

    static final class ImmutableSetOf5<T> {
        ImmutableSetOf5() {
        }

        Set<T> before(T e1, T e2, T e3, T e4, T e5) {
            return Set.of(e1, e2, e3, e4, e5);
        }

        ImmutableSet<T> after(T e1, T e2, T e3, T e4, T e5) {
            return ImmutableSet.of(e1, e2, e3, e4, e5);
        }
    }

    static final class ImmutableSetOf4<T> {
        ImmutableSetOf4() {
        }

        Set<T> before(T e1, T e2, T e3, T e4) {
            return Set.of(e1, e2, e3, e4);
        }

        ImmutableSet<T> after(T e1, T e2, T e3, T e4) {
            return ImmutableSet.of(e1, e2, e3, e4);
        }
    }

    static final class ImmutableSetOf3<T> {
        ImmutableSetOf3() {
        }

        Set<T> before(T e1, T e2, T e3) {
            return Set.of(e1, e2, e3);
        }

        ImmutableSet<T> after(T e1, T e2, T e3) {
            return ImmutableSet.of(e1, e2, e3);
        }
    }

    static final class ImmutableSetOf2<T> {
        ImmutableSetOf2() {
        }

        Set<T> before(T e1, T e2) {
            return Set.of(e1, e2);
        }

        ImmutableSet<T> after(T e1, T e2) {
            return ImmutableSet.of(e1, e2);
        }
    }

    static final class ImmutableSetOf1<T> {
        ImmutableSetOf1() {
        }

        Set<T> before(T e1) {
            return (Set)Refaster.anyOf((Object[])new Set[]{ImmutableSet.builder().add(e1).build(), Collections.singleton(e1), Set.of(e1)});
        }

        ImmutableSet<T> after(T e1) {
            return ImmutableSet.of(e1);
        }
    }

    static final class ImmutableSetOf<T> {
        ImmutableSetOf() {
        }

        Set<T> before() {
            return (Set)Refaster.anyOf((Object[])new Set[]{ImmutableSet.builder().build(), (Set)Stream.empty().collect(ImmutableSet.toImmutableSet()), Collections.emptySet(), Set.of()});
        }

        ImmutableSet<T> after() {
            return ImmutableSet.of();
        }
    }

    static final class ImmutableSetCopyOfSetView<T> {
        ImmutableSetCopyOfSetView() {
        }

        ImmutableSet<T> before(Sets.SetView<T> set) {
            return ImmutableSet.copyOf(set);
        }

        ImmutableSet<T> after(Sets.SetView<T> set) {
            return set.immutableCopy();
        }
    }

    static final class StreamToImmutableSet<T> {
        StreamToImmutableSet() {
        }

        ImmutableSet<T> before(Stream<T> stream) {
            return (ImmutableSet)Refaster.anyOf((Object[])new ImmutableSet[]{ImmutableSet.copyOf(stream.iterator()), (ImmutableSet)stream.distinct().collect(ImmutableSet.toImmutableSet())});
        }

        ImmutableSet<T> after(Stream<T> stream) {
            return (ImmutableSet)stream.collect(ImmutableSet.toImmutableSet());
        }
    }

    static final class IterableToImmutableSet<T> {
        IterableToImmutableSet() {
        }

        ImmutableSet<T> before(T[] iterable) {
            return (ImmutableSet)Refaster.anyOf((Object[])new ImmutableSet[]{ImmutableSet.builder().add((Object[])iterable).build(), (ImmutableSet)Arrays.stream(iterable).collect(ImmutableSet.toImmutableSet())});
        }

        ImmutableSet<T> before(Iterator<T> iterable) {
            return (ImmutableSet)Refaster.anyOf((Object[])new ImmutableSet[]{ImmutableSet.builder().addAll(iterable).build(), (ImmutableSet)Streams.stream(iterable).collect(ImmutableSet.toImmutableSet())});
        }

        ImmutableSet<T> before(Iterable<T> iterable) {
            return (ImmutableSet)Refaster.anyOf((Object[])new ImmutableSet[]{ImmutableSet.builder().addAll(iterable).build(), (ImmutableSet)Streams.stream(iterable).collect(ImmutableSet.toImmutableSet())});
        }

        ImmutableSet<T> before(Collection<T> iterable) {
            return (ImmutableSet)iterable.stream().collect(ImmutableSet.toImmutableSet());
        }

        ImmutableSet<T> after(Iterable<T> iterable) {
            return ImmutableSet.copyOf(iterable);
        }
    }

    static final class ImmutableSetBuilder<T> {
        ImmutableSetBuilder() {
        }

        ImmutableSet.Builder<T> before() {
            return new ImmutableSet.Builder();
        }

        ImmutableSet.Builder<T> after() {
            return ImmutableSet.builder();
        }
    }
}

