/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns.util;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.matchers.AnnotationMatcherUtils;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import java.util.Objects;
import org.jspecify.nullness.Nullable;
import tech.picnic.errorprone.bugpatterns.util.MoreMatchers;

public final class MoreJUnitMatchers {
    public static final MultiMatcher<MethodTree, AnnotationTree> TEST_METHOD = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isType((String)"org.junit.jupiter.api.Test"), MoreMatchers.hasMetaAnnotation("org.junit.jupiter.api.TestTemplate")}));
    public static final MultiMatcher<MethodTree, AnnotationTree> SETUP_OR_TEARDOWN_METHOD = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isType((String)"org.junit.jupiter.api.AfterAll"), Matchers.isType((String)"org.junit.jupiter.api.AfterEach"), Matchers.isType((String)"org.junit.jupiter.api.BeforeAll"), Matchers.isType((String)"org.junit.jupiter.api.BeforeEach")}));
    public static final MultiMatcher<MethodTree, AnnotationTree> HAS_METHOD_SOURCE = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.isType((String)"org.junit.jupiter.params.provider.MethodSource"));

    private MoreJUnitMatchers() {
    }

    static ImmutableSet<String> getMethodSourceFactoryNames(AnnotationTree methodSourceAnnotation, MethodTree method) {
        String methodName = method.getName().toString();
        ExpressionTree value = AnnotationMatcherUtils.getArgument((AnnotationTree)methodSourceAnnotation, (String)"value");
        if (!(value instanceof NewArrayTree)) {
            return ImmutableSet.of((Object)MoreJUnitMatchers.toMethodSourceFactoryName(value, methodName));
        }
        return (ImmutableSet)((NewArrayTree)value).getInitializers().stream().map(name -> MoreJUnitMatchers.toMethodSourceFactoryName(name, methodName)).collect(ImmutableSet.toImmutableSet());
    }

    private static String toMethodSourceFactoryName(@Nullable ExpressionTree tree, String annotatedMethodName) {
        return Objects.requireNonNullElse(Strings.emptyToNull((String)((String)ASTHelpers.constValue((Tree)tree, String.class))), annotatedMethodName);
    }
}

