/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.base.Splitter;
import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.nullness.Nullable;
import tech.picnic.errorprone.bugpatterns.util.AnnotationAttributeMatcher;
import tech.picnic.errorprone.bugpatterns.util.SourceCode;

@BugPattern(summary="Where possible, sort annotation array attributes lexicographically", link="https://error-prone.picnic.tech/bugpatterns/LexicographicalAnnotationAttributeListing", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Style"})
@AutoService(value={BugChecker.class})
public final class LexicographicalAnnotationAttributeListing
extends BugChecker
implements BugChecker.AnnotationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final ImmutableSet<String> BLACKLISTED_ANNOTATIONS = ImmutableSet.of((Object)"com.fasterxml.jackson.annotation.JsonPropertyOrder#value", (Object)"io.swagger.annotations.ApiImplicitParams#value", (Object)"io.swagger.v3.oas.annotations.Parameters#value", (Object)"javax.xml.bind.annotation.XmlType#propOrder", (Object)"org.springframework.context.annotation.PropertySource#value", (Object)"org.springframework.test.context.TestPropertySource#locations", (Object[])new String[]{"org.springframework.test.context.TestPropertySource#value"});
    private static final String FLAG_PREFIX = "LexicographicalAnnotationAttributeListing:";
    private static final String INCLUDED_ANNOTATIONS_FLAG = "LexicographicalAnnotationAttributeListing:Includes";
    private static final String EXCLUDED_ANNOTATIONS_FLAG = "LexicographicalAnnotationAttributeListing:Excludes";
    private static final Splitter STRING_ARGUMENT_SPLITTER = Splitter.on((char)'=');
    private final AnnotationAttributeMatcher matcher;

    public LexicographicalAnnotationAttributeListing() {
        this(ErrorProneFlags.empty());
    }

    public LexicographicalAnnotationAttributeListing(ErrorProneFlags flags) {
        this.matcher = LexicographicalAnnotationAttributeListing.createAnnotationAttributeMatcher(flags);
    }

    public Description matchAnnotation(AnnotationTree tree, VisitorState state) {
        return this.sortArrayElements(tree, state).map(fix -> this.describeMatch(tree, (Fix)fix)).orElse(Description.NO_MATCH);
    }

    private Optional<Fix> sortArrayElements(AnnotationTree tree, VisitorState state) {
        return this.matcher.extractMatchingArguments(tree).map(expr -> LexicographicalAnnotationAttributeListing.extractArray(expr).flatMap(arr -> LexicographicalAnnotationAttributeListing.suggestSorting(arr, state))).flatMap(Optional::stream).reduce(SuggestedFix.Builder::merge).map(SuggestedFix.Builder::build);
    }

    private static Optional<NewArrayTree> extractArray(ExpressionTree expr) {
        if (expr.getKind() == Tree.Kind.ASSIGNMENT) {
            return LexicographicalAnnotationAttributeListing.extractArray(((AssignmentTree)expr).getExpression());
        }
        return Optional.of(expr).filter(e -> e.getKind() == Tree.Kind.NEW_ARRAY).map(NewArrayTree.class::cast);
    }

    private static Optional<SuggestedFix.Builder> suggestSorting(NewArrayTree array, VisitorState state) {
        ImmutableList<? extends ExpressionTree> desiredOrdering;
        if (array.getInitializers().size() < 2 || !LexicographicalAnnotationAttributeListing.canSort(array, state)) {
            return Optional.empty();
        }
        List<? extends ExpressionTree> actualOrdering = array.getInitializers();
        if (actualOrdering.equals(desiredOrdering = LexicographicalAnnotationAttributeListing.doSort(actualOrdering))) {
            return Optional.empty();
        }
        String suggestion = desiredOrdering.stream().map(expr -> SourceCode.treeToString(expr, state)).collect(Collectors.joining(", ", "{", "}"));
        return Optional.of(SuggestedFix.builder().replace((Tree)array, suggestion));
    }

    private static boolean canSort(Tree array, VisitorState state) {
        Type type = ASTHelpers.getType((Tree)array);
        if (type == null) {
            return false;
        }
        Symtab symtab = state.getSymtab();
        Type elemType = state.getTypes().elemtype(type);
        return Stream.of(symtab.annotationType, symtab.classType, symtab.enumSym.type, symtab.stringType).anyMatch(t -> ASTHelpers.isSubtype((Type)elemType, (Type)t, (VisitorState)state));
    }

    private static ImmutableList<? extends ExpressionTree> doSort(Iterable<? extends ExpressionTree> elements) {
        return ImmutableList.sortedCopyOf(Comparator.comparing(LexicographicalAnnotationAttributeListing::getStructure, Comparators.lexicographical((Comparator)Comparators.lexicographical(String.CASE_INSENSITIVE_ORDER.thenComparing(Comparator.naturalOrder())))), elements);
    }

    private static ImmutableList<ImmutableList<String>> getStructure(ExpressionTree array) {
        final ImmutableList.Builder nodes = ImmutableList.builder();
        new TreeScanner<Void, Void>(){

            @Override
            public @Nullable Void visitIdentifier(IdentifierTree node, @Nullable Void unused) {
                nodes.add((Object)ImmutableList.of((Object)node.getName().toString()));
                return (Void)super.visitIdentifier(node, unused);
            }

            @Override
            public @Nullable Void visitLiteral(LiteralTree node, @Nullable Void unused) {
                Object value = ASTHelpers.constValue((Tree)node);
                nodes.add((Object)(value instanceof String ? (ImmutableList)STRING_ARGUMENT_SPLITTER.splitToStream((CharSequence)((String)value)).collect(ImmutableList.toImmutableList()) : ImmutableList.of((Object)String.valueOf(value))));
                return (Void)super.visitLiteral(node, unused);
            }

            @Override
            public @Nullable Void visitPrimitiveType(PrimitiveTypeTree node, @Nullable Void unused) {
                nodes.add((Object)ImmutableList.of((Object)node.getPrimitiveTypeKind().toString()));
                return (Void)super.visitPrimitiveType(node, unused);
            }
        }.scan(array, null);
        return nodes.build();
    }

    private static AnnotationAttributeMatcher createAnnotationAttributeMatcher(ErrorProneFlags flags) {
        return AnnotationAttributeMatcher.create(flags.getList(INCLUDED_ANNOTATIONS_FLAG), LexicographicalAnnotationAttributeListing.excludedAnnotations(flags));
    }

    private static ImmutableList<String> excludedAnnotations(ErrorProneFlags flags) {
        HashSet<String> exclusions = new HashSet<String>();
        flags.getList(EXCLUDED_ANNOTATIONS_FLAG).ifPresent(exclusions::addAll);
        exclusions.addAll((Collection<String>)BLACKLISTED_ANNOTATIONS);
        return ImmutableList.copyOf(exclusions);
    }
}

