/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.collect.Streams;
import com.google.errorprone.refaster.Refaster;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class StreamRules {
    private StreamRules() {
    }

    static abstract class StreamAllMatch2<T> {
        StreamAllMatch2() {
        }

        abstract boolean test(T var1);

        boolean before(Stream<T> stream) {
            return stream.noneMatch(e -> !this.test(e));
        }

        boolean after(Stream<T> stream) {
            return stream.allMatch(e -> this.test(e));
        }
    }

    static final class StreamAllMatch<T> {
        StreamAllMatch() {
        }

        boolean before(Stream<T> stream, Predicate<? super T> predicate) {
            return stream.noneMatch((Predicate)Refaster.anyOf((Object[])new Predicate[]{Predicate.not(predicate), predicate.negate()}));
        }

        boolean after(Stream<T> stream, Predicate<? super T> predicate) {
            return stream.allMatch(predicate);
        }
    }

    static final class StreamAnyMatch<T> {
        StreamAnyMatch() {
        }

        boolean before(Stream<T> stream, Predicate<? super T> predicate) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{!stream.noneMatch(predicate), stream.filter(predicate).findAny().isPresent()});
        }

        boolean after(Stream<T> stream, Predicate<? super T> predicate) {
            return stream.anyMatch(predicate);
        }
    }

    static abstract class StreamNoneMatch2<T> {
        StreamNoneMatch2() {
        }

        abstract boolean test(T var1);

        boolean before(Stream<T> stream) {
            return stream.allMatch(e -> !this.test(e));
        }

        boolean after(Stream<T> stream) {
            return stream.noneMatch(e -> this.test(e));
        }
    }

    static final class StreamNoneMatch<T> {
        StreamNoneMatch() {
        }

        boolean before(Stream<T> stream, Predicate<? super T> predicate) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{!stream.anyMatch(predicate), stream.allMatch((Predicate)Refaster.anyOf((Object[])new Predicate[]{Predicate.not(predicate), predicate.negate()})), stream.filter(predicate).findAny().isEmpty()});
        }

        boolean after(Stream<T> stream, Predicate<? super T> predicate) {
            return stream.noneMatch(predicate);
        }
    }

    static final class StreamMaxNaturalOrder<T extends Comparable<? super T>> {
        StreamMaxNaturalOrder() {
        }

        Optional<T> before(Stream<T> stream) {
            return (Optional)Refaster.anyOf((Object[])new Optional[]{stream.min(Comparator.reverseOrder()), Streams.findLast(stream.sorted())});
        }

        Optional<T> after(Stream<T> stream) {
            return stream.max(Comparator.naturalOrder());
        }
    }

    static final class StreamMax<T> {
        StreamMax() {
        }

        Optional<T> before(Stream<T> stream, Comparator<? super T> comparator) {
            return (Optional)Refaster.anyOf((Object[])new Optional[]{stream.min(comparator.reversed()), Streams.findLast(stream.sorted(comparator))});
        }

        Optional<T> after(Stream<T> stream, Comparator<? super T> comparator) {
            return stream.max(comparator);
        }
    }

    static final class StreamMinNaturalOrder<T extends Comparable<? super T>> {
        StreamMinNaturalOrder() {
        }

        Optional<T> before(Stream<T> stream) {
            return (Optional)Refaster.anyOf((Object[])new Optional[]{stream.max(Comparator.reverseOrder()), stream.sorted().findFirst()});
        }

        Optional<T> after(Stream<T> stream) {
            return stream.min(Comparator.naturalOrder());
        }
    }

    static final class StreamMin<T> {
        StreamMin() {
        }

        Optional<T> before(Stream<T> stream, Comparator<? super T> comparator) {
            return (Optional)Refaster.anyOf((Object[])new Optional[]{stream.max(comparator.reversed()), stream.sorted(comparator).findFirst()});
        }

        Optional<T> after(Stream<T> stream, Comparator<? super T> comparator) {
            return stream.min(comparator);
        }
    }

    static final class StreamIsNotEmpty<T> {
        StreamIsNotEmpty() {
        }

        boolean before(Stream<T> stream) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{stream.count() != 0L, stream.count() > 0L, stream.count() >= 1L, stream.findFirst().isPresent()});
        }

        boolean after(Stream<T> stream) {
            return stream.findAny().isPresent();
        }
    }

    static final class StreamIsEmpty<T> {
        StreamIsEmpty() {
        }

        boolean before(Stream<T> stream) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{stream.count() == 0L, stream.count() <= 0L, stream.count() < 1L, stream.findFirst().isEmpty()});
        }

        boolean after(Stream<T> stream) {
            return stream.findAny().isEmpty();
        }
    }

    static final class StreamMapFirst<T, S> {
        StreamMapFirst() {
        }

        Optional<S> before(Stream<T> stream, Function<? super T, S> function) {
            return stream.map(function).findFirst();
        }

        Optional<S> after(Stream<T> stream, Function<? super T, S> function) {
            return stream.findFirst().map(function);
        }
    }

    static abstract class FlatMapOuterStreamAfterFlatMap<T, S, R> {
        FlatMapOuterStreamAfterFlatMap() {
        }

        abstract Stream<S> toStreamFunction(T var1);

        Stream<R> before(Stream<T> stream, Function<? super S, ? extends Stream<? extends R>> function) {
            return stream.flatMap(v -> this.toStreamFunction(v).flatMap(function));
        }

        Stream<R> after(Stream<T> stream, Function<? super S, ? extends Stream<? extends R>> function) {
            return stream.flatMap(v -> this.toStreamFunction(v)).flatMap(function);
        }
    }

    static abstract class MapOuterStreamAfterFlatMap<T, S, R> {
        MapOuterStreamAfterFlatMap() {
        }

        abstract Stream<S> toStreamFunction(T var1);

        Stream<R> before(Stream<T> stream, Function<? super S, ? extends R> function) {
            return stream.flatMap(v -> this.toStreamFunction(v).map(function));
        }

        Stream<R> after(Stream<T> stream, Function<? super S, ? extends R> function) {
            return stream.flatMap(v -> this.toStreamFunction(v)).map(function);
        }
    }

    static abstract class FilterOuterStreamAfterFlatMap<T, S> {
        FilterOuterStreamAfterFlatMap() {
        }

        abstract Stream<S> toStreamFunction(T var1);

        Stream<S> before(Stream<T> stream, Predicate<? super S> predicate) {
            return stream.flatMap(v -> this.toStreamFunction(v).filter(predicate));
        }

        Stream<S> after(Stream<T> stream, Predicate<? super S> predicate) {
            return stream.flatMap(v -> this.toStreamFunction(v)).filter(predicate);
        }
    }

    static final class ConcatTwoStreams<T> {
        ConcatTwoStreams() {
        }

        Stream<T> before(Stream<T> s1, Stream<T> s2) {
            return Streams.concat((Stream[])new Stream[]{s1, s2});
        }

        Stream<T> after(Stream<T> s1, Stream<T> s2) {
            return Stream.concat(s1, s2);
        }
    }

    static final class ConcatOneStream<T> {
        ConcatOneStream() {
        }

        Stream<T> before(Stream<T> stream) {
            return Streams.concat((Stream[])new Stream[]{stream});
        }

        Stream<T> after(Stream<T> stream) {
            return stream;
        }
    }

    static final class StreamOfArray<T> {
        StreamOfArray() {
        }

        Stream<T> before(T[] array) {
            return Stream.of(array);
        }

        Stream<T> after(T[] array) {
            return Arrays.stream(array);
        }
    }

    static final class StreamOfNullable<T> {
        StreamOfNullable() {
        }

        Stream<T> before(T object) {
            return (Stream)Refaster.anyOf((Object[])new Stream[]{Stream.of(object).filter(Objects::nonNull), Optional.ofNullable(object).stream()});
        }

        Stream<T> after(T object) {
            return Stream.ofNullable(object);
        }
    }

    static final class EmptyStream<T> {
        EmptyStream() {
        }

        Stream<T> before() {
            return Stream.of(new Object[0]);
        }

        Stream<T> after() {
            return Stream.empty();
        }
    }

    static final class Joining {
        Joining() {
        }

        Collector<CharSequence, ?, String> before() {
            return Collectors.joining("");
        }

        Collector<CharSequence, ?, String> after() {
            return Collectors.joining();
        }
    }
}

