/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import java.util.List;

@BugPattern(summary="Omit `@Autowired` on a class' sole constructor, as it is redundant", link="https://error-prone.picnic.tech/bugpatterns/AutowiredConstructor", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Simplification"})
@AutoService(value={BugChecker.class})
public final class AutowiredConstructor
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final MultiMatcher<Tree, AnnotationTree> AUTOWIRED_ANNOTATION = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.isType((String)"org.springframework.beans.factory.annotation.Autowired"));

    public Description matchClass(ClassTree tree, VisitorState state) {
        List constructors = ASTHelpers.getConstructors((ClassTree)tree);
        if (constructors.size() != 1) {
            return Description.NO_MATCH;
        }
        ImmutableList annotations = AUTOWIRED_ANNOTATION.multiMatchResult((Tree)Iterables.getOnlyElement((Iterable)constructors), state).matchingNodes();
        if (annotations.size() != 1) {
            return Description.NO_MATCH;
        }
        AnnotationTree annotation = (AnnotationTree)Iterables.getOnlyElement((Iterable)annotations);
        return this.describeMatch(annotation, (Fix)SuggestedFix.delete((Tree)annotation));
    }
}

