/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.collect.MoreCollectors;
import com.google.errorprone.refaster.Refaster;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.reactivestreams.Publisher;
import reactor.core.CorePublisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;
import reactor.test.publisher.PublisherProbe;

final class ReactorRules {
    private ReactorRules() {
    }

    static final class StepVerifierLastStepVerifyTimeout {
        StepVerifierLastStepVerifyTimeout() {
        }

        Duration before(StepVerifier.LastStep step, Duration duration) {
            return step.expectTimeout(duration).verify();
        }

        Duration after(StepVerifier.LastStep step, Duration duration) {
            return step.verifyTimeout(duration);
        }
    }

    static final class StepVerifierLastStepVerifyErrorMessage {
        StepVerifierLastStepVerifyErrorMessage() {
        }

        Duration before(StepVerifier.LastStep step, String message) {
            return step.expectErrorMessage(message).verify();
        }

        Duration after(StepVerifier.LastStep step, String message) {
            return step.verifyErrorMessage(message);
        }
    }

    static final class StepVerifierLastStepVerifyErrorSatisfies {
        StepVerifierLastStepVerifyErrorSatisfies() {
        }

        Duration before(StepVerifier.LastStep step, Consumer<Throwable> consumer) {
            return step.expectErrorSatisfies(consumer).verify();
        }

        Duration after(StepVerifier.LastStep step, Consumer<Throwable> consumer) {
            return step.verifyErrorSatisfies(consumer);
        }
    }

    static final class StepVerifierLastStepVerifyErrorMatches {
        StepVerifierLastStepVerifyErrorMatches() {
        }

        Duration before(StepVerifier.LastStep step, Predicate<Throwable> predicate) {
            return step.expectErrorMatches(predicate).verify();
        }

        Duration after(StepVerifier.LastStep step, Predicate<Throwable> predicate) {
            return step.verifyErrorMatches(predicate);
        }
    }

    static final class StepVerifierLastStepVerifyErrorClass<T extends Throwable> {
        StepVerifierLastStepVerifyErrorClass() {
        }

        Duration before(StepVerifier.LastStep step, Class<T> clazz) {
            return (Duration)Refaster.anyOf((Object[])new Duration[]{step.expectError(clazz).verify(), step.verifyErrorSatisfies(t -> Assertions.assertThat((Throwable)t).isInstanceOf(clazz))});
        }

        Duration after(StepVerifier.LastStep step, Class<T> clazz) {
            return step.verifyError(clazz);
        }
    }

    static final class StepVerifierLastStepVerifyError {
        StepVerifierLastStepVerifyError() {
        }

        Duration before(StepVerifier.LastStep step) {
            return step.expectError().verify();
        }

        Duration after(StepVerifier.LastStep step) {
            return step.verifyError();
        }
    }

    static final class StepVerifierLastStepVerifyComplete {
        StepVerifierLastStepVerifyComplete() {
        }

        Duration before(StepVerifier.LastStep step) {
            return step.expectComplete().verify();
        }

        Duration after(StepVerifier.LastStep step) {
            return step.verifyComplete();
        }
    }

    static final class StepVerifierStepExpectNext<T> {
        StepVerifierStepExpectNext() {
        }

        StepVerifier.Step<T> before(StepVerifier.Step<T> step, T object) {
            Object[] objectArray = new StepVerifier.Step[2];
            objectArray[0] = step.expectNextMatches(e -> e.equals(object));
            objectArray[1] = step.expectNextMatches(object::equals);
            return (StepVerifier.Step)Refaster.anyOf((Object[])objectArray);
        }

        StepVerifier.Step<T> after(StepVerifier.Step<T> step, T object) {
            return step.expectNext(object);
        }
    }

    static final class StepVerifierStepExpectNextEmpty<T> {
        StepVerifierStepExpectNextEmpty() {
        }

        StepVerifier.Step<T> before(StepVerifier.Step<T> step) {
            return step.expectNext(new Object[0]);
        }

        StepVerifier.Step<T> after(StepVerifier.Step<T> step) {
            return step;
        }
    }

    static final class StepVerifierFromFlux<T> {
        StepVerifierFromFlux() {
        }

        StepVerifier.FirstStep<? extends T> before(Flux<T> flux) {
            return StepVerifier.create(flux);
        }

        StepVerifier.FirstStep<? extends T> after(Flux<T> flux) {
            return (StepVerifier.FirstStep)flux.as(StepVerifier::create);
        }
    }

    static final class StepVerifierFromMono<T> {
        StepVerifierFromMono() {
        }

        StepVerifier.FirstStep<? extends T> before(Mono<T> mono) {
            return StepVerifier.create(mono);
        }

        StepVerifier.FirstStep<? extends T> after(Mono<T> mono) {
            return (StepVerifier.FirstStep)mono.as(StepVerifier::create);
        }
    }

    static final class PublisherProbeEmpty<T> {
        PublisherProbeEmpty() {
        }

        PublisherProbe<T> before() {
            return PublisherProbe.of((Publisher)((Publisher)Refaster.anyOf((Object[])new CorePublisher[]{Mono.empty(), Flux.empty()})));
        }

        PublisherProbe<T> after() {
            return PublisherProbe.empty();
        }
    }

    static final class FluxOnErrorComplete<T> {
        FluxOnErrorComplete() {
        }

        Flux<T> before(Flux<T> flux) {
            return flux.onErrorResume(e -> (Publisher)Refaster.anyOf((Object[])new CorePublisher[]{Mono.empty(), Flux.empty()}));
        }

        Flux<T> after(Flux<T> flux) {
            return flux.onErrorComplete();
        }
    }

    static final class MonoOnErrorComplete<T> {
        MonoOnErrorComplete() {
        }

        Mono<T> before(Mono<T> mono) {
            return mono.onErrorResume(e -> Mono.empty());
        }

        Mono<T> after(Mono<T> mono) {
            return mono.onErrorComplete();
        }
    }

    static final class ConcatMapIterableIdentityWithPrefetch<T> {
        ConcatMapIterableIdentityWithPrefetch() {
        }

        Flux<T> before(Flux<? extends Iterable<T>> flux, int prefetch) {
            return (Flux)Refaster.anyOf((Object[])new Flux[]{flux.concatMap(list -> Flux.fromIterable((Iterable)list), prefetch), flux.concatMap(Flux::fromIterable, prefetch)});
        }

        Flux<T> after(Flux<? extends Iterable<T>> flux, int prefetch) {
            return flux.concatMapIterable(Function.identity(), prefetch);
        }
    }

    static final class ConcatMapIterableIdentity<T> {
        ConcatMapIterableIdentity() {
        }

        Flux<T> before(Flux<? extends Iterable<T>> flux) {
            return (Flux)Refaster.anyOf((Object[])new Flux[]{flux.concatMap(list -> Flux.fromIterable((Iterable)list)), flux.concatMap(Flux::fromIterable)});
        }

        Flux<T> after(Flux<? extends Iterable<T>> flux) {
            return flux.concatMapIterable(Function.identity());
        }
    }

    static final class FluxCast<T, S> {
        FluxCast() {
        }

        Flux<S> before(Flux<T> flux) {
            return flux.map(Refaster.clazz()::cast);
        }

        Flux<S> after(Flux<T> flux) {
            return flux.cast(Refaster.clazz());
        }
    }

    static final class MonoCast<T, S> {
        MonoCast() {
        }

        Mono<S> before(Mono<T> mono) {
            return mono.map(Refaster.clazz()::cast);
        }

        Mono<S> after(Mono<T> mono) {
            return mono.cast(Refaster.clazz());
        }
    }

    static final class MonoCollectToOptional<T> {
        MonoCollectToOptional() {
        }

        Mono<Optional<T>> before(Mono<T> mono) {
            return (Mono)Refaster.anyOf((Object[])new Mono[]{mono.map(Optional::of).defaultIfEmpty(Optional.empty()), mono.map(Optional::of).switchIfEmpty(Mono.just(Optional.empty()))});
        }

        Mono<Optional<T>> after(Mono<T> mono) {
            return mono.flux().collect(MoreCollectors.toOptional());
        }
    }

    static final class MonoFlux<T> {
        MonoFlux() {
        }

        Flux<T> before(Mono<T> mono) {
            return Flux.concat((Publisher[])new Publisher[]{mono});
        }

        Flux<T> after(Mono<T> mono) {
            return mono.flux();
        }
    }

    static abstract class MonoFlatMapToFlux<T, S> {
        MonoFlatMapToFlux() {
        }

        abstract Mono<S> valueTransformation(T var1);

        Flux<S> before(Mono<T> mono) {
            return mono.flatMapMany(v -> this.valueTransformation(v));
        }

        Flux<S> after(Mono<T> mono) {
            return mono.flatMap(v -> this.valueTransformation(v)).flux();
        }
    }

    static final class FluxConcatMapIterableWithPrefetch<T, S> {
        FluxConcatMapIterableWithPrefetch() {
        }

        Flux<S> before(Flux<T> flux, Function<? super T, ? extends Iterable<? extends S>> function, int prefetch) {
            return flux.flatMapIterable(function, prefetch);
        }

        Flux<S> after(Flux<T> flux, Function<? super T, ? extends Iterable<? extends S>> function, int prefetch) {
            return flux.concatMapIterable(function, prefetch);
        }
    }

    static final class FluxConcatMapIterable<T, S> {
        FluxConcatMapIterable() {
        }

        Flux<S> before(Flux<T> flux, Function<? super T, ? extends Iterable<? extends S>> function) {
            return flux.flatMapIterable(function);
        }

        Flux<S> after(Flux<T> flux, Function<? super T, ? extends Iterable<? extends S>> function) {
            return flux.concatMapIterable(function);
        }
    }

    static final class FluxConcatMapWithPrefetch<T, S> {
        FluxConcatMapWithPrefetch() {
        }

        Flux<S> before(Flux<T> flux, Function<? super T, ? extends Publisher<? extends S>> function, int prefetch) {
            return (Flux)Refaster.anyOf((Object[])new Flux[]{flux.flatMap(function, 1, prefetch), flux.flatMapSequential(function, 1, prefetch)});
        }

        Flux<S> after(Flux<T> flux, Function<? super T, ? extends Publisher<? extends S>> function, int prefetch) {
            return flux.concatMap(function, prefetch);
        }
    }

    static final class FluxConcatMap<T, S> {
        FluxConcatMap() {
        }

        Flux<S> before(Flux<T> flux, Function<? super T, ? extends Publisher<? extends S>> function) {
            return (Flux)Refaster.anyOf((Object[])new Flux[]{flux.flatMap(function, 1), flux.flatMapSequential(function, 1)});
        }

        Flux<S> after(Flux<T> flux, Function<? super T, ? extends Publisher<? extends S>> function) {
            return flux.concatMap(function);
        }
    }

    static final class FluxSwitchIfEmptyOfEmptyPublisher<T> {
        FluxSwitchIfEmptyOfEmptyPublisher() {
        }

        Flux<T> before(Flux<T> flux) {
            return flux.switchIfEmpty((Publisher)Refaster.anyOf((Object[])new CorePublisher[]{Mono.empty(), Flux.empty()}));
        }

        Flux<T> after(Flux<T> flux) {
            return flux;
        }
    }

    static final class MonoSwitchIfEmptyOfEmptyPublisher<T> {
        MonoSwitchIfEmptyOfEmptyPublisher() {
        }

        Mono<T> before(Mono<T> mono) {
            return mono.switchIfEmpty(Mono.empty());
        }

        Mono<T> after(Mono<T> mono) {
            return mono;
        }
    }

    static final class MonoThenReturn<T, S> {
        MonoThenReturn() {
        }

        Mono<S> before(Mono<T> mono, S object) {
            return mono.then(Mono.just(object));
        }

        Mono<S> after(Mono<T> mono, S object) {
            return mono.thenReturn(object);
        }
    }

    static final class FluxErrorSupplier<T, E extends Throwable> {
        FluxErrorSupplier() {
        }

        Flux<T> before(Supplier<E> supplier) {
            return Flux.error(() -> (Throwable)supplier.get());
        }

        Flux<T> after(Supplier<E> supplier) {
            return Flux.error(supplier);
        }
    }

    static final class MonoErrorSupplier<T, E extends Throwable> {
        MonoErrorSupplier() {
        }

        Mono<T> before(Supplier<E> supplier) {
            return Mono.error(() -> (Throwable)supplier.get());
        }

        Mono<T> after(Supplier<E> supplier) {
            return Mono.error(supplier);
        }
    }

    static final class FluxDeferredError<T> {
        FluxDeferredError() {
        }

        Flux<T> before(Throwable throwable) {
            return Flux.defer(() -> Flux.error((Throwable)throwable));
        }

        Flux<T> after(Throwable throwable) {
            return Flux.error(() -> throwable);
        }
    }

    static final class MonoDeferredError<T> {
        MonoDeferredError() {
        }

        Mono<T> before(Throwable throwable) {
            return Mono.defer(() -> Mono.error((Throwable)throwable));
        }

        Mono<T> after(Throwable throwable) {
            return Mono.error(() -> throwable);
        }
    }

    static final class MonoFromOptional<T> {
        MonoFromOptional() {
        }

        Mono<T> before(Optional<T> optional) {
            return (Mono)Refaster.anyOf((Object[])new Mono[]{Mono.fromCallable(() -> optional.orElse(null)), Mono.fromSupplier(() -> optional.orElse(null))});
        }

        Mono<T> after(Optional<T> optional) {
            return Mono.defer(() -> Mono.justOrEmpty((Optional)optional));
        }
    }

    static final class MonoFromSupplier<T> {
        MonoFromSupplier() {
        }

        Mono<T> before(Callable<? extends T> supplier) {
            return Mono.fromCallable(supplier);
        }

        Mono<T> after(Supplier<? extends T> supplier) {
            return Mono.fromSupplier(supplier);
        }
    }
}

