/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.errorprone.refaster.Refaster;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

final class MultimapRules {
    private MultimapRules() {
    }

    static final class MultimapGet<K, V> {
        MultimapGet() {
        }

        @Nullable
        Collection<V> before(Multimap<K, V> multimap, K key) {
            return (Collection)((Map)Refaster.anyOf((Object[])new Map[]{multimap.asMap(), Multimaps.asMap(multimap)})).get(key);
        }

        Collection<V> after(Multimap<K, V> multimap, K key) {
            return multimap.get(key);
        }
    }

    static final class MultimapSize<K, V> {
        MultimapSize() {
        }

        int before(Multimap<K, V> multimap) {
            return multimap.values().size();
        }

        int after(Multimap<K, V> multimap) {
            return multimap.size();
        }
    }

    static final class MultimapKeySet<K, V> {
        MultimapKeySet() {
        }

        Set<K> before(Multimap<K, V> multimap) {
            return multimap.asMap().keySet();
        }

        Set<K> after(Multimap<K, V> multimap) {
            return multimap.keySet();
        }
    }
}

