/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import java.util.Optional;

@BugPattern(summary="Avoid nesting `Optional`s inside `Optional`s; the resultant code is hard to reason about", link="https://error-prone.picnic.tech/bugpatterns/NestedOptionals", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
@AutoService(value={BugChecker.class})
public final class NestedOptionals
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Supplier<Type> OPTIONAL = Suppliers.typeFromClass(Optional.class);

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return NestedOptionals.isOptionalOfOptional(tree, state) ? this.describeMatch(tree) : Description.NO_MATCH;
    }

    private static boolean isOptionalOfOptional(Tree tree, VisitorState state) {
        Type optionalType = (Type)OPTIONAL.get(state);
        Type type = ASTHelpers.getType((Tree)tree);
        if (!ASTHelpers.isSubtype((Type)type, (Type)optionalType, (VisitorState)state)) {
            return false;
        }
        List<Type> typeArguments = type.getTypeArguments();
        return !typeArguments.isEmpty() && ASTHelpers.isSubtype((Type)((Type)Iterables.getOnlyElement(typeArguments)), (Type)optionalType, (VisitorState)state);
    }
}

