/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.function.Function;

@BugPattern(summary="`Flux#flatMap` and `Flux#flatMapSequential` have subtle semantics; please use `Flux#concatMap` or explicitly specify the desired amount of concurrency", link="https://error-prone.picnic.tech/bugpatterns/FluxFlatMapUsage", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, tags={"LikelyError"})
@AutoService(value={BugChecker.class})
public final class FluxFlatMapUsage
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.MemberReferenceTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final String MAX_CONCURRENCY_ARG_NAME = "MAX_CONCURRENCY";
    private static final Matcher<ExpressionTree> FLUX_FLATMAP = MethodMatchers.instanceMethod().onDescendantOf("reactor.core.publisher.Flux").namedAnyOf(new String[]{"flatMap", "flatMapSequential"}).withParameters(Function.class.getName(), new String[0]);

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!FLUX_FLATMAP.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).addFix((Fix)SuggestedFixes.renameMethodInvocation((MethodInvocationTree)tree, (String)"concatMap", (VisitorState)state)).addFix((Fix)SuggestedFix.builder().postfixWith((Tree)Iterables.getOnlyElement(tree.getArguments()), ", MAX_CONCURRENCY").build()).build();
    }

    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        if (!FLUX_FLATMAP.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }
}

