/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="Avoid `Collectors.to{List,Map,Set}` in favour of alternatives that emphasize (im)mutability", link="https://error-prone.picnic.tech/bugpatterns/CollectorMutability", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
@AutoService(value={BugChecker.class})
public final class CollectorMutability
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> COLLECTOR_METHOD = MethodMatchers.staticMethod().onClass("java.util.stream.Collectors");
    private static final Matcher<ExpressionTree> LIST_COLLECTOR = MethodMatchers.staticMethod().anyClass().named("toList");
    private static final Matcher<ExpressionTree> MAP_COLLECTOR = MethodMatchers.staticMethod().anyClass().named("toMap");
    private static final Matcher<ExpressionTree> SET_COLLECTOR = MethodMatchers.staticMethod().anyClass().named("toSet");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!COLLECTOR_METHOD.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        if (LIST_COLLECTOR.matches((Tree)tree, state)) {
            return this.suggestToCollectionAlternatives(tree, "com.google.common.collect.ImmutableList.toImmutableList", "ArrayList", state);
        }
        if (MAP_COLLECTOR.matches((Tree)tree, state)) {
            return this.suggestToMapAlternatives(tree, state);
        }
        if (SET_COLLECTOR.matches((Tree)tree, state)) {
            return this.suggestToCollectionAlternatives(tree, "com.google.common.collect.ImmutableSet.toImmutableSet", "HashSet", state);
        }
        return Description.NO_MATCH;
    }

    private Description suggestToCollectionAlternatives(MethodInvocationTree tree, String fullyQualifiedImmutableReplacement, String mutableReplacement, VisitorState state) {
        SuggestedFix.Builder mutableFix = SuggestedFix.builder();
        String toCollectionSelect = SuggestedFixes.qualifyStaticImport((String)"java.util.stream.Collectors.toCollection", (SuggestedFix.Builder)mutableFix, (VisitorState)state);
        return this.buildDescription(tree).addFix((Fix)CollectorMutability.replaceMethodInvocation(tree, fullyQualifiedImmutableReplacement, state)).addFix((Fix)mutableFix.addImport(String.format("java.util.%s", mutableReplacement)).replace((Tree)tree, String.format("%s(%s::new)", toCollectionSelect, mutableReplacement)).build()).build();
    }

    private Description suggestToMapAlternatives(MethodInvocationTree tree, VisitorState state) {
        int argCount = tree.getArguments().size();
        if (argCount > 3) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).addFix((Fix)CollectorMutability.replaceMethodInvocation(tree, "com.google.common.collect.ImmutableMap.toImmutableMap", state)).addFix((Fix)SuggestedFix.builder().addImport("java.util.HashMap").postfixWith((Tree)tree.getArguments().get(argCount - 1), (argCount == 2 ? ", (a, b) -> { throw new IllegalStateException(); }" : "") + ", HashMap::new").build()).build();
    }

    private static SuggestedFix replaceMethodInvocation(MethodInvocationTree tree, String fullyQualifiedReplacement, VisitorState state) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        String replacement = SuggestedFixes.qualifyStaticImport((String)fullyQualifiedReplacement, (SuggestedFix.Builder)fix, (VisitorState)state);
        fix.merge(SuggestedFix.replace((Tree)tree.getMethodSelect(), (String)replacement));
        return fix.build();
    }
}

