/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refastertemplates;

import com.google.common.collect.Iterables;
import com.google.errorprone.refaster.Refaster;
import java.util.Collection;
import org.assertj.core.api.EnumerableAssert;

final class AssertJEnumerableTemplates {
    private AssertJEnumerableTemplates() {
    }

    static final class EnumerableAssertHasSameSizeAs<S, T> {
        EnumerableAssertHasSameSizeAs() {
        }

        EnumerableAssert<?, S> before(EnumerableAssert<?, S> enumAssert, Iterable<T> iterable) {
            return enumAssert.hasSize(Iterables.size(iterable));
        }

        EnumerableAssert<?, S> before(EnumerableAssert<?, S> enumAssert, Collection<T> iterable) {
            return enumAssert.hasSize(iterable.size());
        }

        EnumerableAssert<?, S> before(EnumerableAssert<?, S> enumAssert, T[] iterable) {
            return enumAssert.hasSize(iterable.length);
        }

        EnumerableAssert<?, S> after(EnumerableAssert<?, S> enumAssert, Iterable<T> iterable) {
            return enumAssert.hasSameSizeAs(iterable);
        }
    }

    static final class EnumerableAssertIsNotEmpty<E> {
        EnumerableAssertIsNotEmpty() {
        }

        EnumerableAssert<?, E> before(EnumerableAssert<?, E> enumAssert) {
            return (EnumerableAssert)Refaster.anyOf((Object[])new EnumerableAssert[]{enumAssert.hasSizeGreaterThan(0), enumAssert.hasSizeGreaterThanOrEqualTo(1)});
        }

        EnumerableAssert<?, E> after(EnumerableAssert<?, E> enumAssert) {
            return enumAssert.isNotEmpty();
        }
    }

    static final class EnumerableAssertIsEmpty<E> {
        EnumerableAssertIsEmpty() {
        }

        void before(EnumerableAssert<?, E> enumAssert) {
            Refaster.anyOf((Object[])new EnumerableAssert[]{enumAssert.hasSize(0), enumAssert.hasSizeLessThanOrEqualTo(0), enumAssert.hasSizeLessThan(1)});
        }

        void after(EnumerableAssert<?, E> enumAssert) {
            enumAssert.isEmpty();
        }
    }
}

