/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refastertemplates;

import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

final class AssertJComparableTemplates {
    private AssertJComparableTemplates() {
    }

    static final class AssertThatIsGreaterThanOrEqualTo<T extends Comparable<? super T>> {
        AssertThatIsGreaterThanOrEqualTo() {
        }

        AbstractIntegerAssert<?> before(T actual, T expected) {
            return Assertions.assertThat((int)actual.compareTo(expected)).isNotNegative();
        }

        AbstractComparableAssert<?, ?> after(T actual, T expected) {
            return Assertions.assertThat(actual).isGreaterThanOrEqualTo(expected);
        }
    }

    static final class AssertThatIsGreaterThan<T extends Comparable<? super T>> {
        AssertThatIsGreaterThan() {
        }

        AbstractIntegerAssert<?> before(T actual, T expected) {
            return Assertions.assertThat((int)actual.compareTo(expected)).isPositive();
        }

        AbstractComparableAssert<?, ?> after(T actual, T expected) {
            return Assertions.assertThat(actual).isGreaterThan(expected);
        }
    }

    static final class AssertThatIsLessThanOrEqualTo<T extends Comparable<? super T>> {
        AssertThatIsLessThanOrEqualTo() {
        }

        AbstractIntegerAssert<?> before(T actual, T expected) {
            return Assertions.assertThat((int)actual.compareTo(expected)).isNotPositive();
        }

        AbstractComparableAssert<?, ?> after(T actual, T expected) {
            return Assertions.assertThat(actual).isLessThanOrEqualTo(expected);
        }
    }

    static final class AssertThatIsLessThan<T extends Comparable<? super T>> {
        AssertThatIsLessThan() {
        }

        AbstractIntegerAssert<?> before(T actual, T expected) {
            return Assertions.assertThat((int)actual.compareTo(expected)).isNegative();
        }

        AbstractComparableAssert<?, ?> after(T actual, T expected) {
            return Assertions.assertThat(actual).isLessThan(expected);
        }
    }

    static final class AssertThatIsNotEqualByComparingTo<T extends Comparable<? super T>> {
        AssertThatIsNotEqualByComparingTo() {
        }

        AbstractIntegerAssert<?> before(T actual, T expected) {
            return Assertions.assertThat((int)actual.compareTo(expected)).isNotEqualTo(0);
        }

        AbstractComparableAssert<?, ?> after(T actual, T expected) {
            return Assertions.assertThat(actual).isNotEqualByComparingTo(expected);
        }
    }

    static final class AssertThatIsEqualByComparingTo<T extends Comparable<? super T>> {
        AssertThatIsEqualByComparingTo() {
        }

        AbstractIntegerAssert<?> before(T actual, T expected) {
            return Assertions.assertThat((int)actual.compareTo(expected)).isEqualTo(0);
        }

        AbstractComparableAssert<?, ?> after(T actual, T expected) {
            return Assertions.assertThat(actual).isEqualByComparingTo(expected);
        }
    }
}

