/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Primitives;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.io.Console;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Formattable;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import tech.picnic.errorprone.bugpatterns.util.MethodMatcherFactory;
import tech.picnic.errorprone.bugpatterns.util.SourceCode;

@BugPattern(summary="Avoid redundant string conversions when possible", linkType=BugPattern.LinkType.NONE, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Simplification"})
@AutoService(value={BugChecker.class})
public final class RedundantStringConversion
extends BugChecker
implements BugChecker.BinaryTreeMatcher,
BugChecker.CompoundAssignmentTreeMatcher,
BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final String FLAG_PREFIX = "RedundantStringConversion:";
    private static final String EXTRA_STRING_CONVERSION_METHODS_FLAG = "RedundantStringConversion:ExtraConversionMethods";
    private static final Matcher<ExpressionTree> ANY_EXPR = (Matcher & Serializable)(t, s) -> true;
    private static final Matcher<ExpressionTree> LOCALE = Matchers.isSameType(Locale.class);
    private static final Matcher<ExpressionTree> MARKER = Matchers.isSubtypeOf((String)"org.slf4j.Marker");
    private static final Matcher<ExpressionTree> STRING = Matchers.isSameType(String.class);
    private static final Matcher<ExpressionTree> THROWABLE = Matchers.isSubtypeOf(Throwable.class);
    private static final Matcher<ExpressionTree> NON_NULL_STRING = Matchers.allOf((Matcher[])new Matcher[]{STRING, Matchers.isNonNullUsingDataflow()});
    private static final Matcher<ExpressionTree> NOT_FORMATTABLE = Matchers.not((Matcher)Matchers.isSubtypeOf(Formattable.class));
    private static final Matcher<MethodInvocationTree> WELL_KNOWN_STRING_CONVERSION_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOfAny(new String[]{Object.class.getName()}).named("toString").withNoParameters(), Matchers.allOf((Matcher[])new Matcher[]{Matchers.argumentCount((int)1), Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClassAny((Iterable)Stream.concat(Primitives.allWrapperTypes().stream(), Stream.of(Objects.class)).map(Class::getName).collect(ImmutableSet.toImmutableSet())).named("toString"), Matchers.allOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass(String.class.getName()).named("valueOf"), Matchers.not((Matcher)Matchers.anyMethod().anyClass().withAnyName().withParametersOfType((Iterable)ImmutableList.of((Object)Suppliers.arrayOf((Supplier)Suppliers.CHAR_TYPE))))})})})});
    private static final Matcher<ExpressionTree> STRINGBUILDER_APPEND_INVOCATION = MethodMatchers.instanceMethod().onDescendantOf(StringBuilder.class.getName()).named("append").withParameters(String.class.getName(), new String[0]);
    private static final Matcher<ExpressionTree> STRINGBUILDER_INSERT_INVOCATION = MethodMatchers.instanceMethod().onDescendantOf(StringBuilder.class.getName()).named("insert").withParameters(Integer.TYPE.getName(), new String[]{String.class.getName()});
    private static final Matcher<ExpressionTree> FORMATTER_INVOCATION = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass(String.class.getName()).named("format"), MethodMatchers.instanceMethod().onDescendantOf(Formatter.class.getName()).named("format"), MethodMatchers.instanceMethod().onDescendantOfAny(new String[]{PrintStream.class.getName(), PrintWriter.class.getName()}).namedAnyOf(new String[]{"format", "printf"}), MethodMatchers.instanceMethod().onDescendantOfAny(new String[]{PrintStream.class.getName(), PrintWriter.class.getName()}).namedAnyOf(new String[]{"print", "println"}).withParameters(Object.class.getName(), new String[0]), MethodMatchers.staticMethod().onClass(Console.class.getName()).namedAnyOf(new String[]{"format", "printf", "readline", "readPassword"})});
    private static final Matcher<ExpressionTree> GUAVA_GUARD_INVOCATION = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("com.google.common.base.Preconditions").namedAnyOf(new String[]{"checkArgument", "checkState", "checkNotNull"}), MethodMatchers.staticMethod().onClass("com.google.common.base.Verify").namedAnyOf(new String[]{"verify", "verifyNotNull"})});
    private static final Matcher<ExpressionTree> SLF4J_LOGGER_INVOCATION = MethodMatchers.instanceMethod().onDescendantOf("org.slf4j.Logger").namedAnyOf(new String[]{"trace", "debug", "info", "warn", "error"});
    private final Matcher<MethodInvocationTree> conversionMethodMatcher;

    public RedundantStringConversion() {
        this(ErrorProneFlags.empty());
    }

    public RedundantStringConversion(ErrorProneFlags flags) {
        this.conversionMethodMatcher = RedundantStringConversion.createConversionMethodMatcher(flags);
    }

    public Description matchBinary(BinaryTree tree, VisitorState state) {
        if (tree.getKind() != Tree.Kind.PLUS) {
            return Description.NO_MATCH;
        }
        ExpressionTree lhs = tree.getLeftOperand();
        ExpressionTree rhs = tree.getRightOperand();
        if (!STRING.matches((Tree)lhs, state)) {
            return this.finalize(tree, this.tryFix(rhs, state, STRING));
        }
        ArrayList fixes = new ArrayList();
        ExpressionTree preferredRhs = this.trySimplify(rhs, state).orElse(rhs);
        if (STRING.matches((Tree)preferredRhs, state)) {
            this.tryFix(lhs, state, ANY_EXPR).ifPresent(fixes::add);
        } else {
            this.tryFix(lhs, state, STRING).ifPresent(fixes::add);
        }
        this.tryFix(rhs, state, ANY_EXPR).ifPresent(fixes::add);
        return this.finalize(tree, fixes.stream().reduce(SuggestedFix.Builder::merge));
    }

    public Description matchCompoundAssignment(CompoundAssignmentTree tree, VisitorState state) {
        if (tree.getKind() != Tree.Kind.PLUS_ASSIGNMENT || !STRING.matches((Tree)tree.getVariable(), state)) {
            return Description.NO_MATCH;
        }
        return this.finalize(tree, this.tryFix(tree.getExpression(), state, ANY_EXPR));
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (STRINGBUILDER_APPEND_INVOCATION.matches((Tree)tree, state)) {
            return this.finalize(tree, this.tryFixPositionalConverter(tree.getArguments(), state, 0));
        }
        if (STRINGBUILDER_INSERT_INVOCATION.matches((Tree)tree, state)) {
            return this.finalize(tree, this.tryFixPositionalConverter(tree.getArguments(), state, 1));
        }
        if (FORMATTER_INVOCATION.matches((Tree)tree, state)) {
            return this.finalize(tree, this.tryFixFormatter(tree.getArguments(), state));
        }
        if (GUAVA_GUARD_INVOCATION.matches((Tree)tree, state)) {
            return this.finalize(tree, this.tryFixGuavaGuard(tree.getArguments(), state));
        }
        if (SLF4J_LOGGER_INVOCATION.matches((Tree)tree, state)) {
            return this.finalize(tree, this.tryFixSlf4jLogger(tree.getArguments(), state));
        }
        if (MethodMatchers.instanceMethod().matches((Tree)tree, state)) {
            return this.finalize(tree, this.tryFix(tree, state, STRING));
        }
        return this.finalize(tree, this.tryFix(tree, state, NON_NULL_STRING));
    }

    private Optional<SuggestedFix.Builder> tryFixPositionalConverter(List<? extends ExpressionTree> arguments, VisitorState state, int index) {
        return Optional.of(arguments).filter(args -> args.size() > index).flatMap(args -> this.tryFix((ExpressionTree)args.get(index), state, ANY_EXPR));
    }

    private Optional<SuggestedFix.Builder> tryFixFormatter(List<? extends ExpressionTree> arguments, VisitorState state) {
        return this.tryFixFormatterArguments(arguments, state, LOCALE, NOT_FORMATTABLE);
    }

    private Optional<SuggestedFix.Builder> tryFixGuavaGuard(List<? extends ExpressionTree> arguments, VisitorState state) {
        return this.tryFixFormatterArguments(arguments, state, ANY_EXPR, ANY_EXPR);
    }

    private Optional<SuggestedFix.Builder> tryFixSlf4jLogger(List<? extends ExpressionTree> arguments, VisitorState state) {
        boolean omitLast = !arguments.isEmpty() && this.trySimplify(arguments.get(arguments.size() - 1), state).filter(replacement -> THROWABLE.matches((Tree)replacement, state)).isPresent();
        return this.tryFixFormatterArguments(omitLast ? arguments.subList(0, arguments.size() - 1) : arguments, state, MARKER, ANY_EXPR);
    }

    private Optional<SuggestedFix.Builder> tryFixFormatterArguments(List<? extends ExpressionTree> arguments, VisitorState state, Matcher<ExpressionTree> firstArgFilter, Matcher<ExpressionTree> remainingArgFilter) {
        int patternIndex;
        if (arguments.isEmpty()) {
            return Optional.empty();
        }
        int n = patternIndex = firstArgFilter.matches((Tree)arguments.get(0), state) ? 1 : 0;
        if (arguments.size() <= patternIndex) {
            return Optional.empty();
        }
        return arguments.stream().skip(patternIndex + 1).map(arg -> this.tryFix((ExpressionTree)arg, state, remainingArgFilter)).flatMap(Optional::stream).reduce(SuggestedFix.Builder::merge);
    }

    private Optional<SuggestedFix.Builder> tryFix(ExpressionTree tree, VisitorState state, Matcher<ExpressionTree> filter) {
        return this.trySimplify(tree, state, filter).map(replacement -> SuggestedFix.builder().replace((Tree)tree, SourceCode.treeToString(replacement, state)));
    }

    private Optional<ExpressionTree> trySimplify(ExpressionTree tree, VisitorState state, Matcher<ExpressionTree> filter) {
        return this.trySimplify(tree, state).filter(result -> filter.matches((Tree)result, state)).map(result -> this.trySimplify((ExpressionTree)result, state, filter).orElse((ExpressionTree)result));
    }

    private Optional<ExpressionTree> trySimplify(ExpressionTree tree, VisitorState state) {
        if (tree.getKind() != Tree.Kind.METHOD_INVOCATION) {
            return Optional.empty();
        }
        MethodInvocationTree methodInvocation = (MethodInvocationTree)tree;
        if (!this.conversionMethodMatcher.matches((Tree)methodInvocation, state)) {
            return Optional.empty();
        }
        switch (methodInvocation.getArguments().size()) {
            case 0: {
                return RedundantStringConversion.trySimplifyNullaryMethod(methodInvocation, state);
            }
            case 1: {
                return RedundantStringConversion.trySimplifyUnaryMethod(methodInvocation, state);
            }
        }
        throw new IllegalStateException("Cannot simplify method call with two or more arguments: " + SourceCode.treeToString(tree, state));
    }

    private static Optional<ExpressionTree> trySimplifyNullaryMethod(MethodInvocationTree methodInvocation, VisitorState state) {
        if (!MethodMatchers.instanceMethod().matches((Tree)methodInvocation, state)) {
            return Optional.empty();
        }
        return Optional.of(methodInvocation.getMethodSelect()).filter(methodSelect -> methodSelect.getKind() == Tree.Kind.MEMBER_SELECT).map(methodSelect -> ((MemberSelectTree)methodSelect).getExpression()).filter(expr -> !"super".equals(SourceCode.treeToString(expr, state)));
    }

    private static Optional<ExpressionTree> trySimplifyUnaryMethod(MethodInvocationTree methodInvocation, VisitorState state) {
        if (!MethodMatchers.staticMethod().matches((Tree)methodInvocation, state)) {
            return Optional.empty();
        }
        return Optional.of((ExpressionTree)Iterables.getOnlyElement(methodInvocation.getArguments()));
    }

    private Description finalize(Tree tree, Optional<SuggestedFix.Builder> fixes) {
        return fixes.map(SuggestedFix.Builder::build).map(fix -> this.describeMatch(tree, (Fix)fix)).orElse(Description.NO_MATCH);
    }

    private static Matcher<MethodInvocationTree> createConversionMethodMatcher(ErrorProneFlags flags) {
        return flags.getList(EXTRA_STRING_CONVERSION_METHODS_FLAG).map(new MethodMatcherFactory()::create).map(m -> Matchers.anyOf((Matcher[])new Matcher[]{WELL_KNOWN_STRING_CONVERSION_METHODS, m})).orElse(WELL_KNOWN_STRING_CONVERSION_METHODS);
    }
}

