/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.function.BiFunction;
import tech.picnic.errorprone.bugpatterns.util.SourceCode;

@BugPattern(summary="Avoid vacuous operations on known non-empty `Mono`s", linkType=BugPattern.LinkType.NONE, severity=BugPattern.SeverityLevel.WARNING, tags={"Simplification"})
@AutoService(value={BugChecker.class})
public final class NonEmptyMono
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> MONO_SIZE_CHECK = Matchers.instanceMethod().onDescendantOf("reactor.core.publisher.Mono").namedAnyOf(new String[]{"defaultIfEmpty", "single", "switchIfEmpty"});
    private static final Matcher<ExpressionTree> NON_EMPTY_MONO = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onDescendantOf("reactor.core.publisher.Flux").namedAnyOf(new String[]{"all", "any", "collect", "collectList", "collectMap", "collectMultimap", "collectSortedList", "count", "elementAt", "hasElement", "hasElements", "last", "reduceWith", "single"}), Matchers.instanceMethod().onDescendantOf("reactor.core.publisher.Flux").named("reduce").withParameters(Object.class.getName(), new String[]{BiFunction.class.getName()}), Matchers.instanceMethod().onDescendantOf("reactor.core.publisher.Mono").namedAnyOf(new String[]{"defaultIfEmpty", "hasElement", "single"})});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MONO_SIZE_CHECK.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
        if (!NON_EMPTY_MONO.matches((Tree)receiver, state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree, (String)SourceCode.treeToString(receiver, state)));
    }
}

