/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.AnnotationMatcherUtils;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tech.picnic.errorprone.bugpatterns.util.SourceCode;

@BugPattern(summary="Omit redundant syntax from annotation declarations", linkType=BugPattern.LinkType.NONE, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Simplification"})
@AutoService(value={BugChecker.class})
public final class CanonicalAnnotationSyntax
extends BugChecker
implements BugChecker.AnnotationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Pattern TRAILING_ARRAY_COMMA = Pattern.compile(",\\s*}$");
    private static final ImmutableSet<BiFunction<AnnotationTree, VisitorState, Optional<Fix>>> FIX_FACTORIES = ImmutableSet.of(CanonicalAnnotationSyntax::dropRedundantParentheses, CanonicalAnnotationSyntax::dropRedundantValueAttribute, CanonicalAnnotationSyntax::dropRedundantCurlies);

    public Description matchAnnotation(AnnotationTree tree, VisitorState state) {
        return FIX_FACTORIES.stream().map(op -> (Optional)op.apply(tree, state)).flatMap(Optional::stream).findFirst().map(fix -> this.describeMatch(tree, (Fix)fix)).orElse(Description.NO_MATCH);
    }

    private static Optional<Fix> dropRedundantParentheses(AnnotationTree tree, VisitorState state) {
        if (!tree.getArguments().isEmpty()) {
            return Optional.empty();
        }
        String src = state.getSourceForNode((Tree)tree);
        if (src == null) {
            return Optional.empty();
        }
        int parenIndex = src.indexOf(40);
        if (parenIndex < 0) {
            return Optional.empty();
        }
        return Optional.of(SuggestedFix.replace((Tree)tree, (String)src.substring(0, parenIndex)));
    }

    private static Optional<Fix> dropRedundantValueAttribute(AnnotationTree tree, VisitorState state) {
        List<? extends ExpressionTree> args = tree.getArguments();
        if (args.size() != 1) {
            return Optional.empty();
        }
        ExpressionTree arg = args.get(0);
        if (state.getSourceForNode((Tree)arg) == null) {
            return Optional.empty();
        }
        ExpressionTree expr = AnnotationMatcherUtils.getArgument((AnnotationTree)tree, (String)"value");
        if (expr == null) {
            return Optional.empty();
        }
        return Optional.of(SuggestedFix.replace((Tree)arg, (String)CanonicalAnnotationSyntax.simplifyAttributeValue(expr, state).orElseGet(() -> SourceCode.treeToString(expr, state))));
    }

    private static Optional<Fix> dropRedundantCurlies(AnnotationTree tree, VisitorState state) {
        ArrayList fixes = new ArrayList();
        for (ExpressionTree expressionTree : tree.getArguments()) {
            ExpressionTree value = expressionTree.getKind() == Tree.Kind.ASSIGNMENT ? ((AssignmentTree)expressionTree).getExpression() : expressionTree;
            CanonicalAnnotationSyntax.simplifyAttributeValue(value, state).ifPresent(expr -> fixes.add(SuggestedFix.builder().replace((Tree)value, expr)));
        }
        return fixes.stream().reduce(SuggestedFix.Builder::merge).map(SuggestedFix.Builder::build);
    }

    private static Optional<String> simplifyAttributeValue(ExpressionTree expr, VisitorState state) {
        if (expr.getKind() != Tree.Kind.NEW_ARRAY) {
            return Optional.empty();
        }
        NewArrayTree array = (NewArrayTree)expr;
        return CanonicalAnnotationSyntax.simplifySingletonArray(array, state).or(() -> CanonicalAnnotationSyntax.dropTrailingComma(array, state));
    }

    private static Optional<String> simplifySingletonArray(NewArrayTree array, VisitorState state) {
        return Optional.of(array.getInitializers()).filter(initializers -> initializers.size() == 1).map(initializers -> SourceCode.treeToString((Tree)initializers.get(0), state));
    }

    private static Optional<String> dropTrailingComma(NewArrayTree array, VisitorState state) {
        String src = SourceCode.treeToString(array, state);
        return Optional.of(TRAILING_ARRAY_COMMA.matcher(src)).filter(Matcher::find).map(m -> src.substring(0, m.start()) + "}");
    }
}

