/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.errorprone.refaster.Refaster;
import java.util.Deque;
import java.util.Iterator;
import org.jspecify.annotations.Nullable;

final class DequeRules {
    private DequeRules() {
    }

    static final class DequeDescendingIterator<T> {
        DequeDescendingIterator() {
        }

        Iterator<T> before(Deque<T> deque) {
            return deque.reversed().iterator();
        }

        Iterator<T> after(Deque<T> deque) {
            return deque.descendingIterator();
        }
    }

    static final class DequeIterator<T> {
        DequeIterator() {
        }

        Iterator<T> before(Deque<T> deque) {
            return deque.reversed().descendingIterator();
        }

        Iterator<T> after(Deque<T> deque) {
            return deque.iterator();
        }
    }

    static final class DequeRemoveFirstOccurrence<S, T extends S> {
        DequeRemoveFirstOccurrence() {
        }

        boolean before(Deque<S> deque, T element) {
            return deque.remove(element);
        }

        boolean after(Deque<S> deque, T element) {
            return deque.removeFirstOccurrence(element);
        }
    }

    static final class DequePeekFirst<S, T extends S> {
        DequePeekFirst() {
        }

        @Nullable S before(Deque<T> deque) {
            return (S)deque.peek();
        }

        @Nullable S after(Deque<T> deque) {
            return (S)deque.peekFirst();
        }
    }

    static final class DequeGetFirst<S, T extends S> {
        DequeGetFirst() {
        }

        S before(Deque<T> deque) {
            return (S)deque.element();
        }

        S after(Deque<T> deque) {
            return (S)deque.getFirst();
        }
    }

    static final class DequePollFirst<S, T extends S> {
        DequePollFirst() {
        }

        @Nullable S before(Deque<T> deque) {
            return (S)deque.poll();
        }

        @Nullable S after(Deque<T> deque) {
            return (S)deque.pollFirst();
        }
    }

    static final class DequeOfferLast<S, T extends S> {
        DequeOfferLast() {
        }

        boolean before(Deque<S> deque, T element) {
            return deque.offer(element);
        }

        boolean after(Deque<S> deque, T element) {
            return deque.offerLast(element);
        }
    }

    static final class DequeRemoveFirst<S, T extends S> {
        DequeRemoveFirst() {
        }

        S before(Deque<T> deque) {
            return (S)Refaster.anyOf((Object[])new Object[]{deque.pop(), deque.remove()});
        }

        S after(Deque<T> deque) {
            return (S)deque.removeFirst();
        }
    }

    static final class DequeAddLast<S, T extends S> {
        DequeAddLast() {
        }

        void before(Deque<S> deque, T element) {
            deque.add(element);
        }

        void after(Deque<S> deque, T element) {
            deque.addLast(element);
        }
    }

    static final class DequeAddFirst<S, T extends S> {
        DequeAddFirst() {
        }

        void before(Deque<S> deque, T element) {
            deque.push(element);
        }

        void after(Deque<S> deque, T element) {
            deque.addFirst(element);
        }
    }
}

