/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.errorprone.refaster.Refaster;
import java.util.Collection;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;

final class AssertJStreamRules {
    private AssertJStreamRules() {
    }

    static final class AssertThatCollection<T> {
        AssertThatCollection() {
        }

        ListAssert<T> before(Collection<T> collection) {
            return Assertions.assertThat(collection.stream());
        }

        AbstractCollectionAssert<?, ?, T, ?> after(Collection<T> collection) {
            return Assertions.assertThat(collection);
        }
    }

    static final class AssertThatAnyMatch<T> {
        AssertThatAnyMatch() {
        }

        ListAssert<T> before(Stream<T> stream, Predicate<? super T> predicate) {
            return (ListAssert)((ListAssert)Assertions.assertThat(stream).filteredOn(predicate)).isNotEmpty();
        }

        AbstractBooleanAssert<?> before2(Stream<T> stream, Predicate<? super T> predicate) {
            return (AbstractBooleanAssert)Refaster.anyOf((Object[])new AbstractBooleanAssert[]{Assertions.assertThat((boolean)stream.anyMatch(predicate)).isTrue(), Assertions.assertThat((boolean)stream.noneMatch(predicate)).isFalse()});
        }

        ListAssert<T> after(Stream<T> stream, Predicate<? super T> predicate) {
            return (ListAssert)Assertions.assertThat(stream).anyMatch(predicate);
        }
    }

    static final class AssertThatNoneMatch<T> {
        AssertThatNoneMatch() {
        }

        void before(Stream<T> stream, Predicate<? super T> predicate) {
            ((ListAssert)Assertions.assertThat(stream).filteredOn(predicate)).isEmpty();
        }

        void before2(Stream<T> stream, Predicate<? super T> predicate) {
            Refaster.anyOf((Object[])new AbstractBooleanAssert[]{Assertions.assertThat((boolean)stream.anyMatch(predicate)).isFalse(), Assertions.assertThat((boolean)stream.noneMatch(predicate)).isTrue()});
        }

        void after(Stream<T> stream, Predicate<? super T> predicate) {
            Assertions.assertThat(stream).noneMatch(predicate);
        }
    }

    static final class AssertThatFilteredOn<T> {
        AssertThatFilteredOn() {
        }

        ListAssert<T> before(Stream<T> stream, Predicate<? super T> predicate) {
            return Assertions.assertThat(stream.filter(predicate));
        }

        ListAssert<T> after(Stream<T> stream, Predicate<? super T> predicate) {
            return (ListAssert)Assertions.assertThat(stream).filteredOn(predicate);
        }
    }

    static final class AssertThatHasSize<T> {
        AssertThatHasSize() {
        }

        AbstractLongAssert<?> before(Stream<T> stream, int size) {
            return Assertions.assertThat((long)stream.count()).isEqualTo((long)size);
        }

        ListAssert<T> after(Stream<T> stream, int size) {
            return (ListAssert)Assertions.assertThat(stream).hasSize(size);
        }
    }

    static final class AssertThatIsNotEmpty<T, S> {
        AssertThatIsNotEmpty() {
        }

        void before(Stream<T> stream) {
            Assertions.assertThat((long)stream.count()).isNotEqualTo(0L);
        }

        void before2(Stream<T> stream) {
            Assertions.assertThat(stream.findAny()).isPresent();
        }

        void before3(Stream<T> stream) {
            Assertions.assertThat(stream.findFirst()).isPresent();
        }

        void before4(Stream<T> stream) {
            Assertions.assertThat((Object[])stream.toArray()).isNotEmpty();
        }

        void before5(Stream<T> stream, IntFunction<S[]> generator) {
            Assertions.assertThat((Object[])stream.toArray(generator)).isNotEmpty();
        }

        void before6(Stream<T> stream) {
            Assertions.assertThat(stream.toList()).isNotEmpty();
        }

        void before7(Stream<T> stream, Collector<? super T, ?, ? extends Iterable<S>> collector) {
            Assertions.assertThat(stream.collect(collector)).isNotEmpty();
        }

        void before8(Stream<T> stream, Collector<? super T, ?, ? extends Collection<S>> collector) {
            Assertions.assertThat(stream.collect(collector)).isNotEmpty();
        }

        void before9(Stream<T> stream, Collector<? super T, ?, ? extends List<S>> collector) {
            Assertions.assertThat(stream.collect(collector)).isNotEmpty();
        }

        void after(Stream<T> stream) {
            Assertions.assertThat(stream).isNotEmpty();
        }
    }

    static final class AssertThatIsEmpty<T, S> {
        AssertThatIsEmpty() {
        }

        void before(Stream<T> stream) {
            Assertions.assertThat(stream.findAny()).isEmpty();
        }

        void before2(Stream<T> stream) {
            Assertions.assertThat(stream.findFirst()).isEmpty();
        }

        void before3(Stream<T> stream) {
            Assertions.assertThat((Object[])stream.toArray()).isEmpty();
        }

        void before4(Stream<T> stream, IntFunction<S[]> generator) {
            Assertions.assertThat((Object[])stream.toArray(generator)).isEmpty();
        }

        void before5(Stream<T> stream) {
            Assertions.assertThat(stream.toList()).isEmpty();
        }

        void before6(Stream<T> stream, Collector<T, ?, ? extends Iterable<S>> collector) {
            Assertions.assertThat(stream.collect(collector)).isEmpty();
        }

        void before7(Stream<T> stream, Collector<T, ?, ? extends Collection<S>> collector) {
            Assertions.assertThat(stream.collect(collector)).isEmpty();
        }

        void before8(Stream<T> stream, Collector<T, ?, ? extends List<S>> collector) {
            Assertions.assertThat(stream.collect(collector)).isEmpty();
        }

        void after(Stream<T> stream) {
            Assertions.assertThat(stream).isEmpty();
        }
    }
}

