/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import tech.picnic.errorprone.utils.MoreASTHelpers;

@BugPattern(summary="Don't unnecessarily pass a type to Mockito's `mock(Class)` and `spy(Class)` methods", link="https://error-prone.picnic.tech/bugpatterns/MockitoMockClassReference", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Simplification"})
@AutoService(value={BugChecker.class})
public final class MockitoMockClassReference
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<MethodInvocationTree> MOCKITO_MOCK_OR_SPY_WITH_HARDCODED_TYPE = Matchers.allOf((Matcher[])new Matcher[]{Matchers.argument((int)0, (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.isSameType((String)Class.class.getCanonicalName()), Matchers.not((Matcher)Matchers.isVariable())})), Matchers.staticMethod().onClass("org.mockito.Mockito").namedAnyOf(new String[]{"mock", "spy"})});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MOCKITO_MOCK_OR_SPY_WITH_HARDCODED_TYPE.matches((Tree)tree, state) || !MockitoMockClassReference.isTypeDerivableFromContext(tree, state)) {
            return Description.NO_MATCH;
        }
        List<? extends ExpressionTree> arguments = tree.getArguments();
        return this.describeMatch(tree, (Fix)SuggestedFixes.removeElement((Tree)arguments.getFirst(), arguments, (VisitorState)state));
    }

    private static boolean isTypeDerivableFromContext(MethodInvocationTree tree, VisitorState state) {
        Tree parent;
        Tree tree2 = parent = state.getPath().getParentPath().getLeaf();
        Objects.requireNonNull(tree2);
        Tree tree3 = tree2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VariableTree.class, AssignmentTree.class, ReturnTree.class}, (Object)tree3, n)) {
            case 0 -> {
                VariableTree variable = (VariableTree)tree3;
                if (!ASTHelpers.hasImplicitType((VariableTree)variable, (VisitorState)state) && MoreASTHelpers.areSameType((Tree)tree, (Tree)variable, (VisitorState)state)) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                AssignmentTree assignment = (AssignmentTree)tree3;
                yield MoreASTHelpers.areSameType((Tree)tree, (Tree)assignment, (VisitorState)state);
            }
            case 2 -> {
                ReturnTree returnTree = (ReturnTree)tree3;
                yield MoreASTHelpers.findMethodExitedOnReturn((VisitorState)state).filter(m -> MoreASTHelpers.areSameType((Tree)tree, (Tree)m.getReturnType(), (VisitorState)state)).isPresent();
            }
            default -> false;
        };
    }
}

