/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class Jackson2RulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`Jackson2Rules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to Jackson 2.x expressions and statements.\n[Source](https://error-prone.picnic.tech/refasterrules/Jackson2Rules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new JsonNodeOptionalIntRecipe(), new JsonNodeOptionalStringRecipe(), new ObjectMapperValueToTreeRecipe(), new ObjectMapperConvertValueWithClassRecipe(), new ObjectMapperConvertValueWithJavaTypeRecipe(), new ObjectMapperConvertValueWithTypeReferenceRecipe()});
    }

    @NullMarked
    public static class JsonNodeOptionalIntRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `Jackson2Rules.JsonNodeOptionalInt`";
        }

        public String getDescription() {
            return "Prefer `JsonNode#optional(int)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{node:any(com.fasterxml.jackson.databind.JsonNode)}.get(#{index:any(int)}).asOptional()").bindType("java.util.Optional<com.fasterxml.jackson.databind.JsonNode>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-core-2", "jackson-databind-2"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{node:any(com.fasterxml.jackson.databind.JsonNode)}.optional(#{index:any(int)})").bindType("java.util.Optional<com.fasterxml.jackson.databind.JsonNode>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-core-2", "jackson-databind-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{node:any(com.fasterxml.jackson.databind.JsonNode)}.path(#{index:any(int)}).asOptional()").bindType("java.util.Optional<com.fasterxml.jackson.databind.JsonNode>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-core-2", "jackson-databind-2"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{node:any(com.fasterxml.jackson.databind.JsonNode)}.optional(#{index:any(int)})").bindType("java.util.Optional<com.fasterxml.jackson.databind.JsonNode>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-core-2", "jackson-databind-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"java.util.Optional.of(#{node:any(com.fasterxml.jackson.databind.JsonNode)}.get(#{index:any(int)}))").bindType("java.util.Optional<com.fasterxml.jackson.databind.JsonNode>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-core-2", "jackson-databind-2"})).build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{node:any(com.fasterxml.jackson.databind.JsonNode)}.optional(#{index:any(int)})").bindType("java.util.Optional<com.fasterxml.jackson.databind.JsonNode>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-core-2", "jackson-databind-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$3 == null) {
                        this.before$3 = JavaTemplate.builder((String)"java.util.Optional.ofNullable(#{node:any(com.fasterxml.jackson.databind.JsonNode)}.get(#{index:any(int)}))").bindType("java.util.Optional<com.fasterxml.jackson.databind.JsonNode>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-core-2", "jackson-databind-2"})).build();
                    }
                    if ((matcher = this.before$3.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{node:any(com.fasterxml.jackson.databind.JsonNode)}.optional(#{index:any(int)})").bindType("java.util.Optional<com.fasterxml.jackson.databind.JsonNode>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-core-2", "jackson-databind-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.fasterxml.jackson.databind.JsonNode", Boolean.valueOf(true)), new UsesType("java.util.Optional", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.fasterxml.jackson.databind.JsonNode asOptional(..)", true), new UsesMethod("com.fasterxml.jackson.databind.JsonNode get(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.fasterxml.jackson.databind.JsonNode asOptional(..)", true), new UsesMethod("com.fasterxml.jackson.databind.JsonNode path(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.fasterxml.jackson.databind.JsonNode get(..)", true), new UsesMethod("java.util.Optional of(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.fasterxml.jackson.databind.JsonNode get(..)", true), new UsesMethod("java.util.Optional ofNullable(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class JsonNodeOptionalStringRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `Jackson2Rules.JsonNodeOptionalString`";
        }

        public String getDescription() {
            return "Prefer `JsonNode#optional(String)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{node:any(com.fasterxml.jackson.databind.JsonNode)}.get(#{fieldName:any(java.lang.String)}).asOptional()").bindType("java.util.Optional<com.fasterxml.jackson.databind.JsonNode>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-core-2", "jackson-databind-2"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{node:any(com.fasterxml.jackson.databind.JsonNode)}.optional(#{fieldName:any(java.lang.String)})").bindType("java.util.Optional<com.fasterxml.jackson.databind.JsonNode>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-core-2", "jackson-databind-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{node:any(com.fasterxml.jackson.databind.JsonNode)}.path(#{fieldName:any(java.lang.String)}).asOptional()").bindType("java.util.Optional<com.fasterxml.jackson.databind.JsonNode>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-core-2", "jackson-databind-2"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{node:any(com.fasterxml.jackson.databind.JsonNode)}.optional(#{fieldName:any(java.lang.String)})").bindType("java.util.Optional<com.fasterxml.jackson.databind.JsonNode>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-core-2", "jackson-databind-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"java.util.Optional.of(#{node:any(com.fasterxml.jackson.databind.JsonNode)}.get(#{fieldName:any(java.lang.String)}))").bindType("java.util.Optional<com.fasterxml.jackson.databind.JsonNode>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-core-2", "jackson-databind-2"})).build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{node:any(com.fasterxml.jackson.databind.JsonNode)}.optional(#{fieldName:any(java.lang.String)})").bindType("java.util.Optional<com.fasterxml.jackson.databind.JsonNode>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-core-2", "jackson-databind-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$3 == null) {
                        this.before$3 = JavaTemplate.builder((String)"java.util.Optional.ofNullable(#{node:any(com.fasterxml.jackson.databind.JsonNode)}.get(#{fieldName:any(java.lang.String)}))").bindType("java.util.Optional<com.fasterxml.jackson.databind.JsonNode>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-core-2", "jackson-databind-2"})).build();
                    }
                    if ((matcher = this.before$3.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{node:any(com.fasterxml.jackson.databind.JsonNode)}.optional(#{fieldName:any(java.lang.String)})").bindType("java.util.Optional<com.fasterxml.jackson.databind.JsonNode>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-core-2", "jackson-databind-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.fasterxml.jackson.databind.JsonNode", Boolean.valueOf(true)), new UsesType("java.util.Optional", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.fasterxml.jackson.databind.JsonNode asOptional(..)", true), new UsesMethod("com.fasterxml.jackson.databind.JsonNode get(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.fasterxml.jackson.databind.JsonNode asOptional(..)", true), new UsesMethod("com.fasterxml.jackson.databind.JsonNode path(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.fasterxml.jackson.databind.JsonNode get(..)", true), new UsesMethod("java.util.Optional of(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.fasterxml.jackson.databind.JsonNode get(..)", true), new UsesMethod("java.util.Optional ofNullable(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ObjectMapperValueToTreeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `Jackson2Rules.ObjectMapperValueToTree`";
        }

        public String getDescription() {
            return "Prefer `ObjectMapper#valueToTree(Object)` over more contrived and less efficient alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{objectMapper:any(com.fasterxml.jackson.databind.ObjectMapper)}.readTree(#{objectMapper}.writeValueAsBytes(#{object:any(java.lang.Object)}))").bindType("com.fasterxml.jackson.databind.JsonNode").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-core-2", "jackson-databind-2"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{objectMapper:any(com.fasterxml.jackson.databind.ObjectMapper)}.valueToTree(#{object:any(java.lang.Object)})").bindType("com.fasterxml.jackson.databind.JsonNode").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-core-2", "jackson-databind-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{objectMapper:any(com.fasterxml.jackson.databind.ObjectMapper)}.readTree(#{objectMapper}.writeValueAsString(#{object:any(java.lang.Object)}))").bindType("com.fasterxml.jackson.databind.JsonNode").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-core-2", "jackson-databind-2"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{objectMapper:any(com.fasterxml.jackson.databind.ObjectMapper)}.valueToTree(#{object:any(java.lang.Object)})").bindType("com.fasterxml.jackson.databind.JsonNode").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-core-2", "jackson-databind-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.fasterxml.jackson.databind.JsonNode", Boolean.valueOf(true)), new UsesType("com.fasterxml.jackson.databind.ObjectMapper", Boolean.valueOf(true)), new UsesMethod("com.fasterxml.jackson.databind.ObjectMapper readTree(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.fasterxml.jackson.databind.ObjectMapper writeValueAsBytes(..)", true), new UsesMethod("com.fasterxml.jackson.databind.ObjectMapper writeValueAsString(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ObjectMapperConvertValueWithClassRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `Jackson2Rules.ObjectMapperConvertValueWithClass`";
        }

        public String getDescription() {
            return "Prefer `ObjectMapper#convertValue(Object, Class)` over more contrived and less efficient alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{objectMapper:any(com.fasterxml.jackson.databind.ObjectMapper)}.readValue(#{objectMapper}.writeValueAsBytes(#{object:any(java.lang.Object)}), #{valueType:any(java.lang.Class<T>)})").bindType("T").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-core-2", "jackson-databind-2"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{objectMapper:any(com.fasterxml.jackson.databind.ObjectMapper)}.convertValue(#{object:any(java.lang.Object)}, #{valueType:any(java.lang.Class<T>)})").bindType("T").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-core-2", "jackson-databind-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{objectMapper:any(com.fasterxml.jackson.databind.ObjectMapper)}.readValue(#{objectMapper}.writeValueAsString(#{object:any(java.lang.Object)}), #{valueType:any(java.lang.Class<T>)})").bindType("T").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-core-2", "jackson-databind-2"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{objectMapper:any(com.fasterxml.jackson.databind.ObjectMapper)}.convertValue(#{object:any(java.lang.Object)}, #{valueType:any(java.lang.Class<T>)})").bindType("T").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-core-2", "jackson-databind-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.fasterxml.jackson.databind.ObjectMapper", Boolean.valueOf(true)), new UsesMethod("com.fasterxml.jackson.databind.ObjectMapper readValue(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.fasterxml.jackson.databind.ObjectMapper writeValueAsBytes(..)", true), new UsesMethod("com.fasterxml.jackson.databind.ObjectMapper writeValueAsString(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ObjectMapperConvertValueWithJavaTypeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `Jackson2Rules.ObjectMapperConvertValueWithJavaType`";
        }

        public String getDescription() {
            return "Prefer `ObjectMapper#convertValue(Object, JavaType)` over more contrived and less efficient alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{objectMapper:any(com.fasterxml.jackson.databind.ObjectMapper)}.readValue(#{objectMapper}.writeValueAsBytes(#{object:any(java.lang.Object)}), #{valueType:any(com.fasterxml.jackson.databind.JavaType)})").bindType("T").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-core-2", "jackson-databind-2"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{objectMapper:any(com.fasterxml.jackson.databind.ObjectMapper)}.convertValue(#{object:any(java.lang.Object)}, #{valueType:any(com.fasterxml.jackson.databind.JavaType)})").bindType("T").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-core-2", "jackson-databind-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{objectMapper:any(com.fasterxml.jackson.databind.ObjectMapper)}.readValue(#{objectMapper}.writeValueAsString(#{object:any(java.lang.Object)}), #{valueType:any(com.fasterxml.jackson.databind.JavaType)})").bindType("T").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-core-2", "jackson-databind-2"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{objectMapper:any(com.fasterxml.jackson.databind.ObjectMapper)}.convertValue(#{object:any(java.lang.Object)}, #{valueType:any(com.fasterxml.jackson.databind.JavaType)})").bindType("T").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-core-2", "jackson-databind-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.fasterxml.jackson.databind.JavaType", Boolean.valueOf(true)), new UsesType("com.fasterxml.jackson.databind.ObjectMapper", Boolean.valueOf(true)), new UsesMethod("com.fasterxml.jackson.databind.ObjectMapper readValue(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.fasterxml.jackson.databind.ObjectMapper writeValueAsBytes(..)", true), new UsesMethod("com.fasterxml.jackson.databind.ObjectMapper writeValueAsString(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ObjectMapperConvertValueWithTypeReferenceRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `Jackson2Rules.ObjectMapperConvertValueWithTypeReference`";
        }

        public String getDescription() {
            return "Prefer `ObjectMapper#convertValue(Object, TypeReference)` over more contrived and less efficient alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{objectMapper:any(com.fasterxml.jackson.databind.ObjectMapper)}.readValue(#{objectMapper}.writeValueAsBytes(#{object:any(java.lang.Object)}), #{valueTypeRef:any(com.fasterxml.jackson.core.type.TypeReference<T>)})").bindType("T").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-core-2", "jackson-databind-2"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{objectMapper:any(com.fasterxml.jackson.databind.ObjectMapper)}.convertValue(#{object:any(java.lang.Object)}, #{valueTypeRef:any(com.fasterxml.jackson.core.type.TypeReference<T>)})").bindType("T").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-core-2", "jackson-databind-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{objectMapper:any(com.fasterxml.jackson.databind.ObjectMapper)}.readValue(#{objectMapper}.writeValueAsString(#{object:any(java.lang.Object)}), #{valueTypeRef:any(com.fasterxml.jackson.core.type.TypeReference<T>)})").bindType("T").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-core-2", "jackson-databind-2"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{objectMapper:any(com.fasterxml.jackson.databind.ObjectMapper)}.convertValue(#{object:any(java.lang.Object)}, #{valueTypeRef:any(com.fasterxml.jackson.core.type.TypeReference<T>)})").bindType("T").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-core-2", "jackson-databind-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.fasterxml.jackson.core.type.TypeReference", Boolean.valueOf(true)), new UsesType("com.fasterxml.jackson.databind.ObjectMapper", Boolean.valueOf(true)), new UsesMethod("com.fasterxml.jackson.databind.ObjectMapper readValue(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.fasterxml.jackson.databind.ObjectMapper writeValueAsBytes(..)", true), new UsesMethod("com.fasterxml.jackson.databind.ObjectMapper writeValueAsString(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }
}

