/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class AssertJRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`AssertJRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to AssertJ expressions and statements.\n[Source](https://error-prone.picnic.tech/refasterrules/AssertJRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AssertThatOptionalDoubleRecipe(), new AssertThatOptionalIntRecipe(), new AssertThatOptionalLongRecipe(), new ObjectEnumerableContainsOneElementRecipe(), new ObjectEnumerableDoesNotContainOneElementRecipe(), new AssertThatSetContainsExactlyOneElementRecipe(), new AssertThatListsAreEqualRecipe(), new AssertThatSetsAreEqualRecipe(), new AssertThatMultisetsAreEqualRecipe(), new AssertThatMapContainsEntryRecipe(), new AssertThatStreamContainsAnyElementsOfRecipe(), new AssertThatStreamContainsAnyOfRecipe(), new AssertThatStreamContainsAllRecipe(), new AssertThatStreamContainsRecipe(), new AssertThatStreamContainsExactlyElementsOfRecipe(), new AssertThatStreamContainsExactlyRecipe(), new AssertThatStreamContainsExactlyInAnyOrderElementsOfRecipe(), new AssertThatStreamContainsExactlyInAnyOrderRecipe(), new AssertThatStreamContainsSequenceRecipe(), new AssertThatStreamContainsSubsequenceRecipe(), new AssertThatStreamDoesNotContainAnyElementsOfRecipe(), new AssertThatStreamDoesNotContainRecipe(), new AssertThatStreamDoesNotContainSequenceRecipe(), new AssertThatStreamHasSameElementsAsRecipe(), new AssertThatStreamContainsOnlyRecipe(), new AssertThatStreamIsSubsetOfRecipe(), new AssertThatStreamIsEmptyRecipe(), new AssertThatStreamIsNotEmptyRecipe(), new AssertThatStreamHasSizeRecipe(), new AssertThatPredicateAcceptsRecipe(), new AssertThatPredicateRejectsRecipe()});
    }

    @NullMarked
    public static class AssertThatOptionalDoubleRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatOptionalDouble`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatOptionalDouble {\n    \n    @BeforeTemplate\n    AbstractDoubleAssert<?> before(OptionalDouble optional, double expected) {\n        return assertThat(optional.getAsDouble()).isEqualTo(expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    OptionalDoubleAssert after(OptionalDouble optional, double expected) {\n        return assertThat(optional).hasValue(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.OptionalDouble)}.getAsDouble()).isEqualTo(#{expected:any(double)})").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractDoubleAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.OptionalDouble)}).hasValue(#{expected:any(double)})").bindType("org.assertj.core.api.OptionalDoubleAssert").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.OptionalDouble", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractDoubleAssert", Boolean.valueOf(true)), new UsesMethod("java.util.OptionalDouble getAsDouble(..)", true), new UsesMethod("org.assertj.core.api.AbstractDoubleAssert isEqualTo(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatOptionalIntRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatOptionalInt`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatOptionalInt {\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(OptionalInt optional, int expected) {\n        return assertThat(optional.getAsInt()).isEqualTo(expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    OptionalIntAssert after(OptionalInt optional, int expected) {\n        return assertThat(optional).hasValue(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.OptionalInt)}.getAsInt()).isEqualTo(#{expected:any(int)})").bindType("org.assertj.core.api.AbstractIntegerAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.OptionalInt)}).hasValue(#{expected:any(int)})").bindType("org.assertj.core.api.OptionalIntAssert").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.OptionalInt", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractIntegerAssert", Boolean.valueOf(true)), new UsesMethod("java.util.OptionalInt getAsInt(..)", true), new UsesMethod("org.assertj.core.api.AbstractIntegerAssert isEqualTo(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatOptionalLongRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatOptionalLong`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatOptionalLong {\n    \n    @BeforeTemplate\n    AbstractLongAssert<?> before(OptionalLong optional, long expected) {\n        return assertThat(optional.getAsLong()).isEqualTo(expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    OptionalLongAssert after(OptionalLong optional, long expected) {\n        return assertThat(optional).hasValue(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.OptionalLong)}.getAsLong()).isEqualTo(#{expected:any(long)})").bindType("org.assertj.core.api.AbstractLongAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractLongAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.OptionalLong)}).hasValue(#{expected:any(long)})").bindType("org.assertj.core.api.OptionalLongAssert").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.OptionalLong", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractLongAssert", Boolean.valueOf(true)), new UsesMethod("java.util.OptionalLong getAsLong(..)", true), new UsesMethod("org.assertj.core.api.AbstractLongAssert isEqualTo(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ObjectEnumerableContainsOneElementRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJRules.ObjectEnumerableContainsOneElement`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ObjectEnumerableContainsOneElement<S, T extends S> {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"unchecked\")\n    ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T element) {\n        return Refaster.anyOf(iterAssert.containsAnyOf(element), iterAssert.containsSequence(element), iterAssert.containsSubsequence(element));\n    }\n    \n    @AfterTemplate\n    @SuppressWarnings(value = \"unchecked\")\n    ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T element) {\n        return iterAssert.contains(element);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{iterAssert:any(org.assertj.core.api.ObjectEnumerableAssert<?, S>)}.containsAnyOf(#{element:any(T)})").bindType("org.assertj.core.api.ObjectEnumerableAssert<?, S>").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{iterAssert:any(org.assertj.core.api.ObjectEnumerableAssert<?, S>)}.contains(#{element:any(T)})").bindType("org.assertj.core.api.ObjectEnumerableAssert<?, S>").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{iterAssert:any(org.assertj.core.api.ObjectEnumerableAssert<?, S>)}.containsSequence(#{element:any(T)})").bindType("org.assertj.core.api.ObjectEnumerableAssert<?, S>").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{iterAssert:any(org.assertj.core.api.ObjectEnumerableAssert<?, S>)}.contains(#{element:any(T)})").bindType("org.assertj.core.api.ObjectEnumerableAssert<?, S>").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"#{iterAssert:any(org.assertj.core.api.ObjectEnumerableAssert<?, S>)}.containsSubsequence(#{element:any(T)})").bindType("org.assertj.core.api.ObjectEnumerableAssert<?, S>").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{iterAssert:any(org.assertj.core.api.ObjectEnumerableAssert<?, S>)}.contains(#{element:any(T)})").bindType("org.assertj.core.api.ObjectEnumerableAssert<?, S>").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.ObjectEnumerableAssert", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.api.ObjectEnumerableAssert containsAnyOf(..)", true), new UsesMethod("org.assertj.core.api.ObjectEnumerableAssert containsSequence(..)", true), new UsesMethod("org.assertj.core.api.ObjectEnumerableAssert containsSubsequence(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ObjectEnumerableDoesNotContainOneElementRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJRules.ObjectEnumerableDoesNotContainOneElement`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ObjectEnumerableDoesNotContainOneElement<S, T extends S> {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"unchecked\")\n    ObjectEnumerableAssert<?, S> before(ObjectEnumerableAssert<?, S> iterAssert, T element) {\n        return iterAssert.doesNotContainSequence(element);\n    }\n    \n    @AfterTemplate\n    @SuppressWarnings(value = \"unchecked\")\n    ObjectEnumerableAssert<?, S> after(ObjectEnumerableAssert<?, S> iterAssert, T element) {\n        return iterAssert.doesNotContain(element);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{iterAssert:any(org.assertj.core.api.ObjectEnumerableAssert<?, S>)}.doesNotContainSequence(#{element:any(T)})").bindType("org.assertj.core.api.ObjectEnumerableAssert<?, S>").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{iterAssert:any(org.assertj.core.api.ObjectEnumerableAssert<?, S>)}.doesNotContain(#{element:any(T)})").bindType("org.assertj.core.api.ObjectEnumerableAssert<?, S>").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.ObjectEnumerableAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.ObjectEnumerableAssert doesNotContainSequence(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatSetContainsExactlyOneElementRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatSetContainsExactlyOneElement`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatSetContainsExactlyOneElement<S, T extends S> {\n    \n    @BeforeTemplate\n    ObjectEnumerableAssert<?, S> before(Set<S> set, T element) {\n        return assertThat(set).containsOnly(element);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ObjectEnumerableAssert<?, S> after(Set<S> set, T element) {\n        return assertThat(set).containsExactly(element);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{set:any(java.util.Set<S>)}).containsOnly(#{element:any(T)})").bindType("org.assertj.core.api.ObjectEnumerableAssert<?, S>").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{set:any(java.util.Set<S>)}).containsExactly(#{element:any(T)})").bindType("org.assertj.core.api.ObjectEnumerableAssert<?, S>").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Set", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ObjectEnumerableAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractIterableAssert containsOnly(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatListsAreEqualRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatListsAreEqual`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatListsAreEqual<S, T extends S> {\n    \n    @BeforeTemplate\n    ListAssert<S> before(List<S> list1, Iterable<T> list2) {\n        return assertThat(list1).isEqualTo(list2);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<S> after(List<S> list1, Iterable<T> list2) {\n        return assertThat(list1).containsExactlyElementsOf(list2);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{list1:any(java.util.List<S>)}).isEqualTo(#{list2:any(java.lang.Iterable<T>)})").bindType("org.assertj.core.api.ListAssert<S>").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{list1:any(java.util.List<S>)}).containsExactlyElementsOf(#{list2:any(java.lang.Iterable<T>)})").bindType("org.assertj.core.api.ListAssert<S>").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.List", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ListAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true), new UsesMethod("org.assertj.core.api.ListAssert isEqualTo(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatSetsAreEqualRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatSetsAreEqual`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatSetsAreEqual<S, T extends S> {\n    \n    @BeforeTemplate\n    AbstractCollectionAssert<?, ?, S, ?> before(Set<S> set1, Iterable<T> set2) {\n        return Refaster.anyOf(assertThat(set1).isEqualTo(set2), assertThat(set1).containsExactlyInAnyOrderElementsOf(set2));\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractCollectionAssert<?, ?, S, ?> after(Set<S> set1, Iterable<T> set2) {\n        return assertThat(set1).hasSameElementsAs(set2);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{set1:any(java.util.Set<S>)}).isEqualTo(#{set2:any(java.lang.Iterable<T>)})").bindType("org.assertj.core.api.AbstractCollectionAssert<?, ?, S, ?>").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{set1:any(java.util.Set<S>)}).hasSameElementsAs(#{set2:any(java.lang.Iterable<T>)})").bindType("org.assertj.core.api.AbstractCollectionAssert<?, ?, S, ?>").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{set1:any(java.util.Set<S>)}).containsExactlyInAnyOrderElementsOf(#{set2:any(java.lang.Iterable<T>)})").bindType("org.assertj.core.api.AbstractCollectionAssert<?, ?, S, ?>").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{set1:any(java.util.Set<S>)}).hasSameElementsAs(#{set2:any(java.lang.Iterable<T>)})").bindType("org.assertj.core.api.AbstractCollectionAssert<?, ?, S, ?>").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Set", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractCollectionAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.api.AbstractIterableAssert containsExactlyInAnyOrderElementsOf(..)", true), new UsesMethod("org.assertj.core.api.AbstractIterableAssert isEqualTo(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatMultisetsAreEqualRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatMultisetsAreEqual`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatMultisetsAreEqual<S, T extends S> {\n    \n    @BeforeTemplate\n    AbstractCollectionAssert<?, ?, S, ?> before(Multiset<S> multiset1, Iterable<T> multiset2) {\n        return assertThat(multiset1).isEqualTo(multiset2);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractCollectionAssert<?, ?, S, ?> after(Multiset<S> multiset1, Iterable<T> multiset2) {\n        return assertThat(multiset1).containsExactlyInAnyOrderElementsOf(multiset2);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{multiset1:any(com.google.common.collect.Multiset<S>)}).isEqualTo(#{multiset2:any(java.lang.Iterable<T>)})").bindType("org.assertj.core.api.AbstractCollectionAssert<?, ?, S, ?>").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3", "guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{multiset1:any(com.google.common.collect.Multiset<S>)}).containsExactlyInAnyOrderElementsOf(#{multiset2:any(java.lang.Iterable<T>)})").bindType("org.assertj.core.api.AbstractCollectionAssert<?, ?, S, ?>").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3", "guava-33"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Multiset", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractCollectionAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractIterableAssert isEqualTo(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatMapContainsEntryRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatMapContainsEntry`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatMapContainsEntry<K, V> {\n    \n    @BeforeTemplate\n    ObjectAssert<V> before(Map<K, V> map, K key, V value) {\n        return assertThat(map.get(key)).isEqualTo(value);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    MapAssert<K, V> after(Map<K, V> map, K key, V value) {\n        return assertThat(map).containsEntry(key, value);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}.get(#{key:any(K)})).isEqualTo(#{value:any(V)})").bindType("org.assertj.core.api.ObjectAssert<V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.api.ObjectAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{map:any(java.util.Map<K, V>)}).containsEntry(#{key:any(K)}, #{value:any(V)})").bindType("org.assertj.core.api.MapAssert<K, V>").genericTypes(new String[]{"K", "V"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Map", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ObjectAssert", Boolean.valueOf(true)), new UsesMethod("java.util.Map get(..)", true), new UsesMethod("org.assertj.core.api.AbstractAssert isEqualTo(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatStreamContainsAnyElementsOfRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatStreamContainsAnyElementsOf`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamContainsAnyElementsOf<S, T extends S, U extends T> {\n    \n    @BeforeTemplate\n    IterableAssert<T> before(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends Iterable<T>> collector) {\n        return assertThat(stream.collect(collector)).containsAnyElementsOf(iterable);\n    }\n    \n    @BeforeTemplate\n    ListAssert<T> before2(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).containsAnyElementsOf(iterable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {\n        return assertThat(stream).containsAnyElementsOf(iterable);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.lang.Iterable<T>>)})).containsAnyElementsOf(#{iterable:any(java.lang.Iterable<U>)})").bindType("org.assertj.core.api.IterableAssert<T>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("org.assertj.core.api.IterableAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsAnyElementsOf(#{iterable:any(java.lang.Iterable<U>)})").bindType("org.assertj.core.api.ListAssert<S>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before2 == null) {
                        this.before2 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).containsAnyElementsOf(#{iterable:any(java.lang.Iterable<U>)})").bindType("org.assertj.core.api.ListAssert<T>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("java.util.List");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsAnyElementsOf(#{iterable:any(java.lang.Iterable<U>)})").bindType("org.assertj.core.api.ListAssert<S>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.Collector", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("org.assertj.core.api.AbstractIterableAssert containsAnyElementsOf(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.IterableAssert", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.List", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ListAssert", Boolean.valueOf(true))})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatStreamContainsAnyOfRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatStreamContainsAnyOf`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamContainsAnyOf<S, T extends S, U extends T> {\n    \n    @BeforeTemplate\n    IterableAssert<T> before(Stream<S> stream, U[] array, Collector<S, ?, ? extends Iterable<T>> collector) {\n        return assertThat(stream.collect(collector)).containsAnyOf(array);\n    }\n    \n    @BeforeTemplate\n    ListAssert<T> before2(Stream<S> stream, U[] array, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).containsAnyOf(array);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<S> after(Stream<S> stream, U[] array) {\n        return assertThat(stream).containsAnyOf(array);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.lang.Iterable<T>>)})).containsAnyOf(#{array:any(U[])})").bindType("org.assertj.core.api.IterableAssert<T>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("org.assertj.core.api.IterableAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsAnyOf(#{array:any(U[])})").bindType("org.assertj.core.api.ListAssert<S>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before2 == null) {
                        this.before2 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).containsAnyOf(#{array:any(U[])})").bindType("org.assertj.core.api.ListAssert<T>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("java.util.List");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsAnyOf(#{array:any(U[])})").bindType("org.assertj.core.api.ListAssert<S>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.Collector", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("org.assertj.core.api.AbstractIterableAssert containsAnyOf(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.IterableAssert", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.List", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ListAssert", Boolean.valueOf(true))})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatStreamContainsAllRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatStreamContainsAll`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamContainsAll<S, T extends S, U extends T> {\n    \n    @BeforeTemplate\n    IterableAssert<T> before(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends Iterable<T>> collector) {\n        return assertThat(stream.collect(collector)).containsAll(iterable);\n    }\n    \n    @BeforeTemplate\n    ListAssert<T> before2(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).containsAll(iterable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {\n        return assertThat(stream).containsAll(iterable);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.lang.Iterable<T>>)})).containsAll(#{iterable:any(java.lang.Iterable<U>)})").bindType("org.assertj.core.api.IterableAssert<T>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("org.assertj.core.api.IterableAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsAll(#{iterable:any(java.lang.Iterable<U>)})").bindType("org.assertj.core.api.ListAssert<S>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before2 == null) {
                        this.before2 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).containsAll(#{iterable:any(java.lang.Iterable<U>)})").bindType("org.assertj.core.api.ListAssert<T>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("java.util.List");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsAll(#{iterable:any(java.lang.Iterable<U>)})").bindType("org.assertj.core.api.ListAssert<S>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.Collector", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("org.assertj.core.api.AbstractIterableAssert containsAll(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.IterableAssert", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.List", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ListAssert", Boolean.valueOf(true))})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatStreamContainsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatStreamContains`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamContains<S, T extends S, U extends T> {\n    \n    @BeforeTemplate\n    IterableAssert<T> before(Stream<S> stream, U[] array, Collector<S, ?, ? extends Iterable<T>> collector) {\n        return assertThat(stream.collect(collector)).contains(array);\n    }\n    \n    @BeforeTemplate\n    ListAssert<T> before2(Stream<S> stream, U[] array, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).contains(array);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<S> after(Stream<S> stream, U[] array) {\n        return assertThat(stream).contains(array);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.lang.Iterable<T>>)})).contains(#{array:any(U[])})").bindType("org.assertj.core.api.IterableAssert<T>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("org.assertj.core.api.IterableAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).contains(#{array:any(U[])})").bindType("org.assertj.core.api.ListAssert<S>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before2 == null) {
                        this.before2 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).contains(#{array:any(U[])})").bindType("org.assertj.core.api.ListAssert<T>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("java.util.List");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).contains(#{array:any(U[])})").bindType("org.assertj.core.api.ListAssert<S>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.Collector", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("org.assertj.core.api.AbstractIterableAssert contains(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.IterableAssert", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.List", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ListAssert", Boolean.valueOf(true))})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatStreamContainsExactlyElementsOfRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatStreamContainsExactlyElementsOf`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamContainsExactlyElementsOf<S, T extends S, U extends T> {\n    \n    @BeforeTemplate\n    ListAssert<T> before(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).containsExactlyElementsOf(iterable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {\n        return assertThat(stream).containsExactlyElementsOf(iterable);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).containsExactlyElementsOf(#{iterable:any(java.lang.Iterable<U>)})").bindType("org.assertj.core.api.ListAssert<T>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("java.util.List");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsExactlyElementsOf(#{iterable:any(java.lang.Iterable<U>)})").bindType("org.assertj.core.api.ListAssert<S>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.List", Boolean.valueOf(true)), new UsesType("java.util.stream.Collector", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ListAssert", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("org.assertj.core.api.AbstractIterableAssert containsExactlyElementsOf(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatStreamContainsExactlyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatStreamContainsExactly`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamContainsExactly<S, T extends S, U extends T> {\n    \n    @BeforeTemplate\n    ListAssert<T> before(Stream<S> stream, U[] array, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).containsExactly(array);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<S> after(Stream<S> stream, U[] array) {\n        return assertThat(stream).containsExactly(array);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).containsExactly(#{array:any(U[])})").bindType("org.assertj.core.api.ListAssert<T>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("java.util.List");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsExactly(#{array:any(U[])})").bindType("org.assertj.core.api.ListAssert<S>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.List", Boolean.valueOf(true)), new UsesType("java.util.stream.Collector", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ListAssert", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("org.assertj.core.api.AbstractIterableAssert containsExactly(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatStreamContainsExactlyInAnyOrderElementsOfRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatStreamContainsExactlyInAnyOrderElementsOf`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamContainsExactlyInAnyOrderElementsOf<S, T extends S, U extends T> {\n    \n    @BeforeTemplate\n    ListAssert<T> before(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).containsExactlyInAnyOrderElementsOf(iterable);\n    }\n    \n    @BeforeTemplate\n    AbstractCollectionAssert<?, ?, T, ?> before2(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends Multiset<T>> collector) {\n        return assertThat(stream.collect(collector)).containsExactlyInAnyOrderElementsOf(iterable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {\n        return assertThat(stream).containsExactlyInAnyOrderElementsOf(iterable);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).containsExactlyInAnyOrderElementsOf(#{iterable:any(java.lang.Iterable<U>)})").bindType("org.assertj.core.api.ListAssert<T>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("java.util.List");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsExactlyInAnyOrderElementsOf(#{iterable:any(java.lang.Iterable<U>)})").bindType("org.assertj.core.api.ListAssert<S>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before2 == null) {
                        this.before2 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends com.google.common.collect.Multiset<T>>)})).containsExactlyInAnyOrderElementsOf(#{iterable:any(java.lang.Iterable<U>)})").bindType("org.assertj.core.api.AbstractCollectionAssert<?, ?, T, ?>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3", "guava-33"})).build();
                    }
                    if ((matcher = this.before2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("com.google.common.collect.Multiset");
                        this.maybeRemoveImport("org.assertj.core.api.AbstractCollectionAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsExactlyInAnyOrderElementsOf(#{iterable:any(java.lang.Iterable<U>)})").bindType("org.assertj.core.api.ListAssert<S>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.Collector", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("org.assertj.core.api.AbstractIterableAssert containsExactlyInAnyOrderElementsOf(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Multiset", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractCollectionAssert", Boolean.valueOf(true))}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.List", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ListAssert", Boolean.valueOf(true))})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatStreamContainsExactlyInAnyOrderRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatStreamContainsExactlyInAnyOrder`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamContainsExactlyInAnyOrder<S, T extends S, U extends T> {\n    \n    @BeforeTemplate\n    ListAssert<T> before(Stream<S> stream, U[] array, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).containsExactlyInAnyOrder(array);\n    }\n    \n    @BeforeTemplate\n    AbstractCollectionAssert<?, ?, T, ?> before2(Stream<S> stream, U[] array, Collector<S, ?, ? extends Multiset<T>> collector) {\n        return assertThat(stream.collect(collector)).containsExactlyInAnyOrder(array);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<S> after(Stream<S> stream, U[] array) {\n        return assertThat(stream).containsExactlyInAnyOrder(array);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).containsExactlyInAnyOrder(#{array:any(U[])})").bindType("org.assertj.core.api.ListAssert<T>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("java.util.List");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsExactlyInAnyOrder(#{array:any(U[])})").bindType("org.assertj.core.api.ListAssert<S>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before2 == null) {
                        this.before2 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends com.google.common.collect.Multiset<T>>)})).containsExactlyInAnyOrder(#{array:any(U[])})").bindType("org.assertj.core.api.AbstractCollectionAssert<?, ?, T, ?>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3", "guava-33"})).build();
                    }
                    if ((matcher = this.before2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("com.google.common.collect.Multiset");
                        this.maybeRemoveImport("org.assertj.core.api.AbstractCollectionAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsExactlyInAnyOrder(#{array:any(U[])})").bindType("org.assertj.core.api.ListAssert<S>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.Collector", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("org.assertj.core.api.AbstractIterableAssert containsExactlyInAnyOrder(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Multiset", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractCollectionAssert", Boolean.valueOf(true))}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.List", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ListAssert", Boolean.valueOf(true))})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatStreamContainsSequenceRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatStreamContainsSequence`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamContainsSequence<S, T extends S, U extends T> {\n    \n    @BeforeTemplate\n    ListAssert<T> before(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).containsSequence(iterable);\n    }\n    \n    @BeforeTemplate\n    ListAssert<T> before(Stream<S> stream, U[] iterable, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).containsSequence(iterable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {\n        return assertThat(stream).containsSequence(iterable);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).containsSequence(#{iterable:any(java.lang.Iterable<U>)})").bindType("org.assertj.core.api.ListAssert<T>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("java.util.List");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsSequence(#{iterable:any(java.lang.Iterable<U>)})").bindType("org.assertj.core.api.ListAssert<S>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).containsSequence(#{iterable:any(U[])})").bindType("org.assertj.core.api.ListAssert<T>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("java.util.List");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsSequence(#{iterable:any(java.lang.Iterable<U>)})").bindType("org.assertj.core.api.ListAssert<S>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.List", Boolean.valueOf(true)), new UsesType("java.util.stream.Collector", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ListAssert", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("org.assertj.core.api.AbstractIterableAssert containsSequence(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatStreamContainsSubsequenceRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatStreamContainsSubsequence`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamContainsSubsequence<S, T extends S, U extends T> {\n    \n    @BeforeTemplate\n    ListAssert<T> before(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).containsSubsequence(iterable);\n    }\n    \n    @BeforeTemplate\n    ListAssert<T> before(Stream<S> stream, U[] iterable, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).containsSubsequence(iterable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {\n        return assertThat(stream).containsSubsequence(iterable);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).containsSubsequence(#{iterable:any(java.lang.Iterable<U>)})").bindType("org.assertj.core.api.ListAssert<T>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("java.util.List");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsSubsequence(#{iterable:any(java.lang.Iterable<U>)})").bindType("org.assertj.core.api.ListAssert<S>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).containsSubsequence(#{iterable:any(U[])})").bindType("org.assertj.core.api.ListAssert<T>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("java.util.List");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsSubsequence(#{iterable:any(java.lang.Iterable<U>)})").bindType("org.assertj.core.api.ListAssert<S>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.List", Boolean.valueOf(true)), new UsesType("java.util.stream.Collector", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ListAssert", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("org.assertj.core.api.AbstractIterableAssert containsSubsequence(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatStreamDoesNotContainAnyElementsOfRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatStreamDoesNotContainAnyElementsOf`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamDoesNotContainAnyElementsOf<S, T extends S, U extends T> {\n    \n    @BeforeTemplate\n    IterableAssert<T> before(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends Iterable<T>> collector) {\n        return assertThat(stream.collect(collector)).doesNotContainAnyElementsOf(iterable);\n    }\n    \n    @BeforeTemplate\n    ListAssert<T> before2(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).doesNotContainAnyElementsOf(iterable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {\n        return assertThat(stream).doesNotContainAnyElementsOf(iterable);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.lang.Iterable<T>>)})).doesNotContainAnyElementsOf(#{iterable:any(java.lang.Iterable<U>)})").bindType("org.assertj.core.api.IterableAssert<T>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("org.assertj.core.api.IterableAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).doesNotContainAnyElementsOf(#{iterable:any(java.lang.Iterable<U>)})").bindType("org.assertj.core.api.ListAssert<S>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before2 == null) {
                        this.before2 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).doesNotContainAnyElementsOf(#{iterable:any(java.lang.Iterable<U>)})").bindType("org.assertj.core.api.ListAssert<T>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("java.util.List");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).doesNotContainAnyElementsOf(#{iterable:any(java.lang.Iterable<U>)})").bindType("org.assertj.core.api.ListAssert<S>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.Collector", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("org.assertj.core.api.AbstractIterableAssert doesNotContainAnyElementsOf(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.IterableAssert", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.List", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ListAssert", Boolean.valueOf(true))})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatStreamDoesNotContainRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatStreamDoesNotContain`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamDoesNotContain<S, T extends S, U extends T> {\n    \n    @BeforeTemplate\n    IterableAssert<T> before(Stream<S> stream, U[] array, Collector<S, ?, ? extends Iterable<T>> collector) {\n        return assertThat(stream.collect(collector)).doesNotContain(array);\n    }\n    \n    @BeforeTemplate\n    ListAssert<T> before2(Stream<S> stream, U[] array, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).doesNotContain(array);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<S> after(Stream<S> stream, U[] array) {\n        return assertThat(stream).doesNotContain(array);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.lang.Iterable<T>>)})).doesNotContain(#{array:any(U[])})").bindType("org.assertj.core.api.IterableAssert<T>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("org.assertj.core.api.IterableAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).doesNotContain(#{array:any(U[])})").bindType("org.assertj.core.api.ListAssert<S>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before2 == null) {
                        this.before2 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).doesNotContain(#{array:any(U[])})").bindType("org.assertj.core.api.ListAssert<T>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("java.util.List");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).doesNotContain(#{array:any(U[])})").bindType("org.assertj.core.api.ListAssert<S>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.Collector", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("org.assertj.core.api.AbstractIterableAssert doesNotContain(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.IterableAssert", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.List", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ListAssert", Boolean.valueOf(true))})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatStreamDoesNotContainSequenceRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatStreamDoesNotContainSequence`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamDoesNotContainSequence<S, T extends S, U extends T> {\n    \n    @BeforeTemplate\n    ListAssert<T> before(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).doesNotContainSequence(iterable);\n    }\n    \n    @BeforeTemplate\n    ListAssert<T> before(Stream<S> stream, U[] iterable, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).doesNotContainSequence(iterable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {\n        return assertThat(stream).doesNotContainSequence(iterable);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).doesNotContainSequence(#{iterable:any(java.lang.Iterable<U>)})").bindType("org.assertj.core.api.ListAssert<T>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("java.util.List");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).doesNotContainSequence(#{iterable:any(java.lang.Iterable<U>)})").bindType("org.assertj.core.api.ListAssert<S>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).doesNotContainSequence(#{iterable:any(U[])})").bindType("org.assertj.core.api.ListAssert<T>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("java.util.List");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).doesNotContainSequence(#{iterable:any(java.lang.Iterable<U>)})").bindType("org.assertj.core.api.ListAssert<S>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.List", Boolean.valueOf(true)), new UsesType("java.util.stream.Collector", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ListAssert", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("org.assertj.core.api.AbstractIterableAssert doesNotContainSequence(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatStreamHasSameElementsAsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatStreamHasSameElementsAs`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamHasSameElementsAs<S, T extends S, U extends T> {\n    \n    @BeforeTemplate\n    IterableAssert<T> before(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends Iterable<T>> collector) {\n        return assertThat(stream.collect(collector)).hasSameElementsAs(iterable);\n    }\n    \n    @BeforeTemplate\n    ListAssert<T> before2(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).hasSameElementsAs(iterable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<S> after(Stream<S> stream, Iterable<U> iterable) {\n        return assertThat(stream).hasSameElementsAs(iterable);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.lang.Iterable<T>>)})).hasSameElementsAs(#{iterable:any(java.lang.Iterable<U>)})").bindType("org.assertj.core.api.IterableAssert<T>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("org.assertj.core.api.IterableAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).hasSameElementsAs(#{iterable:any(java.lang.Iterable<U>)})").bindType("org.assertj.core.api.ListAssert<S>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before2 == null) {
                        this.before2 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).hasSameElementsAs(#{iterable:any(java.lang.Iterable<U>)})").bindType("org.assertj.core.api.ListAssert<T>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("java.util.List");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).hasSameElementsAs(#{iterable:any(java.lang.Iterable<U>)})").bindType("org.assertj.core.api.ListAssert<S>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.Collector", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("org.assertj.core.api.AbstractIterableAssert hasSameElementsAs(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.IterableAssert", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.List", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ListAssert", Boolean.valueOf(true))})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatStreamContainsOnlyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatStreamContainsOnly`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamContainsOnly<S, T extends S, U extends T> {\n    \n    @BeforeTemplate\n    IterableAssert<T> before(Stream<S> stream, U[] array, Collector<S, ?, ? extends Iterable<T>> collector) {\n        return assertThat(stream.collect(collector)).containsOnly(array);\n    }\n    \n    @BeforeTemplate\n    ListAssert<T> before2(Stream<S> stream, U[] array, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).containsOnly(array);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<S> after(Stream<S> stream, U[] array) {\n        return assertThat(stream).containsOnly(array);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.lang.Iterable<T>>)})).containsOnly(#{array:any(U[])})").bindType("org.assertj.core.api.IterableAssert<T>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("org.assertj.core.api.IterableAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsOnly(#{array:any(U[])})").bindType("org.assertj.core.api.ListAssert<S>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before2 == null) {
                        this.before2 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).containsOnly(#{array:any(U[])})").bindType("org.assertj.core.api.ListAssert<T>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("java.util.List");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).containsOnly(#{array:any(U[])})").bindType("org.assertj.core.api.ListAssert<S>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.Collector", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("org.assertj.core.api.AbstractIterableAssert containsOnly(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.IterableAssert", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.List", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ListAssert", Boolean.valueOf(true))})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatStreamIsSubsetOfRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatStreamIsSubsetOf`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamIsSubsetOf<S, T extends S, U extends T> {\n    \n    @BeforeTemplate\n    IterableAssert<T> before(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends Iterable<T>> collector) {\n        return assertThat(stream.collect(collector)).isSubsetOf(iterable);\n    }\n    \n    @BeforeTemplate\n    IterableAssert<T> before(Stream<S> stream, U[] iterable, Collector<S, ?, ? extends Iterable<T>> collector) {\n        return assertThat(stream.collect(collector)).isSubsetOf(iterable);\n    }\n    \n    @BeforeTemplate\n    ListAssert<T> before2(Stream<S> stream, Iterable<U> iterable, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).isSubsetOf(iterable);\n    }\n    \n    @BeforeTemplate\n    ListAssert<T> before2(Stream<S> stream, U[] iterable, Collector<S, ?, ? extends List<T>> collector) {\n        return assertThat(stream.collect(collector)).isSubsetOf(iterable);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    ListAssert<S> after(Stream<S> stream, U[] iterable) {\n        return assertThat(stream).isSubsetOf(iterable);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate before2;
                JavaTemplate before20;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.lang.Iterable<T>>)})).isSubsetOf(#{iterable:any(java.lang.Iterable<U>)})").bindType("org.assertj.core.api.IterableAssert<T>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("org.assertj.core.api.IterableAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).isSubsetOf(#{iterable:any(U[])})").bindType("org.assertj.core.api.ListAssert<S>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.lang.Iterable<T>>)})).isSubsetOf(#{iterable:any(U[])})").bindType("org.assertj.core.api.IterableAssert<T>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("org.assertj.core.api.IterableAssert");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).isSubsetOf(#{iterable:any(U[])})").bindType("org.assertj.core.api.ListAssert<S>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before2 == null) {
                        this.before2 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).isSubsetOf(#{iterable:any(java.lang.Iterable<U>)})").bindType("org.assertj.core.api.ListAssert<T>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("java.util.List");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).isSubsetOf(#{iterable:any(U[])})").bindType("org.assertj.core.api.ListAssert<S>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before20 == null) {
                        this.before20 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).isSubsetOf(#{iterable:any(U[])})").bindType("org.assertj.core.api.ListAssert<T>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before20.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("java.util.List");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).isSubsetOf(#{iterable:any(U[])})").bindType("org.assertj.core.api.ListAssert<S>").genericTypes(new String[]{"S", "T extends S", "U extends T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.Collector", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("org.assertj.core.api.AbstractIterableAssert isSubsetOf(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.IterableAssert", Boolean.valueOf(true)), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.List", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.ListAssert", Boolean.valueOf(true))})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatStreamIsEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatStreamIsEmpty`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamIsEmpty<S, T extends S> {\n    \n    @BeforeTemplate\n    void before(Stream<S> stream, Collector<S, ?, ? extends Iterable<T>> collector) {\n        assertThat(stream.collect(collector)).isEmpty();\n    }\n    \n    @BeforeTemplate\n    void before2(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector) {\n        assertThat(stream.collect(collector)).isEmpty();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Stream<S> stream) {\n        assertThat(stream).isEmpty();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.lang.Iterable<T>>)})).isEmpty();").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).isEmpty();").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before2 == null) {
                        this.before2 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).isEmpty();").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("java.util.List");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).isEmpty();").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.Collector", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("org.assertj.core.api.AbstractIterableAssert isEmpty(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatStreamIsNotEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatStreamIsNotEmpty`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamIsNotEmpty<S, T extends S> {\n    \n    @BeforeTemplate\n    void before(Stream<S> stream, Collector<S, ?, ? extends Iterable<T>> collector) {\n        assertThat(stream.collect(collector)).isNotEmpty();\n    }\n    \n    @BeforeTemplate\n    void before2(Stream<S> stream, Collector<S, ?, ? extends List<T>> collector) {\n        assertThat(stream.collect(collector)).isNotEmpty();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Stream<S> stream) {\n        assertThat(stream).isNotEmpty();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before2;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.lang.Iterable<T>>)})).isNotEmpty();").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).isNotEmpty();").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before2 == null) {
                        this.before2 = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}.collect(#{collector:any(java.util.stream.Collector<S, ?, ? extends java.util.List<T>>)})).isNotEmpty();").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collector");
                        this.maybeRemoveImport("java.util.List");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<S>)}).isNotEmpty();").genericTypes(new String[]{"S", "T extends S"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.Collector", Boolean.valueOf(true)), new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("org.assertj.core.api.AbstractIterableAssert isNotEmpty(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatStreamHasSizeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatStreamHasSize`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatStreamHasSize<T> {\n    \n    @BeforeTemplate\n    void before(Stream<T> stream, int size) {\n        assertThat(stream.count()).isEqualTo(size);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Stream<T> stream, int size) {\n        assertThat(stream).hasSize(size);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<T>)}.count()).isEqualTo(#{size:any(int)});").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{stream:any(java.util.stream.Stream<T>)}).hasSize(#{size:any(int)});").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.Stream count(..)", true), new UsesMethod("org.assertj.core.api.AbstractLongAssert isEqualTo(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatPredicateAcceptsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatPredicateAccepts`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatPredicateAccepts<T> {\n    \n    @BeforeTemplate\n    void before(Predicate<T> predicate, T object) {\n        assertThat(predicate.test(object)).isTrue();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Predicate<T> predicate, T object) {\n        assertThat(predicate).accepts(object);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{predicate:any(java.util.function.Predicate<T>)}.test(#{object:any(T)})).isTrue();").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{predicate:any(java.util.function.Predicate<T>)}).accepts(#{object:any(T)});").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Predicate", Boolean.valueOf(true)), new UsesMethod("java.util.function.Predicate test(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isTrue(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatPredicateRejectsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatPredicateRejects`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatPredicateRejects<T> {\n    \n    @BeforeTemplate\n    void before(Predicate<T> predicate, T object) {\n        assertThat(predicate.test(object)).isFalse();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(Predicate<T> predicate, T object) {\n        assertThat(predicate).rejects(object);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{predicate:any(java.util.function.Predicate<T>)}.test(#{object:any(T)})).isFalse();").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{predicate:any(java.util.function.Predicate<T>)}).rejects(#{object:any(T)});").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Predicate", Boolean.valueOf(true)), new UsesMethod("java.util.function.Predicate test(..)", true), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isFalse(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

