/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.util.Collections;
import java.util.Formattable;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tech.picnic.errorprone.utils.SourceCode;

@BugPattern(summary="String formatting can be deferred", link="https://error-prone.picnic.tech/bugpatterns/EagerStringFormatting", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, tags={"Performance", "Simplification"})
@AutoService(value={BugChecker.class})
public final class EagerStringFormatting
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> FORMATTABLE = Matchers.isSubtypeOf(Formattable.class);
    private static final Matcher<ExpressionTree> LOCALE = Matchers.isSubtypeOf(Locale.class);
    private static final Matcher<ExpressionTree> SLF4J_MARKER = Matchers.isSubtypeOf((String)"org.slf4j.Marker");
    private static final Matcher<ExpressionTree> THROWABLE = Matchers.isSubtypeOf(Throwable.class);
    private static final Matcher<ExpressionTree> REQUIRE_NON_NULL_INVOCATION = Matchers.staticMethod().onClass(Objects.class.getCanonicalName()).named("requireNonNull");
    private static final Matcher<ExpressionTree> GUAVA_GUARD_INVOCATION = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass(Preconditions.class.getCanonicalName()).namedAnyOf(new String[]{"checkArgument", "checkNotNull", "checkState"}), Matchers.staticMethod().onClass(Verify.class.getCanonicalName()).namedAnyOf(new String[]{"verify", "verifyNotNull"})});
    private static final Matcher<ExpressionTree> SLF4J_LOGGER_INVOCATION = MethodMatchers.instanceMethod().onDescendantOf("org.slf4j.Logger").namedAnyOf(new String[]{"trace", "debug", "info", "warn", "error"});
    private static final Matcher<ExpressionTree> STATIC_FORMAT_STRING = Matchers.staticMethod().onClass(String.class.getCanonicalName()).named("format");
    private static final Matcher<ExpressionTree> INSTANCE_FORMAT_STRING = MethodMatchers.instanceMethod().onDescendantOf(String.class.getCanonicalName()).named("formatted");
    private static final String MESSAGE_NEVER_NULL_ARGUMENT = "String formatting never yields `null` expression";

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (!(parent instanceof MethodInvocationTree)) {
            return Description.NO_MATCH;
        }
        MethodInvocationTree methodInvocation = (MethodInvocationTree)parent;
        return StringFormatExpression.tryCreate(tree, state).map(expr -> this.analyzeFormatStringContext((StringFormatExpression)expr, methodInvocation, state)).orElse(Description.NO_MATCH);
    }

    private Description analyzeFormatStringContext(StringFormatExpression stringFormat, MethodInvocationTree context, VisitorState state) {
        if (REQUIRE_NON_NULL_INVOCATION.matches((Tree)context, state)) {
            return this.analyzeRequireNonNullStringFormatContext(stringFormat, context);
        }
        if (GUAVA_GUARD_INVOCATION.matches((Tree)context, state)) {
            return this.analyzeGuavaGuardStringFormatContext(stringFormat, context, state);
        }
        if (SLF4J_LOGGER_INVOCATION.matches((Tree)context, state)) {
            return this.analyzeSlf4jLoggerStringFormatContext(stringFormat, context, state);
        }
        return Description.NO_MATCH;
    }

    private Description analyzeRequireNonNullStringFormatContext(StringFormatExpression stringFormat, MethodInvocationTree context) {
        List<? extends ExpressionTree> arguments = context.getArguments();
        if (arguments.size() != 2 || arguments.get(0).equals(stringFormat.expression())) {
            return this.buildDescription(context).setMessage(MESSAGE_NEVER_NULL_ARGUMENT).build();
        }
        if (stringFormat.arguments().stream().anyMatch(EagerStringFormatting::isNonFinalLocalVariable)) {
            return this.buildDescription(context).setMessage(this.message() + " (but this requires introducing an effectively final variable)").build();
        }
        return this.describeMatch(context, (Fix)SuggestedFix.prefixWith((Tree)stringFormat.expression(), (String)"() -> "));
    }

    private Description analyzeGuavaGuardStringFormatContext(StringFormatExpression stringFormat, MethodInvocationTree context, VisitorState state) {
        List<? extends ExpressionTree> arguments = context.getArguments();
        if (arguments.get(0).equals(stringFormat.expression())) {
            return this.buildDescription(context).setMessage(MESSAGE_NEVER_NULL_ARGUMENT).build();
        }
        if (stringFormat.simplifiableFormatString().isEmpty() || arguments.size() > 2) {
            return this.createSimplificationSuggestion(context, "Guava");
        }
        return this.describeMatch(context, (Fix)stringFormat.suggestFlattening("%s", state));
    }

    private Description analyzeSlf4jLoggerStringFormatContext(StringFormatExpression stringFormat, MethodInvocationTree context, VisitorState state) {
        int rightOffset;
        if (stringFormat.simplifiableFormatString().isEmpty()) {
            return this.createSimplificationSuggestion(context, "SLF4J");
        }
        List<? extends ExpressionTree> arguments = context.getArguments();
        int leftOffset = SLF4J_MARKER.matches((Tree)arguments.get(0), state) ? 1 : 0;
        int n = rightOffset = THROWABLE.matches((Tree)arguments.get(arguments.size() - 1), state) ? 1 : 0;
        if (arguments.size() != leftOffset + 1 + rightOffset) {
            return this.createSimplificationSuggestion(context, "SLF4J");
        }
        return this.describeMatch(context, (Fix)stringFormat.suggestFlattening("{}", state));
    }

    private static boolean isNonFinalLocalVariable(Tree tree) {
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        return symbol instanceof Symbol.VarSymbol && symbol.owner instanceof Symbol.MethodSymbol && !ASTHelpers.isConsideredFinal((Symbol)symbol);
    }

    private Description createSimplificationSuggestion(MethodInvocationTree context, String library) {
        return this.buildDescription(context).setMessage("%s (assuming that %s's simplified formatting support suffices)".formatted(this.message(), library)).build();
    }

    private record StringFormatExpression(MethodInvocationTree expression, Tree formatString, ImmutableList<ExpressionTree> arguments, Optional<String> simplifiableFormatString) {
        private SuggestedFix suggestFlattening(String newPlaceholder, VisitorState state) {
            return SuggestedFix.replace((Tree)this.expression(), (String)Stream.concat(Stream.of(this.deriveFormatStringExpression(newPlaceholder, state)), this.arguments().stream().map(arg -> SourceCode.treeToString((Tree)arg, (VisitorState)state))).collect(Collectors.joining(", ")));
        }

        private String deriveFormatStringExpression(String newPlaceholder, VisitorState state) {
            String derivative = String.format(this.simplifiableFormatString().orElseThrow(() -> new VerifyException("Format string cannot be simplified")), Collections.nCopies(this.arguments().size(), newPlaceholder).toArray());
            return derivative.equals(ASTHelpers.constValue((Tree)this.formatString(), String.class)) ? SourceCode.treeToString((Tree)this.formatString(), (VisitorState)state) : SourceCode.toStringConstantExpression((Object)derivative, (VisitorState)state);
        }

        private static Optional<StringFormatExpression> tryCreate(MethodInvocationTree tree, VisitorState state) {
            if (INSTANCE_FORMAT_STRING.matches((Tree)tree, state)) {
                return Optional.of(StringFormatExpression.create(tree, Objects.requireNonNull(ASTHelpers.getReceiver((ExpressionTree)tree), "Receiver unexpectedly absent"), (ImmutableList<ExpressionTree>)ImmutableList.copyOf(tree.getArguments()), state));
            }
            if (STATIC_FORMAT_STRING.matches((Tree)tree, state)) {
                List<? extends ExpressionTree> arguments = tree.getArguments();
                int argOffset = LOCALE.matches((Tree)arguments.get(0), state) ? 1 : 0;
                return Optional.of(StringFormatExpression.create(tree, arguments.get(argOffset), (ImmutableList<ExpressionTree>)ImmutableList.copyOf(arguments.subList(argOffset + 1, arguments.size())), state));
            }
            return Optional.empty();
        }

        private static StringFormatExpression create(MethodInvocationTree expression, Tree formatString, ImmutableList<ExpressionTree> arguments, VisitorState state) {
            return new StringFormatExpression(expression, formatString, arguments, Optional.ofNullable((String)ASTHelpers.constValue((Tree)formatString, String.class)).filter(template -> StringFormatExpression.isSimplifiable(template, arguments, state)));
        }

        private static boolean isSimplifiable(String formatString, ImmutableList<ExpressionTree> arguments, VisitorState state) {
            if (arguments.stream().anyMatch(arg -> FORMATTABLE.matches((Tree)arg, state))) {
                return false;
            }
            int placeholderCount = 0;
            int p = formatString.indexOf(37);
            while (p != -1) {
                if (p == formatString.length() - 1) {
                    return false;
                }
                char modifier = formatString.charAt(p + 1);
                if (modifier == 's') {
                    ++placeholderCount;
                } else if (modifier != '%') {
                    return false;
                }
                p = formatString.indexOf(37, p + 2);
            }
            return placeholderCount == arguments.size();
        }
    }
}

