/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.util.Name;

@BugPattern(summary="Prefer `.isNull()` and `.isNotNull()` over more verbose alternatives", link="https://error-prone.picnic.tech/bugpatterns/AssertJNullnessAssertion", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Simplification"})
@AutoService(value={BugChecker.class})
public final class AssertJNullnessAssertion
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final ImmutableSet<String> POSITIVE_ASSERTION_METHODS = ImmutableSet.of((Object)"isEqualTo", (Object)"isSameAs");
    private static final ImmutableSet<String> NEGATIVE_ASSERTION_METHODS = ImmutableSet.of((Object)"isNotEqualTo", (Object)"isNotSameAs");
    private static final Matcher<MethodInvocationTree> VERBOSE_NULL_ASSERTION = Matchers.allOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onDescendantOf("org.assertj.core.api.Assert").namedAnyOf((Iterable)Sets.union(POSITIVE_ASSERTION_METHODS, NEGATIVE_ASSERTION_METHODS)), Matchers.argumentCount((int)1), Matchers.argument((int)0, (Matcher)Matchers.nullLiteral())});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!VERBOSE_NULL_ASSERTION.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        String replacementAssertion = AssertJNullnessAssertion.isPositiveAssertion(tree) ? "isNull" : "isNotNull";
        SuggestedFix.Builder fix = SuggestedFixes.renameMethodInvocation((MethodInvocationTree)tree, (String)replacementAssertion, (VisitorState)state).toBuilder();
        tree.getArguments().forEach(arg -> fix.merge(SuggestedFix.delete((Tree)arg)));
        return this.describeMatch(tree, (Fix)fix.build());
    }

    private static boolean isPositiveAssertion(MethodInvocationTree tree) {
        return POSITIVE_ASSERTION_METHODS.contains((Object)((Name)ASTHelpers.getSymbol((MethodInvocationTree)tree).getSimpleName()).toString());
    }
}

