package tech.picnic.errorprone.refasterrules;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.*;
import org.openrewrite.java.template.Primitive;
import org.openrewrite.java.template.function.*;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.*;

import javax.annotation.Generated;
import java.util.*;

import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;

/**
 * OpenRewrite recipes created for Refaster template {@code tech.picnic.errorprone.refasterrules.WebClientRules}.
 */
@SuppressWarnings("all")
@Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
public class WebClientRulesRecipes extends Recipe {
    /**
     * Instantiates a new instance.
     */
    public WebClientRulesRecipes() {}

    @Override
    public String getDisplayName() {
        //language=markdown
        return "`WebClientRules` Refaster recipes";
    }

    @Override
    public String getDescription() {
        //language=markdown
        return "Refaster rules related to expressions dealing with `org.springframework.web.reactive.function.client.WebClient` and related types.\n[Source](https://error-prone.picnic.tech/refasterrules/WebClientRules).";
    }

    @Override
    public List<Recipe> getRecipeList() {
        return Arrays.asList(
                new BodyValueRecipe(),
                new WebClientGetRecipe(),
                new WebClientHeadRecipe(),
                new WebClientOptionsRecipe(),
                new WebClientPatchRecipe(),
                new WebClientPostRecipe(),
                new WebClientPutRecipe()
        );
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code WebClientRules.BodyValue}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class BodyValueRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public BodyValueRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `WebClientRules.BodyValue`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `RequestBodySpec#bodyValue(Object)` over more contrived alternatives.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{requestBodySpec:any(org.springframework.web.reactive.function.client.WebClient.RequestBodySpec)}.body(org.springframework.web.reactive.function.BodyInserters.fromValue(#{value:any(T)}))")
                                .bindType("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec<?>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "spring-webflux-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.springframework.web.reactive.function.BodyInserters");
                        maybeRemoveImport("org.springframework.web.reactive.function.BodyInserters.fromValue");
                        if (after == null) {
                            after = JavaTemplate.builder("#{requestBodySpec:any(org.springframework.web.reactive.function.client.WebClient.RequestBodySpec)}.bodyValue(#{value:any(T)})")
                                    .bindType("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec<?>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "spring-webflux-6"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{requestBodySpec:any(org.springframework.test.web.reactive.server.WebTestClient.RequestBodySpec)}.body(org.springframework.web.reactive.function.BodyInserters.fromValue(#{value:any(T)}))")
                                .bindType("org.springframework.test.web.reactive.server.WebTestClient.RequestHeadersSpec<?>")
                                .genericTypes("T")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "spring-test-6", "spring-webflux-6"))
                                .build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.springframework.web.reactive.function.BodyInserters");
                        maybeRemoveImport("org.springframework.web.reactive.function.BodyInserters.fromValue");
                        if (after == null) {
                            after = JavaTemplate.builder("#{requestBodySpec:any(org.springframework.web.reactive.function.client.WebClient.RequestBodySpec)}.bodyValue(#{value:any(T)})")
                                    .bindType("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec<?>")
                                    .genericTypes("T")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "spring-webflux-6"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0), matcher.parameter(1)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.and(
                            new UsesMethod<>("org.springframework.web.reactive.function.BodyInserters fromValue(..)", true),
                            Preconditions.or(
                                    new UsesMethod<>("org.springframework.test.web.reactive.server.WebTestClient.RequestBodySpec body(..)", true),
                                    Preconditions.and(
                                            new UsesType<>("org.springframework.web.reactive.function.client.WebClient.RequestBodySpec", true),
                                            new UsesType<>("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec", true),
                                            new UsesMethod<>("org.springframework.web.reactive.function.client.WebClient.RequestBodySpec body(..)", true)
                                    )
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code WebClientRules.WebClientGet}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class WebClientGetRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public WebClientGetRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `WebClientRules.WebClientGet`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `WebClient#get()` over `WebClient#method(HttpMethod)` with `HttpMethod#GET`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.method(org.springframework.http.HttpMethod.GET)")
                                .bindType("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "spring-webflux-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.springframework.http.HttpMethod");
                        maybeRemoveImport("org.springframework.http.HttpMethod.GET");
                        if (after == null) {
                            after = JavaTemplate.builder("#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.get()")
                                    .bindType("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "spring-webflux-6"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{webClient:any(org.springframework.test.web.reactive.server.WebTestClient)}.method(org.springframework.http.HttpMethod.GET)")
                                .bindType("org.springframework.test.web.reactive.server.WebTestClient.RequestHeadersSpec<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "spring-test-6"))
                                .build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.springframework.test.web.reactive.server.WebTestClient");
                        maybeRemoveImport("org.springframework.http.HttpMethod");
                        maybeRemoveImport("org.springframework.http.HttpMethod.GET");
                        if (after == null) {
                            after = JavaTemplate.builder("#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.get()")
                                    .bindType("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "spring-webflux-6"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.or(
                            Preconditions.and(
                                    new UsesType<>("org.springframework.test.web.reactive.server.WebTestClient", true),
                                    new UsesMethod<>("org.springframework.test.web.reactive.server.WebTestClient method(..)", true)
                            ),
                            Preconditions.and(
                                    new UsesType<>("org.springframework.web.reactive.function.client.WebClient", true),
                                    new UsesType<>("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec", true),
                                    new UsesMethod<>("org.springframework.web.reactive.function.client.WebClient method(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code WebClientRules.WebClientHead}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class WebClientHeadRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public WebClientHeadRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `WebClientRules.WebClientHead`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `WebClient#head()` over `WebClient#method(HttpMethod)` with `HttpMethod#HEAD`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.method(org.springframework.http.HttpMethod.HEAD)")
                                .bindType("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "spring-webflux-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.springframework.http.HttpMethod");
                        maybeRemoveImport("org.springframework.http.HttpMethod.HEAD");
                        if (after == null) {
                            after = JavaTemplate.builder("#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.head()")
                                    .bindType("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "spring-webflux-6"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{webClient:any(org.springframework.test.web.reactive.server.WebTestClient)}.method(org.springframework.http.HttpMethod.HEAD)")
                                .bindType("org.springframework.test.web.reactive.server.WebTestClient.RequestHeadersSpec<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "spring-test-6"))
                                .build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.springframework.test.web.reactive.server.WebTestClient");
                        maybeRemoveImport("org.springframework.http.HttpMethod");
                        maybeRemoveImport("org.springframework.http.HttpMethod.HEAD");
                        if (after == null) {
                            after = JavaTemplate.builder("#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.head()")
                                    .bindType("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "spring-webflux-6"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.or(
                            Preconditions.and(
                                    new UsesType<>("org.springframework.test.web.reactive.server.WebTestClient", true),
                                    new UsesMethod<>("org.springframework.test.web.reactive.server.WebTestClient method(..)", true)
                            ),
                            Preconditions.and(
                                    new UsesType<>("org.springframework.web.reactive.function.client.WebClient", true),
                                    new UsesType<>("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec", true),
                                    new UsesMethod<>("org.springframework.web.reactive.function.client.WebClient method(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code WebClientRules.WebClientOptions}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class WebClientOptionsRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public WebClientOptionsRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `WebClientRules.WebClientOptions`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `WebClient#options()` over `WebClient#method(HttpMethod)` with `HttpMethod#OPTIONS`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.method(org.springframework.http.HttpMethod.OPTIONS)")
                                .bindType("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "spring-webflux-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.springframework.http.HttpMethod");
                        maybeRemoveImport("org.springframework.http.HttpMethod.OPTIONS");
                        if (after == null) {
                            after = JavaTemplate.builder("#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.options()")
                                    .bindType("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "spring-webflux-6"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{webClient:any(org.springframework.test.web.reactive.server.WebTestClient)}.method(org.springframework.http.HttpMethod.OPTIONS)")
                                .bindType("org.springframework.test.web.reactive.server.WebTestClient.RequestHeadersSpec<?>")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "spring-test-6"))
                                .build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.springframework.test.web.reactive.server.WebTestClient");
                        maybeRemoveImport("org.springframework.http.HttpMethod");
                        maybeRemoveImport("org.springframework.http.HttpMethod.OPTIONS");
                        if (after == null) {
                            after = JavaTemplate.builder("#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.options()")
                                    .bindType("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec<?>")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "spring-webflux-6"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.or(
                            Preconditions.and(
                                    new UsesType<>("org.springframework.test.web.reactive.server.WebTestClient", true),
                                    new UsesMethod<>("org.springframework.test.web.reactive.server.WebTestClient method(..)", true)
                            ),
                            Preconditions.and(
                                    new UsesType<>("org.springframework.web.reactive.function.client.WebClient", true),
                                    new UsesType<>("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec", true),
                                    new UsesMethod<>("org.springframework.web.reactive.function.client.WebClient method(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code WebClientRules.WebClientPatch}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class WebClientPatchRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public WebClientPatchRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `WebClientRules.WebClientPatch`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `WebClient#patch()` over `WebClient#method(HttpMethod)` with `HttpMethod#PATCH`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.method(org.springframework.http.HttpMethod.PATCH)")
                                .bindType("org.springframework.web.reactive.function.client.WebClient.RequestBodyUriSpec")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "spring-webflux-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.springframework.http.HttpMethod");
                        maybeRemoveImport("org.springframework.http.HttpMethod.PATCH");
                        if (after == null) {
                            after = JavaTemplate.builder("#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.patch()")
                                    .bindType("org.springframework.web.reactive.function.client.WebClient.RequestBodyUriSpec")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "spring-webflux-6"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{webClient:any(org.springframework.test.web.reactive.server.WebTestClient)}.method(org.springframework.http.HttpMethod.PATCH)")
                                .bindType("org.springframework.test.web.reactive.server.WebTestClient.RequestBodyUriSpec")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "spring-test-6"))
                                .build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.springframework.test.web.reactive.server.WebTestClient");
                        maybeRemoveImport("org.springframework.http.HttpMethod");
                        maybeRemoveImport("org.springframework.http.HttpMethod.PATCH");
                        if (after == null) {
                            after = JavaTemplate.builder("#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.patch()")
                                    .bindType("org.springframework.web.reactive.function.client.WebClient.RequestBodyUriSpec")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "spring-webflux-6"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.or(
                            Preconditions.and(
                                    new UsesType<>("org.springframework.test.web.reactive.server.WebTestClient", true),
                                    new UsesMethod<>("org.springframework.test.web.reactive.server.WebTestClient method(..)", true)
                            ),
                            Preconditions.and(
                                    new UsesType<>("org.springframework.web.reactive.function.client.WebClient", true),
                                    new UsesType<>("org.springframework.web.reactive.function.client.WebClient.RequestBodyUriSpec", true),
                                    new UsesMethod<>("org.springframework.web.reactive.function.client.WebClient method(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code WebClientRules.WebClientPost}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class WebClientPostRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public WebClientPostRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `WebClientRules.WebClientPost`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `WebClient#post()` over `WebClient#method(HttpMethod)` with `HttpMethod#POST`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.method(org.springframework.http.HttpMethod.POST)")
                                .bindType("org.springframework.web.reactive.function.client.WebClient.RequestBodyUriSpec")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "spring-webflux-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.springframework.http.HttpMethod");
                        maybeRemoveImport("org.springframework.http.HttpMethod.POST");
                        if (after == null) {
                            after = JavaTemplate.builder("#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.post()")
                                    .bindType("org.springframework.web.reactive.function.client.WebClient.RequestBodyUriSpec")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "spring-webflux-6"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{webClient:any(org.springframework.test.web.reactive.server.WebTestClient)}.method(org.springframework.http.HttpMethod.POST)")
                                .bindType("org.springframework.test.web.reactive.server.WebTestClient.RequestBodyUriSpec")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "spring-test-6"))
                                .build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.springframework.test.web.reactive.server.WebTestClient");
                        maybeRemoveImport("org.springframework.http.HttpMethod");
                        maybeRemoveImport("org.springframework.http.HttpMethod.POST");
                        if (after == null) {
                            after = JavaTemplate.builder("#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.post()")
                                    .bindType("org.springframework.web.reactive.function.client.WebClient.RequestBodyUriSpec")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "spring-webflux-6"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.or(
                            Preconditions.and(
                                    new UsesType<>("org.springframework.test.web.reactive.server.WebTestClient", true),
                                    new UsesMethod<>("org.springframework.test.web.reactive.server.WebTestClient method(..)", true)
                            ),
                            Preconditions.and(
                                    new UsesType<>("org.springframework.web.reactive.function.client.WebClient", true),
                                    new UsesType<>("org.springframework.web.reactive.function.client.WebClient.RequestBodyUriSpec", true),
                                    new UsesMethod<>("org.springframework.web.reactive.function.client.WebClient method(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

    /**
     * OpenRewrite recipe created for Refaster template {@code WebClientRules.WebClientPut}.
     */
    @SuppressWarnings("all")
    @NullMarked
    @Generated("org.openrewrite.java.template.processor.RefasterTemplateProcessor")
    public static class WebClientPutRecipe extends Recipe {

        /**
         * Instantiates a new instance.
         */
        public WebClientPutRecipe() {}

        @Override
        public String getDisplayName() {
            //language=markdown
            return "Refaster template `WebClientRules.WebClientPut`";
        }

        @Override
        public String getDescription() {
            //language=markdown
            return "Prefer `WebClient#put()` over `WebClient#method(HttpMethod)` with `HttpMethod#PUT`.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                @Override
                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (before == null) {
                        before = JavaTemplate.builder("#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.method(org.springframework.http.HttpMethod.PUT)")
                                .bindType("org.springframework.web.reactive.function.client.WebClient.RequestBodyUriSpec")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "spring-webflux-6"))
                                .build();
                    }
                    if ((matcher = before.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.springframework.http.HttpMethod");
                        maybeRemoveImport("org.springframework.http.HttpMethod.PUT");
                        if (after == null) {
                            after = JavaTemplate.builder("#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.put()")
                                    .bindType("org.springframework.web.reactive.function.client.WebClient.RequestBodyUriSpec")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "spring-webflux-6"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    if (before0 == null) {
                        before0 = JavaTemplate.builder("#{webClient:any(org.springframework.test.web.reactive.server.WebTestClient)}.method(org.springframework.http.HttpMethod.PUT)")
                                .bindType("org.springframework.test.web.reactive.server.WebTestClient.RequestBodyUriSpec")
                                .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "spring-test-6"))
                                .build();
                    }
                    if ((matcher = before0.matcher(getCursor())).find()) {
                        maybeRemoveImport("org.springframework.test.web.reactive.server.WebTestClient");
                        maybeRemoveImport("org.springframework.http.HttpMethod");
                        maybeRemoveImport("org.springframework.http.HttpMethod.PUT");
                        if (after == null) {
                            after = JavaTemplate.builder("#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.put()")
                                    .bindType("org.springframework.web.reactive.function.client.WebClient.RequestBodyUriSpec")
                                    .javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, "spring-webflux-6"))
                                    .build();
                        }
                        return embed(
                                after.apply(getCursor(), elem.getCoordinates().replace(), matcher.parameter(0)),
                                getCursor(),
                                ctx,
                                SHORTEN_NAMES
                        );
                    }
                    return super.visitMethodInvocation(elem, ctx);
                }

            };
            return Preconditions.check(
                    Preconditions.or(
                            Preconditions.and(
                                    new UsesType<>("org.springframework.test.web.reactive.server.WebTestClient", true),
                                    new UsesMethod<>("org.springframework.test.web.reactive.server.WebTestClient method(..)", true)
                            ),
                            Preconditions.and(
                                    new UsesType<>("org.springframework.web.reactive.function.client.WebClient", true),
                                    new UsesType<>("org.springframework.web.reactive.function.client.WebClient.RequestBodyUriSpec", true),
                                    new UsesMethod<>("org.springframework.web.reactive.function.client.WebClient method(..)", true)
                            )
                    ),
                    javaVisitor
            );
        }
    }

}
